<?php $__env->startSection('content'); ?>

    <div class="page-blue ireport" id="home">
        <div class="row">
            <div class="col-lg-6 col-md-12">
                <div class="mx-auto justify-content-center align-items-center hero-content-desktop"
                    style="padding:120px 0px 0px 150px; width:80%;">
                    <h3 class="fw-bold">Camp Investment Company Limited (CICL) Integrated Report <?php echo e($year); ?></h3>
                    <p class="smaller-text">This Integrated Report provides information about the strategy, activities
                        and performance of
                        Phoenix Beverages Limited (PhoenixBev or the Group) for the twelve months from 1 July 2024 to 30
                        June <?php echo e($year); ?>.
                        <br></br>
                        It is structured around the matters most material to the Group's ability to create value in the
                        short-,
                        medium- and longterm.
                        The activities of our operations in Mauritius and Réunion Island are included in the reporting
                        boundary..
                    </p>
                    <div class="cta">
                        <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_annual_reports/2024/PBL_IAR_2024_V1.pdf')); ?>"
                                    download="PBL_IAR_2024_V1.pdf" target="_blank">
                        <button class="button pbg-button pbg-shadow-dash">Download Full PDF</button>
                        </a>
                    </div>
                </div>

                <!-- Mobile Hero Content -->
                <div class="hero-content-mobile d-lg-none">
                    <div class="container">
                        <div class="text-center">
                            <h3 class="fw-bold mb-3">Camp Investment Company Limited (CICL) Integrated Report <?php echo e($year); ?></h3>
                            <p class="smaller-text mb-4">This Integrated Report provides information about the strategy, activities
                                and performance of Phoenix Beverages Limited (PhoenixBev or the Group) for the twelve months from 1 July 2024 to 30
                                June <?php echo e($year); ?>. It is structured around the matters most material to the Group's ability to create value in the
                                short-, medium- and longterm. The activities of our operations in Mauritius and Réunion Island are included in the reporting
                                boundary.</p>
                            <div class="cta">
                                <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_annual_reports/2024/PBL_IAR_2024_V1.pdf')); ?>"
                                            download="PBL_IAR_2024_V1.pdf" target="_blank">
                                <button class="button pbg-button pbg-shadow-dash">Download Full PDF</button>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-lg-6 col-md-12">
                <img src="<?php echo e(asset('images/investor-relations/reports/annual-report-2024.png')); ?>" alt="integrated report"
                    class="responsive-image" />
            </div>
        </div>

    </div>


    <div class="ir-section" id="finance-at-a-glance">
        <div class="container w-75 mx-auto">
            <h3 class="py-5 text-center" data-aos="fade-down" data-aos-duration="500" data-aos-easing="linear">Financial Performance</h3>
            <div class="row pb-6 text-center financial-performance-grid">
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="50" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Team Member</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/fluent_people-team-16-regular.png')); ?>" alt="team" />
                                </div>
                                <div class="">
                                    <span class="fs-3">+</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="1750"
                                        data-speed="10000">1750</span>
                                    <span class="green-caret">
                                        <img src="<?php echo e(asset('icons/Vector_7.png')); ?>" alt="caret-up"> 2.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="100" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue (<?php echo e($year); ?>)</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/clarity_container-volume-line.png')); ?>"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">2.44</span><span class="fs-3">M HL</span>
                                    <span class="red-caret">
                                        <img src="<?php echo e(asset('icons/Vector_6.png')); ?>" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="150" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Turnover </h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/ph_coin.png')); ?>" alt="ph_coin" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR </span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="10609"
                                        data-speed="10000">10 609</span> <span class="fs-4">M</span>
                                    <span class="red-caret">
                                        <img src="<?php echo e(asset('icons/Vector_6.png')); ?>" alt="caret-down"> 0.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="200" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Operating Profit</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/fluent_money-20-regular.png')); ?>" alt="money" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR </span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="809"
                                        data-speed="10000">809</span>
                                    <span class="fs-4">M </span>
                                    <span class="green-caret">
                                        <img src="<?php echo e(asset('icons/Vector_7.png')); ?>" alt="caret-up"> 10%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="250" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Net Profit after Tax</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/fluent_coin-stack-24-regular.png')); ?>"
                                        alt="coin_stack" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="732"
                                        data-speed="10000">732</span> <span class="fs-4">M</span>
                                    <span class="green-caret">
                                        <img src="<?php echo e(asset('icons/Vector_7.png')); ?>" alt="caret-up"> 4%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="300" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Market Capitalization</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/heroicons_chart-pie.png')); ?>"
                                        alt="heroicons_chart-pie" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="8717"
                                        data-speed="10000">8717 </span> <span class="fs-4">M</span>
                                    <span class="red-caret">
                                        <img src="<?php echo e(asset('icons/Vector_6.png')); ?>" alt="caret-down">4%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6 col-sm-12" data-aos="fade-down" data-aos-duration="350" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue (<?php echo e($year); ?>)</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/clarity_container-volume-line.png')); ?>"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">2.44 </span>
                                    <span class="fs-4">M HL </span>
                                    <span class="red-caret">
                                        <img src="<?php echo e(asset('icons/Vector_6.png')); ?>" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="400" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue (<?php echo e($year); ?>)</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/clarity_container-volume-line.png')); ?>"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">244 </span><span class="fs-4">M HL </span>
                                    <span class="red-caret">
                                        <img src="<?php echo e(asset('icons/Vector_6.png')); ?>" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="500" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue (<?php echo e($year); ?>)</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/clarity_container-volume-line.png')); ?>"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">2.44 </span>
                                    <span class="fs-4">M HL </span>
                                    <span class="red-caret">
                                        <img src="<?php echo e(asset('icons/Vector_6.png')); ?>" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <div class="ir-section-details py-6" id="remarks">
        <div class="container leadership-container">
            <div class="row leadership-section">
                <div class="col-lg-6 col-md-12 leadership-image-col" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                    <div class="overview-image bg-image pbg-shadow leadership-image"
                        style="background-image: url(<?php echo e(asset('images/our-leadership/leader-1.png')); ?>)"
                        class="rounded">
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 leadership-content-col" data-aos="fade-left" data-aos-duration="500" data-aos-easing="linear">
                    <div class="leadership-content">
                        <h3>Chairman's message</h3>
                        <h4>Vision in Action</h4>
                        <p class="smallest-text leadership-text">
                            I would like to extend my heartfelt thanks to my fellow
                            directors for their unwavering support and strategic insight
                            throughout the year. Their guidance has been instrumental in
                            navigating the challenges and seizing the opportunities that
                            have come our way.
                            <br><br>I also wish to express my appreciation to
                            the executives and management team, under the leadership
                            of our CEO, Bernard Theys and our COO/ CFO, Patrick Rivalland,
                            for their exemplary leadership and commitment to delivering
                            on our strategic objectives.<br><br>
                            To our dedicated team, your hard work, resilience and passion
                            are the foundation of our success, and I am truly grateful for
                            your continued contribution. Lastly, I would like to thank
                            our valued stakeholders for their trust, collaboration, and
                            confidence in our vision.
                        </p>
                    </div>
                </div>
            </div>

            <div class="row mt-6 leadership-section">
                <div class="col-lg-6 col-md-12 leadership-content-col order-lg-1 order-2" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                    <div class="leadership-content">
                        <h3>CEO'S review</h3>
                        <div>
                            <p class="smallest-text leadership-text">
                                Business conditions improved somewhat over the past year, but a number of
                                challenges remained.
                                <br><br>
                                These included a weaker currency and the ongoing shortage
                                of foreign currency to pay international suppliers, supply chain complexity that
                                delayed or disrupted deliveries of vital inputs, fluctuating freight costs, rising
                                energy costs and high interest rates.
                                <br></br>
                                We have successfully implemented strategies to mitigate supply chain disruptions caused by
                                raw material
                                shortages and foreign exchange issues.However, the labour market remains
                                extremely tight, particularly for technical skills, and we continue to explore ways
                                to secure the necessary skills to support production and expansion.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 leadership-image-col order-lg-2 order-1" data-aos="fade-left" data-aos-duration="500" data-aos-easing="linear">
                    <div class="overview-image bg-image pbg-shadow leadership-image"
                        style="background-image: url(<?php echo e(asset('images/our-leadership/leader-11.png')); ?>)"
                        class="rounded">
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.report', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views/shareholders-integrated-report/cicl-annual-report-2025.blade.php ENDPATH**/ ?>