<?php $__env->startSection('content'); ?>
    <!-- Mobile Hero Section (hidden on desktop) -->
    <div class="mobile-hero-content d-block d-md-none">
        <div class="container">
            <div class="mobile-hero-slide active">
                <img src="<?php echo e(asset('images/homepage/PB_beer_welcome.png')); ?>" class="mobile-hero-image" alt="pbg-foster-brand-slider">
                <h4 class="mobile-hero-title">Thirst For The Best. <br> First For You.</h4>
                <p class="mobile-hero-description">Phoenix Beverages Group (PBG) is renowned for creating innovative beverages that elevate life's special moments.
                    We craft innovative beverages, from refreshing soft drinks and water to premium beers, wines, and spirits.
                    Made with high-quality ingredients, our products are enjoyed across Mauritius and beyond.
                </p>
                <a href="<?php echo e(route('about-us')); ?>" class="mobile-hero-button">Explore</a>
            </div>

            <div class="mobile-hero-slide">
                <img src="<?php echo e(asset('images/homepage/pbg-foster-brand-slider.png')); ?>" class="mobile-hero-image" alt="pbg-foster-brand-slider">
                <h4 class="mobile-hero-title">Inspiring Brands <br />Since 1931</h4>
                <p class="mobile-hero-description">Since 1931, our beverages have been an integral part of Mauritius's cultural identity. Today, we proudly share
                    our award-winning portfolio of high-quality alcoholic and non-alcoholic drinks beyond our shores. We are driven
                    by a continued commitment to excellence and innovation locally and beyond borders.
                </p>
                <a href="<?php echo e(route('our-brand')); ?>" class="mobile-hero-button">Explore</a>
            </div>

            <div class="mobile-hero-slide">
                <img src="<?php echo e(asset('images/homepage/pbg-innovation-slider.png')); ?>" class="mobile-hero-image" alt="pbg-innovation-slider">
                <h4 class="mobile-hero-title">Driving an Innovation-Led <br />Beverage Revolution</h4>
                <p class="mobile-hero-description">With a diverse and evolving portfolio, Phoenix Beverages Group leads the way in shaping both beloved favourites and bold new offerings.
                    We remain attuned to changing consumer preferences, continually introducing innovative flavours and expanding our range to include
                    lower-alcohol and reduced-sugar options, all while upholding our commitment to quality and taste.
                </p>
                <a href="<?php echo e(route('innovation')); ?>" class="mobile-hero-button">Explore</a>
            </div>

            <div class="mobile-hero-slide">
                <img src="<?php echo e(asset('images/homepage/pbg-phoenix-earth-sdg-slider.png')); ?>" class="mobile-hero-image" alt="pbg-phoenix-earth-slider">
                <h4 class="mobile-hero-title">Act Responsibly, <br /> Think Sustainable</h4>
                <p class="mobile-hero-description">At Phoenix Beverages Group, sustainability is embedded in every facet of our operations. As a responsible producer, we are firmly committed to our ESG principles,
                    from the sustainable management of natural resources to strict adherence to environmental regulations. Our objective is clear:
                    to minimise our ecological footprint while maintaining the highest standards of operational excellence.
                </p>
                <a href="<?php echo e(route('phoenix-earth')); ?>" class="mobile-hero-button">Explore</a>
            </div>

            <div class="mobile-hero-slide">
                <img src="<?php echo e(asset('images/homepage/pbg-our-reach-map-slider.png')); ?>" class="mobile-hero-image" alt="pbg-our-reach-slider">
                <h4 class="mobile-hero-title">Expanding Our Regional <br />Footprint</h4>
                <p class="mobile-hero-description">In 2025, Phoenix Beverages Group stands at the forefront of the Indian Ocean's beverage industry. With the acquisition of Seychelles Breweries
                    and the launch of Coca-Cola production at Edena SA in Réunion Island, we now extend our manufacturing reach. Our brands are also present across
                    key international markets — spanning the Indian Ocean, Africa, Australia, and Europe. As we continue to grow, we remain firmly committed to our vision:
                    <i>Providing happiness through beverages.</i>
                </p>
                <a href="<?php echo e(route('our-reach')); ?>" class="mobile-hero-button">Explore</a>
            </div>

            <!-- Mobile Indicators -->
            <div class="mobile-indicators">
                <span class="mobile-indicator active"></span>
                <span class="mobile-indicator"></span>
                <span class="mobile-indicator"></span>
                <span class="mobile-indicator"></span>
                <span class="mobile-indicator"></span>
            </div>
        </div>
    </div>

    <!-- Desktop Hero Section (hidden on mobile) -->
    <div class="page-blue d-none d-md-block">
        <div class="hero-content">
            <div class="slider">
                <div class="dashSlides">

                    <div class="dashSlide animate__animated animate__fadeIn animate__slower 3s">
                        <div class="slide-content">
                            <div class="left-content" style="text-align: justify">
                                <h4>Thirst For The Best. <br> First For You.</h4>
                                <p>Phoenix Beverages Group (PBG) is renowned for creating innovative beverages that elevate life's special moments.
                                    We craft innovative beverages, from refreshing soft drinks and water to premium beers, wines, and spirits.
                                    Made with high-quality ingredients, our products are enjoyed across Mauritius and beyond.
                                </p>
                                <div class="cta">
                                    <button class="button pbg-button pbg-shadow-dash">
                                        <a class="black" href="<?php echo e(route('about-us')); ?>">Explore </a>
                                    </button>
                                </div>
                            </div>
                            <div class="right-content">
                                <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                    <img src="<?php echo e(asset('images/homepage/PB_beer_welcome.png')); ?>" class="bg-image" alt="pbg-foster-brand-slider">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="dashSlide active animate__animated animate__fadeIn animate__slower 3s">
                        <div class="slide-content">
                            <div class="left-content" style="text-align: justify">
                                <h4>Inspiring Brands <br />Since 1931</h4>
                                <p>Since 1931, our beverages have been an integral part of Mauritius's cultural identity. Today, we proudly share
                                    our award-winning portfolio of high-quality alcoholic and non-alcoholic drinks beyond our shores. We are driven
                                    by a continued commitment to excellence and innovation locally and beyond borders.
                                </p>
                                <div class="cta">
                                    <button class="button pbg-button pbg-shadow-dash">
                                        <a class="black" href="<?php echo e(route('our-brand')); ?>">Explore </a>
                                    </button>
                                </div>
                            </div>
                            <div class="right-content">
                                <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                    <img src="<?php echo e(asset('images/homepage/pbg-foster-brand-slider.png')); ?>" class="bg-image" alt="pbg-foster-brand-slider">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="dashSlide animate__animated animate__fadeIn animate__slower 3s">
                        <div class="slide-content">
                            <div class="left-content" style="text-align: justify">
                                <h4>Driving an Innovation-Led <br />Beverage Revolution </h4>
                                <p>With a diverse and evolving portfolio, Phoenix Beverages Group leads the way in shaping both beloved favourites and bold new offerings.
                                    We remain attuned to changing consumer preferences, continually introducing innovative flavours and expanding our range to include
                                    lower-alcohol and reduced-sugar options, all while upholding our commitment to quality and taste.
                                </p>
                                <div class="cta">
                                    <button class="button pbg-button pbg-shadow-dash">
                                        <a class="black" href="<?php echo e(route('innovation')); ?>">Explore </a>
                                    </button>
                                </div>
                            </div>
                            <div class="right-content">
                                <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                    <img src="<?php echo e(asset('images/homepage/pbg-innovation-slider.png')); ?>" class="bg-image" alt="pbg-foster-brand-slider">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="dashSlide animate__animated animate__fadeIn animate__slower 3s">
                        <div class="slide-content">
                            <div class="left-content" style="text-align: justify">
                                <h4>Act Responsibly, <br /> Think Sustainable</h4>
                                <p>At Phoenix Beverages Group, sustainability is embedded in every facet of our operations. As a responsible producer, we are firmly committed to our ESG principles,
                                    from the sustainable management of natural resources to strict adherence to environmental regulations. Our objective is clear:
                                    to minimise our ecological footprint while maintaining the highest standards of operational excellence.
                                </p>
                                <div class="cta">
                                    <button class="button pbg-button pbg-shadow-dash">
                                        <a class="black" href="<?php echo e(route('phoenix-earth')); ?>">Explore </a>
                                    </button>
                                </div>
                            </div>
                            <div class="right-content">
                                <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                    <img src="<?php echo e(asset('images/homepage/pbg-phoenix-earth-sdg-slider.png')); ?>" class="bg-image" alt="pbg-innovation-slider">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="dashSlide active animate__animated animate__fadeIn animate__slower 3s">
                        <div class="slide-content">
                            <div class="left-content" style="text-align: justify">
                                <h4>Expanding Our Regional <br />Footprint</h4>
                                <p>In 2025, Phoenix Beverages Group stands at the forefront of the Indian Ocean's beverage industry. With the acquisition of Seychelles Breweries
                                    and the launch of Coca-Cola production at Edena SA in Réunion Island, we now extend our manufacturing reach. Our brands are also present across
                                    key international markets — spanning the Indian Ocean, Africa, Australia, and Europe. As we continue to grow, we remain firmly committed to our vision:
                                    <i>Providing happiness through beverages.</i>
                                </p>
                                <div class="cta">
                                    <button class="button pbg-button pbg-shadow-dash">
                                        <a class="black" href="<?php echo e(route('our-reach')); ?>">Explore </a>
                                    </button>
                                </div>
                            </div>
                            <div class="right-content">
                                <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                    <img src="<?php echo e(asset('images/homepage/pbg-our-reach-map-slider.png')); ?>" class="bg-image" alt="hero-slider">
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Add more slides as needed -->
                </div>
                

                <div class="indicators">
                    <span class="indicator active" onclick="currentSlide(0)"></span>
                    <span class="indicator" onclick="currentSlide(1)"></span>
                    <span class="indicator" onclick="currentSlide(2)"></span>
                    <span class="indicator" onclick="currentSlide(3)"></span>
                    <span class="indicator" onclick="currentSlide(4)"></span>
                    <!-- Add more indicators as needed -->
                </div>
            </div>
        </div>

    </div>

    <div class="our-story">
        <div class="container">
            <div class="mx-auto" style="width:100%">
                <h1 class="fw-bold" style="margin-bottom:5px" data-aos="fade-down" data-aos-duration="1000" data-aos-easing="linear">Get to know our Story</h1>
                <div class="row">
                    <div class="col-lg-6 col-md-12 column-padding" style="text-align: justify; position: relative;" data-aos="fade-down" data-aos-duration="1000" data-aos-easing="linear">
                        <span class="large-p">W</span>
                        <span class="story-text">ith a legacy in the beverage industry dating back to 1931, Phoenix Beverages Group has evolved into a leading FMCG company in Mauritius, striving to become the regional market leader.
                            Listed on the Mauritius Stock Exchange since 1993, we are dedicated to excellence in both local and international markets.
                        </span>
                    </div>
                    <div class="col-lg-6 col-md-12 column-padding" style="text-align: justify" data-aos="fade-down" data-aos-duration="1000" data-aos-easing="linear">
                        <span class="story-text">Phoenix Beverages Group (PBG) is renowned for creating innovative beverages that elevate life's special moments. We craft innovative beverages,
                            from refreshing soft drinks and water to premium beers, wines, and spirits. Made with high-quality ingredients, our products are enjoyed across Mauritius and beyond.
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container" data-aos="fade-down" data-aos-duration="500" data-aos-easing="linear" data-aos-delay="500">
        <div class="landing-page-video bg-image" style="background-image: url(<?php echo e(asset('images/welcome-img-bck.png')); ?>)">
            <div class="landing-video-overlay">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12" >
                        <div id="text-content">
                            <h4>Embark on a journey through <br>our evolution over the years.</h4>
                            <h6 class="smallest-text">Explore the rich legacy of our journey, uncovering our evolution, key milestones, and unwavering commitment to excellence over the years.</h6>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 text-center">
                        <div class="video-cta" id="play-btn">
                            <svg version="1.1" class="play-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" height="100px" width="100px"
                            viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve">
                         <path class="stroke-solid" fill="none" stroke="#08BABB"  d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7
                           C97.3,23.7,75.7,2.3,49.9,2.5"/>
                         <path class="stroke-dotted" fill="none" stroke="#08BABB"  d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7
                           C97.3,23.7,75.7,2.3,49.9,2.5"/>
                         <path class="icon" fill="#08BABB" d="M38,69c-1,0.5-1.8,0-1.8-1.1V32.1c0-1.1,0.8-1.6,1.8-1.1l34,18c1,0.5,1,1.4,0,1.9L38,69z"/>
                       </svg>
                        </div>

                        <div class="video-cta" id="pause-btn" style="display: none;">
                            <svg version="1.1" class="play-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" height="100px" width="100px"
                            viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve">
                         <path class="stroke-solid" fill="none" stroke="#08BABB"  d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7
                           C97.3,23.7,75.7,2.3,49.9,2.5"/>
                         <path class="stroke-dotted" fill="none" stroke="#08BABB"  d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7
                           C97.3,23.7,75.7,2.3,49.9,2.5"/>
                         <path class="icon" fill="#08BABB" d="M38,69c-1,0.5-1.8,0-1.8-1.1V32.1c0-1.1,0.8-1.6,1.8-1.1l34,18c1,0.5,1,1.4,0,1.9L38,69z"/>
                       </svg>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Hidden video element -->
            <video id="landing-video" width="100%" height="auto" style="display: none;" disablePictureInPicture>
                <source src="<?php echo e(asset('videos/pbg-coporation-launch.mp4')); ?>" type="video/mp4">
                Your browser does not support the video tag.
            </video>
        </div>
    </div>








    <div class="mt-6">
        <div class="container">
            <h4>Overview</h4>
        </div>
        <div class="dash-slider">
            <div class="dash-containers container">
                <div class="dash-container active animate__animated animate__fadeIn animate__slower 3s" id="container1">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right" data-aos-duration="1000" data-aos-easing="linear">
                            <div class="overview-image bg-image pbg-shadow"
                                style="background-image: url(<?php echo e(asset('images/our-brands/brands-cover-2.png')); ?>)">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left" data-aos-duration="1000" data-aos-easing="linear">
                            <h4>Our brands</h4>
                            <p style="text-align: justify">Phoenix Beverages Group creates exceptional products with premium natural ingredients,
                                earning a special place as local favourites among Mauritians and visitors alike. Discover our wide
                                range of locally crafted and international brands.
                            </p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="<?php echo e(route('our-brand')); ?>">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dash-container animate__animated animate__fadeIn animate__slower 3s" id="container2">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right">
                            <div class="overview-image bg-image pbg-shadow"
                                style="background-image: url(<?php echo e(asset('images/our-leadership/cover.png')); ?>)">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left">
                            <h4>Our Leadership</h4>
                            <p style="text-align: justify">Phoenix Beverages Group's Board upholds the highest standards of governance,
                                aligning with Mauritius' Code of Corporate Governance. We foster a culture of ethical
                                excellence and integrity among all stakeholders.</p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="<?php echo e(route('our-leadership')); ?>">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dash-container animate__animated animate__fadeIn animate__slower 3s" id="container3">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right">
                            <div class="overview-image bg-image pbg-shadow"
                                style="background-image: url(<?php echo e(asset('images/sustainability/esg-img-cover.png')); ?>)">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left">
                            <h4>ESG</h4>
                            <p style="text-align: justify">At Phoenix Beverages Group, sustainability is at the core of our operations,
                                shaping a responsible and thriving ecosystem. Our dedicated strategy drives
                                clear actions to embed sustainability into our brand DNA.</p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="<?php echo e(route('esg')); ?>">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dash-container animate__animated animate__fadeIn animate__slower 3s" id="container4">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right">
                            <div class="overview-image bg-image pbg-shadow"
                                style="background-image: url(<?php echo e(asset('images/innovation/cover.png')); ?>)">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left">
                            <h4>Innovations</h4>
                            <p style="text-align: justify">Phoenix Beverages Group fosters talent through its Innovation Department, a hub for creativity where ideas are nurtured
                                and realised. We encourage everyone across the organisation to contribute and bring innovations to life.
                            </p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="<?php echo e(route('innovation')); ?>">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dash-container animate__animated animate__fadeIn animate__slower 3s" id="container5">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right">
                            <div class="overview-image bg-image pbg-shadow"
                                style="background-image: url(<?php echo e(asset('images/our-reach/cover.png')); ?>)">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left">
                            <h4>Our Reach</h4>
                            <p style="text-align: justify"> For 22 years, Phoenix Beverages Group has expanded its global footprint,
                                starting with its first beer export. Driven by our International Business Units, our beers have gained a strong presence in international markets.
                            </p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="<?php echo e(route('our-reach')); ?>">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dash-container animate__animated animate__fadeIn animate__slower 3s" id="container6">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right">
                            <div class="overview-image bg-image pbg-shadow "
                                style="background-image: url(<?php echo e(asset('images/our-culture/cover.png')); ?>)">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left">
                            <h4>Our Culture</h4>
                            <p style="text-align: justify">Phoenix Beverages Group thrives on a high-performance culture, driven by talent development,
                                market agility, and operational excellence. Client-centricity, innovation, and trust are the pillars of our brand DNA.
                           </p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="<?php echo e(route('our-culture')); ?>">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dash-container animate__animated animate__fadeIn animate__slower 200s" id="container7">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right">
                            <div class="overview-image bg-image pbg-shadow"
                                style="background-image: url(<?php echo e(asset('images/investor-relations/cover.png')); ?>)">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left">
                            <h4>Investor Relations</h4>
                            <p style="text-align: justify">Phoenix Beverages Group's business model ensures sustainable, long-term value, supported by a strong strategic foundation.
                                We are committed to transparent communication, delivering accurate financial information to our shareholders.
                            </p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="<?php echo e(route('investor-relations')); ?>">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="dash-controls">
                <div class="dash-control" data-target="container1" id="control1">
                    <span>Our Brands</span>
                </div>
                <div class="dash-control" data-target="container2" id="control2">
                    <span>Leadership</span>
                </div>
                <div class="dash-control" data-target="container3" id="control3">
                    <span>ESG</span>
                </div>
                <div class="dash-control" data-target="container4" id="control4">
                    <span>Innovations</span>
                </div>
                <div class="dash-control" data-target="container5" id="control5">
                    <span>Our Reach</span>
                </div>
                <div class="dash-control" data-target="container6" id="control6">
                    <span>Our Culture</span>
                </div>
                <div class="dash-control" data-target="container7" id="control7">
                    <span>Investor Relations</span>
                </div>
            </div>

        </div>
    </div>


    


    <div class="container landing-section">
        <div class="investors-corner">
            <div class="row">
                <div class="col-12">
                    <h4>Investor's Corner</h4>
                </div>
                <div class="col-lg-5 col-md-12 mb-4 mb-lg-0">
                    <a href="<?php echo e(route('investor-relations')); ?>">
                    <div class="main-investor-box bg-image"
                        style="background-image: url(<?php echo e(asset('images/homepage/investors_corner.png')); ?>); background-size: cover; background-position: center;" data-aos="fade-down"
                        data-aos-duration="700" data-aos-easing="linear">
                        <div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0, 0, 0, 0.3); z-index: 1;"></div>
                        <div class="row" style="position: relative; color: white; text-align: center; z-index: 2; padding: 20px;">
                            <div class="col-9">
                                <div class="box-title">
                                    <h5>Investor's Corner</h5>
                                    A Strategic Partner for Sustainable Growth
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="box-arrow"><span class="fa fa-arrow-right"></span></div>
                            </div>
                        </div>
                    </div>
                    </a>
                </div>
                <div class="col-lg-7 col-md-12">
                    <div class="row">
                        <div class="col-lg-6 col-md-6 col-sm-6 mb-3">
                            <a href="<?php echo e(route('corporate-governance')); ?>">
                            <div class="investor-box overview-image pbg-shadow  bg-image" id="corporate-governance"
                                data-aos="fade-down" data-aos-duration="700" data-aos-easing="linear">
                                <div class="row">
                                    <div class="col-9">
                                        <div class="box-title">
                                            Corporate Governance
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="box-arrow"><span class="fa fa-arrow-right"></span></div>
                                    </div>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-6 mb-3">
                            <a href="<?php echo e(route('holding-companies')); ?>">
                            <div class="investor-box overview-image pbg-shadow  bg-image" id="quaterly-financial"
                                data-aos="fade-down" data-aos-duration="700" data-aos-easing="linear">
                                <div class="row">
                                    <div class="col-9">
                                        <div class="box-title">Holding Companies </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="box-arrow"><span class="fa fa-arrow-right"></span></div>
                                    </div>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-6 mb-3">
                            <a href="<?php echo e(route('integratedReport')); ?>">
                            <div class="investor-box overview-image pbg-shadow bg-image" id="annual-report"
                                data-aos="fade-down" data-aos-duration="700" data-aos-easing="linear">
                                <div class="row">
                                    <div class="col-9">
                                        <div class="box-title">Latest Annual <br>Report</div>
                                    </div>
                                    <div class="col-3">
                                        <div class="box-arrow"><span class="fa fa-arrow-right"></span></div>
                                    </div>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-6 mb-3">
                            <a href="<?php echo e(route('shareholders')); ?>">
                            <div class="investor-box overview-image pbg-shadow bg-image" id="share-price"
                                data-aos="fade-down" data-aos-duration="700" data-aos-easing="linear">
                                <div class="row">
                                    <div class="col-9">
                                        <div class="box-title">Shareholder's Corner</div>
                                    </div>
                                    <div class="col-3">
                                        <div class="box-arrow"><span class="fa fa-arrow-right"></span></div>
                                    </div>
                                </div>
                            </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container landing-section">
        <div class="news-corner">
            <div class="row">
                <div class="col-12">
                    <h4>Latest News</h4>
                </div>


                <?php if (! (empty($news))): ?>
                <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $newsData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <div class="col-12 col-lg-4" data-aos="fade-down" data-aos-duration="700" data-aos-easing="linear">
                    <div class="news-container">
                        <div class="news-image bg-image"
                        style="background-image: url(<?php echo e($newsData->image_url); ?>)">
                            <div class="news-date"><?php echo e($newsData->date); ?></div>
                            <div class="news-tag"><?php echo e($newsData->category); ?></div>
                            <div class="news-title">
                                <h4><?php echo e(\Str::limit($newsData->title, 80, '...')); ?></h4>
                            </div>
                            <div class="latestNewsDetails">
                                <h6><?php echo \Str::limit($newsData->body, 120, '...'); ?></h6>
                                <div class="learnMoreDash text-center mx-auto w-50" >
                                    <a class="" href="<?php echo e(route('news.details',$newsData->id)); ?>">Read More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <i class="text-center smallest-text">No News to display </i>
                <?php endif; ?>


                <!-- News Item 1 -->


                <!-- News Item 2 -->
                

                <!-- News Item 3 -->
                

                <!-- News Item 4 -->
                
                <div class="news-see-more col-12">
                    <div class="learnMore" >
                        <a class="text-primary" href="<?php echo e(route('news-room')); ?>">Explore</a>
                    </div>
                </div>
            </div>
        </div>
    </div>


    





<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Mobile Hero Slider Functions
    let currentMobileSlideIndex = 0;
    const mobileSlides = document.querySelectorAll('.mobile-hero-slide');
    const mobileIndicators = document.querySelectorAll('.mobile-indicator');

    function currentMobileSlide(n) {
        // Hide all slides
        mobileSlides.forEach(slide => {
            slide.classList.remove('active');
        });

        // Remove active class from all indicators
        mobileIndicators.forEach(indicator => {
            indicator.classList.remove('active');
        });

        // Show current slide and activate indicator
        if (mobileSlides[n]) {
            mobileSlides[n].classList.add('active');
        }
        if (mobileIndicators[n]) {
            mobileIndicators[n].classList.add('active');
        }

        currentMobileSlideIndex = n;
    }

    // Auto-advance mobile slider
    function autoAdvanceMobileSlider() {
        if (mobileSlides.length > 0) {
            currentMobileSlideIndex = (currentMobileSlideIndex + 1) % mobileSlides.length;
            currentMobileSlide(currentMobileSlideIndex);
        }
    }

    // Add click event listeners to indicators
    mobileIndicators.forEach((indicator, index) => {
        indicator.addEventListener('click', function() {
            currentMobileSlide(index);
        });
    });

    // Start auto-advance for mobile slider
    if (mobileSlides.length > 1) {
        setInterval(autoAdvanceMobileSlider, 5000); // Change slide every 5 seconds
    }

    // Video Functions
    const video = document.getElementById('landing-video');
    const videoOverlay = document.querySelector('.landing-video-overlay');
    const playBtn = document.getElementById('play-btn');
    const pauseBtn = document.getElementById('pause-btn');


    if (playBtn && video) {
        playBtn.addEventListener('click', function() {
            console.log('Play button clicked');

            // Show video and hide overlay
            video.style.display = 'block';
            video.classList.add('playing');
            if (videoOverlay) {
                videoOverlay.classList.add('hidden');
            }

            // Hide play button, show pause button
            playBtn.style.display = 'none';
            pauseBtn.style.display = 'block';

            // Play video
            video.play().then(function() {
                console.log('Video started playing');
            }).catch(function(error) {
                console.error('Error playing video:', error);
            });
        });
    }

    if (pauseBtn && video) {
        pauseBtn.addEventListener('click', function() {
            console.log('Pause button clicked');

            // Pause video
            video.pause();
            video.classList.remove('playing');
            if (videoOverlay) {
                videoOverlay.classList.remove('hidden');
            }

            // Show play button, hide pause button
            playBtn.style.display = 'block';
            pauseBtn.style.display = 'none';
        });
    }

    // Handle video end
    if (video) {
        video.addEventListener('ended', function() {
            console.log('Video ended');
            video.style.display = 'none';
            video.classList.remove('playing');
            if (videoOverlay) {
                videoOverlay.classList.remove('hidden');
            }

            // Show play button, hide pause button
            playBtn.style.display = 'block';
            pauseBtn.style.display = 'none';
        });

        // Add click to pause functionality
        video.addEventListener('click', function() {
            if (!video.paused) {
                console.log('Video clicked to pause');
                video.pause();
                video.classList.remove('playing');
                if (videoOverlay) {
                    videoOverlay.classList.remove('hidden');
                }

                // Show play button, hide pause button
                playBtn.style.display = 'block';
                pauseBtn.style.display = 'none';
            }
        });

        // Add error handling
        video.addEventListener('error', function(e) {
            console.error('Video error:', e);
        });

        // Add load event to check if video loads properly
        video.addEventListener('loadeddata', function() {
            console.log('Video data loaded successfully');
        });

        video.addEventListener('loadstart', function() {
            console.log('Video loading started');
        });
    }

    // OVERVIEW SLIDER WITH DASH-CONTROLS (manual navigation only)
    const overviewSlides = document.querySelectorAll('.dash-container');
    const dashControls = document.querySelectorAll('.dash-control');
    let currentOverviewIndex = 0;

    function showOverviewSlide(index) {
        // Hide all slides
        overviewSlides.forEach((slide, i) => {
            if (i === index) {
                slide.classList.add('active');
            } else {
                slide.classList.remove('active');
            }
        });

        // Update dash controls
        dashControls.forEach((control, i) => {
            if (i === index) {
                control.classList.add('active');
            } else {
                control.classList.remove('active');
            }
        });

        currentOverviewIndex = index;
    }

    // Add click event listeners to dash controls
    dashControls.forEach((control, index) => {
        control.addEventListener('click', function() {
            showOverviewSlide(index);
        });
    });

    // Initialize first slide as active
    if (overviewSlides.length > 0) {
        showOverviewSlide(0);
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views/welcome.blade.php ENDPATH**/ ?>