<style>
    .header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 25px 0px;
    }

    .header h4 {
        margin: 0;
    }

    .header h1 {}

    .nav-item {
        padding: 0px !important;
        margin: 0px !important;
    }


    li .nav-item {
        padding: 0px !important;
        margin: 0px !important;
    }

    .nav {
        margin-bottom: 0;
    }

    .nav-link {
        color: white !important;
    }

    .nav-link.active {
        /* color: #08BABB;
        background-color: transparent; */
        color: #0A1F2E !important;
        background-color: #08BABB !important;
    }

    /* .nav-link:hover {
        color: #08BABB !important;
        background-color: transparent !important;
    } */

    .active {
        color: #08BABB !important;
        background-color: transparent !important;
    }

    div.investor-tab-content {
        margin-left: 200px !important;
        padding-bottom: 30px;
        /* margin-top: 20px !important; */
    }


    .slick-slide img {
        width: 100%;
        max-height: 400px;
        height: 350px;
        object-fit: cover;
    }

    .slick-slide {
        height: 58% !important;

    }


    a.see-all {
        padding: 12px 5px;
        color: #E7E9EA;
    }

    .controls {
        position: absolute;
        bottom: 0;
        right: 0;
        margin: 20px;
        display: flex;
        gap: 10px;
    }

    .controls button {
        background-color: transparent;
        color: #08BABB;
        border: 2px solid #08BABB;
        cursor: pointer;
        padding: 10px 15px;
        font-size: 18px;
        border-radius: 5px;
        transition: background-color 0.3s, color 0.3s;
    }

    .controls button:hover {
        background-color: #08BABB;
        color: white;
    }

    .select-year {
        pointer-events: none;
    }

    .select-year:hover {
        background-color: transparent;
        color: inherit;
    }

    .chart-container {

        height: 350px;
        margin: 5px auto;
        border-radius: 8px;
        width: 100%;
        overflow: visible;
    }


    .image-container {
        position: relative;
        display: inline-block;
        width: 100%;
        overflow: hidden;
    }

    .report-image {
        width: 100%;
        height: 150px;
        object-fit: cover;
        transition: transform 0.3s ease-in-out;
    }

    .overlay {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background-color: rgba(0, 0, 0, 0.8) !important;
        color: white;
        display: block !important;
        justify-content: center !important;
        align-items: center;
        padding: 10px 20px;
        opacity: 0;
        height: 400px !important;
        border: 1px solid #08BABB;
        transition: opacity 0.4s ease-in-out;
    }

    .overlay-text-left,
    .overlay-text-right {
        font-size: 70%;
        font-weight: bold;
    }


    .overlay-text-left a,
    .overlay-text-right a {
        color: #E7E9EA;
    }

    .overlay-text-left a:hover,
    .overlay-text-right a:hover {
        color: #08BABB;
    }


    .image-container:hover .overlay {
        opacity: 1;
    }

    .image-container:hover .report-image {
        transform: scale(1.2);
    }


    .new-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        width: 100%;
        /* margin: 0 auto; */
        height: 400px;
        background-color: rgba(0, 0, 0, 0.8) !important;
        color: #fff;
        /* display: flex; */
        text-align: left;
        /* justify-content: center !important; */
        opacity: 0;
        padding: 20px;
        transition: opacity 0.3s ease;
        transition: background 0.3s ease;
    }

    .image-container:hover .new-overlay {
        opacity: 1;
    }

    .image-container:hover .overlay-report-image {
        transform: scale(1.2);
    }

    .overlay-report-image {
        width: 100%;
        object-fit: cover;
        transition: transform 0.3s ease-in-out;
    }


    .investor-report-img-container {
        position: relative;
        overflow: hidden;
        border-radius: 8px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease-in-out;
    }


    .investor-report-img-container img {
        transition: transform 0.5s ease, filter 0.3s ease;
    }

    /* Hover effect on the image */
    .investor-report-img-container:hover img {
        transform: scale(1.1);
        filter: brightness(0.8);
    }


    /* Show the footer text on hover */
    .investor-report-img-container:hover .investor-relation-img-footer {
        opacity: 1;
    }


    /* Style the custom arrows */
    /* Update the custom arrows container */
    .custom-arrows {
        position: absolute;
        top: 50%;
        left: -50;
        width: 100%;
        z-index: 2;
    }

    /* Hide the next button */
    .slick-next {
        display: none !important;
    }

    /* Style the prev button */
    .slick-prev {
        position: absolute;
        top: 50%;
        left: -25px;
        transform: translateY(-150%);
        z-index: 2;
        background-color: #08BABB !important;
        border: none;
        font-size: 24px;
        cursor: pointer;
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 10px;
    }

    .slick-prev i {
        color: #0A1F2E;
        /* Blue color for the arrow */
        font-size: 20px;
    }

    /* Hover effect */
    .slick-prev:hover {
        background-color: #069697 !important;
        /* Slightly darker teal on hover */
    }

    .slick-prev:hover i {
        color: #0A1F2E;
        /* Keep the arrow blue on hover */
    }

    .stock-chart-container {
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        max-width: 100%;
        overflow: visible;
        min-height: 320px;
    }

    .timeframe-btn {
        background: transparent;
        border: 1px solid #333;
        color: #888;
        padding: 3px 6px;
        border-radius: 3px;
        font-size: 8px;
        cursor: pointer;
        transition: all 0.2s ease;
        min-width: 25px;
    }

    .timeframe-btn:hover {
        background: #333;
        color: white;
    }

    .timeframe-btn.active {
        background: #08BABB;
        border-color: #08BABB;
        color: white;
    }

    .stock-header button:hover {
        color: white;
    }

    .key-metrics {
        background: rgba(255, 255, 255, 0.05);
        padding: 10px;
        border-radius: 6px;
    }

    .chart-wrapper {
        background-color: #0A1F2E;
        border-radius: 6px;
        padding: 6px;
        width: 100%;
        height: 220px !important;
        min-height: 220px;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .chart-container {
            height: auto;
            min-height: 350px;
        }
        
        .stock-chart-container {
            padding: 8px;
            min-height: 320px;
        }
        
        .timeframe-buttons {
            justify-content: center;
        }
        
        .timeframe-btn {
            padding: 3px 6px;
            font-size: 9px;
            min-width: 25px;
        }
        
        .key-metrics {
            grid-template-columns: repeat(2, 1fr) !important;
            gap: 6px !important;
        }
        
        .chart-wrapper {
            height: 150px !important;
            min-height: 150px;
        }
    }
</style>
<?php $__env->startSection('content'); ?>
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url(<?php echo e(asset('images/investor-relations/investor-relationscover-images.png')); ?>);">
        </div>
        <div class="page-title-container">
            <h4>INVESTORS RELATIONS</h4>
            <span class="text-primary">Group Dynamics and Cohesiveness</span>
        </div>
    </div>

    <div class="container landing-section pb-6">
        <div class="row mb-4" data-aos="fade-in" data-aos-delay="200" >
            <div class="col-lg-4 col-md-12 mb-4 px-2">
                <div class="card mx-2 investor-relations-dark">
                    <div class="card-body mt-5" style="height: 350px; overflow: hidden;">
                        <h3>Why Investors Believe in Us</h3>
                        <p style="text-align: justify;">
                            Phoenix Beverages Group is focused on delivering sustainable, long-term value to our
                            stakeholders.
                            Our strong strategic foundation provides a solid basis for future growth.
                            <br><br>We are committed to open and honest communication with our shareholders
                            and will continue to provide accurate and timely financial information.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-12 mb-4 px-2">
                <div class="card mx-2 investor-relations-dark">
                    <div class="card-header">
                        Share Price
                    </div>
                    <div class="card-body" style="height: 450px; overflow: visible;">
                        <div class="chart-container">
                            <!-- Modern Stock Chart Interface -->
                            <div class="stock-chart-container" style="border-radius: 8px; width: 100%;">
                                <!-- Stock Header -->
                                <div class="stock-header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">
                                    <div style="display: flex; align-items: center; gap: 8px;">
                                            <img src="<?php echo e(asset('images/PBG Logo_shearprice.png')); ?>" class="img-fluid" height="30" width="30"
                                                alt="Company Logo" />
                                       
                                        <p style="color: #888; margin: 0; font-size: 9px;">Phoenix Beverages Group</p>
                                    </div>
                                </div>

                                <!-- Price Information -->
                                <div class="price-info" style="display: flex; gap: 12px; margin-bottom: 12px; flex-wrap: wrap;">
                                    <div>
                                        <div id="current-price" style="color: white; font-size: 14px; font-weight: bold;">--</div>
                                        <div id="price-change" style="color: #ff4444; font-size: 8px;">--</div>
                                        <div style="color: #888; font-size: 7px;">At Close</div>
                                    </div>
                                    <div>
                                        <div id="previous-close" style="color: white; font-size: 14px; font-weight: bold;">--</div>
                                        <div id="percentage-change" style="color: #ff4444; font-size: 8px;">--</div>
                                        <div style="color: #888; font-size: 7px;">Previous Close</div>
                                    </div>
                                </div>

                                <!-- Timeframe Buttons -->
                                <div class="timeframe-buttons" style="display: flex; gap: 3px; margin-bottom: 12px; flex-wrap: wrap;">
                                    <button class="timeframe-btn" data-period="1D">1D</button>
                                    <button class="timeframe-btn" data-period="5D">5D</button>
                                    <button class="timeframe-btn" data-period="1W">1W</button>
                                    <button class="timeframe-btn active" data-period="1M">1M</button>
                                    <button class="timeframe-btn" data-period="3M">3M</button>
                                    <button class="timeframe-btn" data-period="6M">6M</button>
                                    <button class="timeframe-btn" data-period="YTD">YTD</button>
                                    <button class="timeframe-btn" data-period="1Y">1Y</button>
                                    <button class="timeframe-btn" data-period="2Y">2Y</button>
                                </div>

                                <!-- Chart Canvas -->
                                <div class="chart-wrapper" style="position: relative; height: 220px; margin-bottom: 8px;">
                                    <canvas id="stockChart"></canvas>
                                </div>

                                <!-- Key Metrics -->
                                <div class="key-metrics" style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 6px; margin-bottom: 8px;">
                                    <div>
                                        <div style="color: #888; font-size: 7px;">Volume</div>
                                        <div id="volume" style="color: white; font-size: 9px;">--</div>
                                    </div>
                                    <div>
                                        <div style="color: #888; font-size: 7px;">Market Cap</div>
                                        <div id="market-cap" style="color: white; font-size: 9px;">--</div>
                                    </div>
                                    <div>
                                        <div style="color: #888; font-size: 7px;">52W High</div>
                                        <div id="week52-high" style="color: white; font-size: 9px;">--</div>
                                    </div>
                                    <div>
                                        <div style="color: #888; font-size: 7px;">52W Low</div>
                                        <div id="week52-low" style="color: white; font-size: 9px;">--</div>
                                    </div>
                                    <div>
                                        <div style="color: #888; font-size: 7px;">Avg Vol</div>
                                        <div id="avg-volume" style="color: white; font-size: 9px;">--</div>
                                    </div>
                                    <div>
                                        <div style="color: #888; font-size: 7px;">Yield</div>
                                        <div id="yield" style="color: white; font-size: 9px;">--</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-12 mb-4 px-2">
                <div class="investor-report-img-container" style="height: 500px; overflow: hidden; width:90%">
                    <img src="<?php echo e(asset('images/investor-relations/reports/annual-report-2024.png')); ?>"
                        class="img-fluid w-100 h-100" style="object-fit: cover;">

                    <a href="<?php echo e(route('integratedReport')); ?>">
                        target="_blank">
                        <div class="investor-relation-img-footer">
                            <h6>View Integrated Report</h6>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <div class="row mb-4" data-aos="fade-in" data-aos-delay="200" >
            <div class="col-lg-4 col-md-12 mb-4 px-2">
                <div class="card mx-2 investor-relations-dark">
                    <div class="card-body">
                        <h5>Phoenix Beverages Limited Abridged Report</h5>

                        <div class="shareholders-border">
                            <p class="mb-2">Abridged Unaudited Results for the Quarter, Ended </br>31 March 2025</p>
                            <div class="document-actions">
                                <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2025/PBL_abridged_accounts-31.03.2025.pdf')); ?>"
                                    target="_blank">
                                    <span class="fa fa-eye mx-1"></span> View
                                </a>
                                <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2025/PBL_abridged_accounts-31.03.2025.pdf')); ?>"
                                    download="PBL_abridged_accounts-31.03.2025.pdf" target="_blank">
                                    <span class="fa fa-download mx-1"></span>
                                    Download PDF
                                </a>
                            </div>
                            <div class="date">12 May 2025</div>
                        </div>

                        <div class="shareholders-border mt-3">
                            <p class="mb-2">Abridged Unaudited Results for the Quarter and Half Year Ended 31 December
                                2024</p>
                            <div class="document-actions">
                                <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2024/PBL-abridged_accounts_31.12.2024.pdf')); ?>"
                                    target="_blank">
                                    <span class="fa fa-eye mx-1"></span> View
                                </a>
                                <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2024/PBL-abridged_accounts_31.12.2024.pdf')); ?>"
                                    download="PBL-abridged_accounts_31.12.2024.pdf" target="_blank">
                                    <span class="fa fa-download mx-1"></span>
                                    Download PDF
                                </a>
                            </div>
                            <div class="date">December 2024</div>
                        </div>

                        
                    </div>
                </div>


                <div class="mt-4">
                    <div class="card mx-2 investor-relations-dark">
                        <div class="card-body">
                            <h5>Holding Companies Abridged</h5>

                            <div class="shareholders-border">
                                <div style="display: flex; justify-content:space-between">
                                    <p class="mb-2">PICL Abridged Unaudited Results for the Quarter</br>Ended 31 March
                                        2025</p>
                                    <div>
                                        <span class="badge picl-badge">PICL</span>
                                    </div>
                                </div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2025/Abridged_report/PICL_abridged_account-31.03.2025.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2025/Abridged_report/PICL_abridged_account-31.03.2025.pdf')); ?>"
                                        download="PICL_abridged_account-31.03.2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                                <div class="date">12 May 2025</div>
                            </div>

                            <div class="shareholders-border my-3">
                                <div style="display: flex; justify-content:space-between">
                                    <p class="mb-2">CICL Abridged Unaudited Results for the Quarter</br>Ended 31 March
                                        2025</p>
                                    <div>
                                        <span class="badge cicl-badge">CICL</span>
                                    </div>
                                </div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2025/Abridged_report/CICL_abridged_accounts-31.03.2025.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2025/Abridged_report/CICL_abridged_accounts-31.03.2025.pdf')); ?>"
                                        download="CICL_abridged_accounts-31.03.2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                                <div class="date">12 May 2025</div>
                            </div>

                            <div class="shareholders-border my-3">
                                <div style="display: flex; justify-content:space-between">
                                    <p class="mb-2">Abridged Unaudited Results, December 2024</p>
                                    <div>
                                        <span class="badge picl-badge">PICL</span>
                                    </div>
                                </div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Abridged_report/PICL-abridged_accounts_31.12.2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Abridged_report/PICL-abridged_accounts_31.12.2024.pdf')); ?>"
                                        download="PICL-abridged_accounts_31.12.2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                                <div class="date">December 2024</div>
                            </div>

                            <div class="shareholders-border my-3">
                                <div style="display: flex; justify-content:space-between">
                                    <p class="mb-2">Abridged Unaudited Results, December 2024</p>
                                    <div>
                                        <span class="badge cicl-badge">CICL</span>
                                    </div>
                                </div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Abridged_report/CICL-Abridged_accounts_31.12.2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Abridged_report/CICL-Abridged_accounts_31.12.2024.pdf')); ?>"
                                        download="CICL-Abridged_accounts_31.12.2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                                <div class="date">December 2024</div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-lg-4 col-md-12 mb-4 px-2">
                <div class="card mx-2 investor-relations-dark">
                    <div class="card-body">
                        <h5> Notice & Communiqué</h5>

                        <div class="shareholders-border">
                            <div style="display: flex; justify-content:space-between">
                                <p class="mb-2">Substantial Transaction Circular </p>
                                <div>
                                    <span class="badge pbl-badge">PBL</span>
                                </div>
                            </div>
                            <div class="document-actions">
                                <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_SeyBrew_Transanction_circular.pdf')); ?>"
                                    target="_blank">
                                    <span class="fa fa-eye mx-1"></span> View
                                </a>
                                <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_SeyBrew_Transanction_circular.pdf')); ?>"
                                    download="PBL_SeyBrew_Transanction_circular.pdf" target="_blank">
                                    <span class="fa fa-download mx-1"> </span> Download PDF
                                </a>
                            </div>
                            <div class="date">02 June 2025</div>
                        </div>

                        <div class="shareholders-border mt-3">
                            <div style="display: flex; justify-content:space-between">
                                <p class="mb-2">Circular Communique </p>
                                <div>
                                    <span class="badge pbl-badge">PBL</span>
                                </div>
                            </div>
                            <div class="document-actions">
                                <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_circular_communique.pdf')); ?>"
                                    target="_blank">
                                    <span class="fa fa-eye mx-1"></span> View
                                </a>
                                <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_circular_communique.pdf')); ?>"
                                    download="PBL_circular_communique.pdf" target="_blank">
                                    <span class="fa fa-download mx-1"></span> Download PDF
                                </a>
                            </div>
                            <div class="date">02 June 2025</div>
                        </div>

                        <div class="shareholders-border mt-3">
                            <div style="display: flex; justify-content:space-between">
                                <p class="mb-2">Abridged Unaudited Results for the Quarter Notice, </br>Ended 31 March
                                    2025 </p>
                                <div>
                                    <span class="badge pbl-badge">PBL</span>
                                </div>
                            </div>
                            <div class="document-actions">
                                <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_NOTICE-31.03.2025.pdf')); ?>"
                                    target="_blank">
                                    <span class="fa fa-eye mx-1"></span> View
                                </a>
                                <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_NOTICE-31.03.2025.pdf')); ?>"
                                    download="PBL_NOTICE-31.03.2025.pdf" target="_blank">
                                    <span class="fa fa-download mx-1"></span> Download PDF
                                </a>
                            </div>
                            <div class="date">12 May 2025</div>
                        </div>

                        <div class="shareholders-border mt-3">
                            <div style="display: flex; justify-content:space-between">
                                <p class="mb-2">PICL Abridged Unaudited Financial </br>Statements Notice, Ended 31 March
                                    2025</p>
                                <div>
                                    <span class="badge picl-badge">PICL</span>
                                </div>
                            </div>
                            <div class="document-actions">
                                <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2025/Notices/PICL_NOTICE-31.03.2025.pdf')); ?>"
                                    target="_blank">
                                    <span class="fa fa-eye mx-1"></span> View
                                </a>
                                <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2025/Notices/PICL_NOTICE-31.03.2025.pdf')); ?>"
                                    download="PBL_NOTICE-31.03.2025.pdf" target="_blank">
                                    <span class="fa fa-download mx-1"> </span> Download PDF
                                </a>
                            </div>
                            <div class="date">12 May 2025</div>
                        </div>

                        <div class="shareholders-border mt-3">
                            <div style="display: flex; justify-content:space-between">
                                <p class="mb-2">CICL Abridged Unaudited Financial </br>Statements Notice, Ended 31 March
                                    2025 </p>
                                <div>
                                    <span class="badge cicl-badge">CICL</span>
                                </div>
                            </div>
                            <div class="document-actions">
                                <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2025/Notices/CICL_NOTICE-31.03.2025.pdf')); ?>"
                                    target="_blank">
                                    <span class="fa fa-eye mx-1"></span> View
                                </a>
                                <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2025/Notices/CICL_NOTICE-31.03.2025.pdf')); ?>"
                                    download="CICL_NOTICE-31.03.2025.pdf" target="_blank">
                                    <span class="fa fa-download mx-1"> </span> Download PDF
                                </a>
                            </div>
                            <div class="date">12 May 2025</div>
                        </div>

                        
                    </div>
                </div>


                <div class="card mt-4 mx-2 investor-relations-dark">
                    <div class="card-body">
                        <div class="card-body">
                            <h4>Shareholders' corner</h4>
                            <p style="text-align: justify;">
                                Phoenix Beverages Group is dedicated to maintaining open and transparent communication with
                                its shareholders.
                                The Shareholders' Corner provides a platform to access essential information.
                            </p>
                            <div class="learnMore">
                                <a href="<?php echo e(route('holding-companies')); ?>" class="smallest-text">Explore</a>
                            </div>

                        </div>
                    </div>

                </div>

            </div>
            <div class="col-lg-4 col-md-12 mb-4 px-2">
                

                <div class="">
                    <div class="card mx-2 investor-relations-dark">
                        <div class="card-body">
                            <h5>Dividend Announcement</h5>
                            <div class="shareholders-border">
                                <div style="display: flex; justify-content:space-between">
                                    <p class="mb-2">PBL Dividend Announcement, </br>March 2025</p>
                                    <div>
                                        <span class="badge pbl-badge">PBL</span>
                                    </div>
                                </div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_diviends_information/2025/PBL_DIVIDEND-31.03.2025.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_diviends_information/2025/PBL_DIVIDEND-31.03.2025.pdf')); ?>"
                                        download="PBL_DIVIDEND-31.03.2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                                <div class="date">12 May 2025</div>
                            </div>

                            <div class="shareholders-border mt-3">
                                <div style="display: flex; justify-content:space-between">
                                    <p class="mb-2">PICL Dividend Announcement, </br>March 2025</p>
                                    <div>
                                        <span class="badge picl-badge">PICL</span>
                                    </div>
                                </div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2025/Dividends-information/PICL_DIVIDEND-31.03.2025.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2025/Dividends-information/PICL_DIVIDEND-31.03.2025.pdf')); ?>"
                                        download="PICL_DIVIDEND-31.03.2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                                <div class="date">12 May 2025</div>
                            </div>

                            <div class="shareholders-border mt-3">
                                <div style="display: flex; justify-content:space-between">
                                    <p class="mb-2">CICL Dividend Announcement, </br>March 2025</p>
                                    <div>
                                        <span class="badge cicl-badge">CICL</span>
                                    </div>
                                </div>

                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2025/Dividends-information/CICL_DIVIDEND-31.02.2025.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Dividends-information/CICL_DIVIDEND-31.02.2025.pdf')); ?>"
                                        download="CICL_DIVIDEND-31.02.2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                                <div class="date">12 May 2025</div>
                            </div>

                            <div class="shareholders-border my-3">
                                <div style="display: flex; justify-content:space-between">
                                    <p class="mb-2">PBL Dividend Announcement, </br>September 2024</p>
                                    <div>
                                        <span class="badge pbl-badge">PBL</span>
                                    </div>
                                </div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_diviends_information/2024/PBL-DIVIDEND-SeptemberT-2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_diviends_information/2024/PBL-DIVIDEND-SeptemberT-2024.pdf')); ?>"
                                        download="PBL-DIVIDEND-SeptemberT-2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                                <div class="date">11 November 2024</div>
                            </div>
                            

                        </div>
                    </div>
                </div>

            </div>

            
        </div>
    </div>


    <div class="main-section" data-aos="fade-in" data-aos-delay="200" >
        <div class="container">
            <div class="header">
                <h4>PhoenixBev Annual Reports</h4>
                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill"
                            data-bs-target="#pills-all" type="button" role="tab" aria-controls="pills-home"
                            aria-selected="true">All</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill"
                            data-bs-target="#pills-2024" type="button" role="tab" aria-controls="pills-profile"
                            aria-selected="false">2024</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-contact-tab" data-bs-toggle="pill"
                            data-bs-target="#pills-2023" type="button" role="tab" aria-controls="pills-contact"
                            aria-selected="false">2023</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill"
                            data-bs-target="#pills-2022" type="button" role="tab" aria-controls="pills-profile"
                            aria-selected="false">2022</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-contact-tab" data-bs-toggle="pill"
                            data-bs-target="#pills-2021" type="button" role="tab" aria-controls="pills-contact"
                            aria-selected="false">2021</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill"
                            data-bs-target="#pills-2020" type="button" role="tab" aria-controls="pills-profile"
                            aria-selected="false">2020</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-contact-tab" data-bs-toggle="pill"
                            data-bs-target="#pills-2019" type="button" role="tab" aria-controls="pills-contact"
                            aria-selected="false">2019</button>
                    </li>
                    
                </ul>
            </div>

            <div class="tab-content investor-tab-content" id="pills-tabContent" >
                <div class="tab-pane fade show active" id="pills-all" role="tabpanel" aria-labelledby="pills-home-tab">
                    <section class="investor-relations-slide slider">
                        <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="slide">
                                <div class="image-container">
                                    <img src="<?php echo e($report['image']); ?>" alt="Carousel Image" class="report-image">
                                    <div class="overlay">
                                        <p style="color:#08BABB; font-weight:bold"><?php echo e($report['year']); ?></p>
                                        <div style="padding-top:70%">
                                            <h4 style="color:#08BABB">Annual Report <?php echo e($report['year']); ?></h4>
                                        </div>

                                        <div style="justify-content:space-between; display:flex">
                                            <div class="overlay-text-left">
                                                <a href="<?php echo e($report['document']); ?>" target="_blank">
                                                    <span class="fa fa-eye mx-1"></span> View
                                                </a>
                                            </div>
                                            <div class="overlay-text-right">
                                                <a href="<?php echo e($report['document']); ?>" download="<?php echo e($report['name']); ?>"
                                                    target="_blank">
                                                    <span class="fa fa-download mx-1"> </span> Download PDF
                                                </a>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </section>

                    <div class="custom-arrows">
                        <button class="slick-prev"><i class="fas fa-chevron-left"></i></button>
                        
                    </div>

                    <div class="d-flex my-4 mx-0">
                        <div class="controls">
                            <div class="learnMore">
                                <a href="<?php echo e(route('annual.report')); ?>" class="smaller-text">Explore</a>
                            </div>
                            
                        </div>
                    </div>
                </div>


                <div class="tab-pane fade" id="pills-2024" role="tabpanel" aria-labelledby="pills-profile-tab">
                    <section class="text-center">
                        <div class="image-container" style="height:400px;width:30%;">
                            <img src="<?php echo e($reports[0]['image']); ?>" alt="Image" height="350px"
                                style="object-fit: cover; width: auto; max-width: 100%;" class="overlay-report-image">
                            <div class="new-overlay">
                                <p style="color:#08BABB; font-weight:bold"><?php echo e($reports[0]['year']); ?></p>
                                <div style="padding-top:60%">
                                    <h4 style="color:#08BABB">Annual Report <?php echo e($reports[0]['year']); ?></h4>
                                </div>
                                <div style="justify-content: space-between;display:flex;">
                                    <div class="overlay-text-left">
                                        <a href="<?php echo e($reports[0]['document']); ?>" target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                    </div>
                                    <div class="overlay-text-right">
                                        <a href="<?php echo e($reports[0]['document']); ?>" download="<?php echo e($reports[0]['name']); ?>"
                                            target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
                <div class="tab-pane fade" id="pills-2023" role="tabpanel" aria-labelledby="pills-contact-tab">
                    <section class="text-center">
                        <div class="image-container" style="height:400px;width:30%;">
                            <img src="<?php echo e($reports[1]['image']); ?>" alt="Image" height="350px"
                                style="object-fit: cover; width: auto; max-width: 100%;" class="overlay-report-image">
                            <div class="new-overlay">
                                <p style="color:#08BABB; font-weight:bold"><?php echo e($reports[1]['year']); ?></p>
                                <div style="padding-top:60%">
                                    <h4 style="color:#08BABB">Annual Report <?php echo e($reports[1]['year']); ?></h4>
                                </div>
                                <div style="justify-content: space-between;display:flex;">
                                    <div class="overlay-text-left">
                                        <a href="<?php echo e($reports[1]['document']); ?>" target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                    </div>
                                    <div class="overlay-text-right">
                                        <a href="<?php echo e($reports[1]['document']); ?>" download="<?php echo e($reports[1]['name']); ?>"
                                            target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
                <div class="tab-pane fade" id="pills-2022" role="tabpanel" aria-labelledby="pills-home-tab">
                    <section class="text-center">
                        <div class="image-container" style="height:400px;width:30%;">
                            <img src="<?php echo e($reports[2]['image']); ?>" alt="Image" height="350px"
                                style="object-fit: cover; width: auto; max-width: 100%;" class="overlay-report-image">
                            <div class="new-overlay">
                                <p style="color:#08BABB; font-weight:bold"><?php echo e($reports[2]['year']); ?></p>
                                <div style="padding-top:60%">
                                    <h4 style="color:#08BABB">Annual Report <?php echo e($reports[2]['year']); ?></h4>
                                </div>
                                <div style="justify-content: space-between;display:flex;">
                                    <div class="overlay-text-left">
                                        <a href="<?php echo e($reports[2]['document']); ?>" target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                    </div>
                                    <div class="overlay-text-right">
                                        <a href="<?php echo e($reports[2]['document']); ?>" download="<?php echo e($reports[2]['name']); ?>"
                                            target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
                <div class="tab-pane fade" id="pills-2021" role="tabpanel" aria-labelledby="pills-profile-tab">
                    <section class="text-center">
                        <div class="image-container" style="height:400px;width:30%;">
                            <img src="<?php echo e($reports[3]['image']); ?>" alt="Image" height="350px"
                                style="object-fit: cover; width: auto; max-width: 100%;" class="overlay-report-image">
                            <div class="new-overlay">
                                <p style="color:#08BABB; font-weight:bold"><?php echo e($reports[2]['year']); ?></p>
                                <div style="padding-top:60%">
                                    <h4 style="color:#08BABB">Annual Report <?php echo e($reports[2]['year']); ?></h4>
                                </div>
                                <div style="justify-content: space-between;display:flex;">
                                    <div class="overlay-text-left">
                                        <a href="<?php echo e($reports[3]['document']); ?>" target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                    </div>
                                    <div class="overlay-text-right">
                                        <a href="<?php echo e($reports[3]['document']); ?>" download="<?php echo e($reports[3]['name']); ?>"
                                            target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
                <div class="tab-pane fade" id="pills-2020" role="tabpanel" aria-labelledby="pills-contact-tab">
                    <section class="text-center">
                        <div class="image-container" style="height:400px;width:30%;">
                            <img src="<?php echo e($reports[2]['image']); ?>" alt="Image" height="350px"
                                style="object-fit: cover; width: auto; max-width: 100%;" class="overlay-report-image">
                            <div class="new-overlay">
                                <p style="color:#08BABB; font-weight:bold"><?php echo e($reports[2]['year']); ?></p>
                                <div style="padding-top:60%">
                                    <h4 style="color:#08BABB">Annual Report <?php echo e($reports[2]['year']); ?></h4>
                                </div>
                                <div style="justify-content: space-between;display:flex;">
                                    <div class="overlay-text-left">
                                        <a href="<?php echo e($reports[2]['document']); ?>" target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                    </div>
                                    <div class="overlay-text-right">
                                        <a href="<?php echo e($reports[2]['document']); ?>" download="<?php echo e($reports[2]['name']); ?>"
                                            target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
                
            </div>


        </div>

    </div>

    <div class="mt-6" data-aos="fade-in" data-aos-delay="200" >
        <div class="px-3">
            <div class="container">
                <div class="mx-auto" style="width: 70%">
                    <h3>PhoenixBev Financial Results & Presentations</h3>
                </div>
                <div class="investor-relations">
                    <ul class="nav nav-pills justify-content-center mx-auto dark" style="width:80%;">
                        <li class="nav-item">
                            <button class="nav-link dark-nav-item active" id="tab-1" data-bs-toggle="pill"
                                data-bs-target="#tablet-1" type="button" role="tab" aria-controls="tab-1"
                                aria-selected="true">Abridged
                                Reports</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link dark-nav-item" id="tab-2" data-bs-toggle="pill"
                                data-bs-target="#tablet-2" type="button" role="tab" aria-controls="tab-2"
                                aria-selected="true">Notices &
                                Communiqué</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link dark-nav-item" id="tab-3" data-bs-toggle="pill"
                                data-bs-target="#tablet-3" type="button" role="tab" aria-controls="tab-3"
                                aria-selected="false">Diviends
                                Information</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link dark-nav-item" id="tab-4" data-bs-toggle="pill"
                                data-bs-target="#tablet-4" type="button" role="tab" aria-controls="tab-4"
                                aria-selected="false">Shareholder's
                                Corner</button>
                        </li>

                    </ul>

                    <div class="tab-content mt-3">
                        <div class="tab-pane fade show active" id="tablet-1" role="tabpanel" aria-labelledby="tab-1">

                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">Abridged Unaudited Results for the Quarter and Nine Months
                                    <br>Ended 31 March 2025</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2025/PBL_abridged_accounts-31.03.2025.pdf')); ?>"
                                        target="_blank">
                                        <span span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2025/PBL_abridged_accounts-31.03.2025.pdf')); ?>"
                                        download="PBL_abridged_accounts-31.03.2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span>
                                        Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">Abridged Unaudited Results for the Quarter and Half Year <br>Ended
                                    31 December 2024</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2024/PBL-abridged_accounts_31.12.2024.pdf')); ?>"
                                        target="_blank">
                                        <span span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2024/PBL-abridged_accounts_31.12.2024.pdf')); ?>"
                                        download="PBL-abridged_accounts_31.12.2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span>
                                        Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">Condensed Unaudited Results for the Quarter Ended 30 September 2024
                                </div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2024/PBL-ABRIDGED-30.09.2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2024/PBL-ABRIDGED-30.09.2024.pdf')); ?>"
                                        download="PBL-ABRIDGED-30.09.2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">Condensed Audited Results for the Year Ended 30 June 2024</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2024/PBL-ABRIDGED-30_06_2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2024/PBL-ABRIDGED-30_06_2024.pdf')); ?>"
                                        download="PBL-ABRIDGED-30_06_2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">Abridged Unaudited Results for the Quarter and Nine Months <br>
                                    Ended 31 March 2024</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2024/PBL-ABRIDGED-31-March-2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_abridged_reports/2024/PBL-ABRIDGED-31-March-2024.pdf')); ?>"
                                        download="PBL-ABRIDGED-31-March-2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>

                            <div class="learnMore text-right mt-4">
                                <a href="<?php echo e(route('pblarchive.report')); ?>" class="smaller-text">Explore</a>
                            </div>

                        </div>
                        <div id="tablet-2" class="tab-pane fade">

                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">PBL_SeyBrew_Transanction_circular</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_SeyBrew_Transanction_circular.pdf')); ?>"
                                        target="_blank">
                                        <span span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_SeyBrew_Transanction_circular.pdf')); ?>"
                                        download="PBL_SeyBrew_Transanction_circular.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">Circular Communique</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_circular_communique.pdf')); ?>"
                                        target="_blank">
                                        <span span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_circular_communique.pdf')); ?>"
                                        download="PBL_circular_communique.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">Abridged Unaudited Results for the Quarter Notice, </br>Ended 31
                                    March 2025</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_NOTICE-31.03.2025.pdf')); ?>"
                                        target="_blank">
                                        <span span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_NOTICE-31.03.2025.pdf')); ?>"
                                        download="PBL_NOTICE-31.03.2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">PBL Share Purchase Agreement Communiqué</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL-Communiqué_02April2025.pdf')); ?>"
                                        target="_blank">
                                        <span span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL-Communiqué_02April2025.pdf')); ?>"
                                        download="PBL-Communiqué_02April2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">Cautionary Announcement</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_Cautionary_Announcement.pdf')); ?>"
                                        target="_blank">
                                        <span span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2025/PBL_Cautionary_Announcement.pdf')); ?>"
                                        download="PBL_Cautionary_Announcement.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">PBL Abridged Unaudited Financial Statement Notice, December 2024
                                </div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2024/PBL-Notice_to_Abridged_31.12.2024.pdf')); ?>"
                                        target="_blank">
                                        <span span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2024/PBL-Notice_to_Abridged_31.12.2024.pdf')); ?>"
                                        download="PBL-Notice_to_Abridged_31.12.2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span> Download PDF
                                    </a>
                                </div>
                            </div>

                            <div class="learnMore text-right my-4">
                                <a href="<?php echo e(route('pblarchive.report')); ?>" class="smaller-text">Explore</a>
                            </div>

                        </div>

                        <div id="tablet-3" class="tab-pane fade">

                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">Dividend Announcement, March 2025</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_diviends_information/2025/PBL_DIVIDEND-31.03.2025.pdf')); ?>"
                                        target="_blank">
                                        <span span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_diviends_information/2025/PBL_DIVIDEND-31.03.2025.pdf')); ?>"
                                        download="PBL_DIVIDEND-31.03.2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">Dividend Announcement, 30 September 2024</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_diviends_information/2024/PBL-DIVIDEND-SeptemberT-2024.pdf')); ?>"
                                        target="_blank">
                                        <span span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_diviends_information/2024/PBL-DIVIDEND-SeptemberT-2024.pdf')); ?>"
                                        download="PBL-DIVIDEND-SeptemberT-2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                <div class="ann-report">Dividend Announcement, 31 Mar 2024</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_diviends_information/2024/PBL-DIVIDEND-ANNOUNCEMENT-may-2024.pdf')); ?>"
                                        target="_blank">
                                        <span span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_diviends_information/2024/PBL-DIVIDEND-ANNOUNCEMENT-may-2024.pdf')); ?>"
                                        download="PBL-DIVIDEND-ANNOUNCEMENT-may-2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="learnMore text-right my-4">
                                <a href="<?php echo e(route('pblarchive.report')); ?>" class="smaller-text">Explore</a>
                            </div>
                        </div>

                        <div id="tablet-4" class="tab-pane fade">
                            <div class="coporate-document-box">
                                <div class="coporate-document dark-document">
                                    <p class="fw-bold"> Notice for Annual Meeting 2024 </p>
                                    <div>
                                        <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_notices_communiques/2024/PBL_IAR_2024_Annual_Meeting.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                    </div>
                                </div>

                                <div class="coporate-document dark-document">
                                    <p>Proxy Form </p>
                                    <div>
                                        <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_Proxy_Form/2024/PBL_IAR 2024_Proxy_Form.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_Proxy_Form/2024/PBL_IAR 2024_Proxy_Form.pdf')); ?>"
                                            download="PBL_IAR 2024_Proxy_Form.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>
                                <div class="coporate-document dark-document">

                                    <p>Shareholders information</p>
                                    <div>
                                        <a href="<?php echo e(route('holding-companies')); ?>" class="smaller-text">
                                            <span class="fa fa-eye mx-2"></span> Explore
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-section py-6" data-aos="fade-in" data-aos-delay="200" >
            <div class="container"  style="padding-bottom: 500px">
                <div class="investor-relations">
                    <div class="mx-auto" style="width: 70%">
                        <h3> PICL Financial Results & Presentations</h3>
                        <p>Phoenix Investment Company Limited (PICL) Holding Companies </p>
                    </div>

                    <ul class="nav nav-pills" style="width:70%; justify-content:space-between; padding: 18px 10px">
                        <li class="nav-item">
                            <button class="nav-link active" id="tab-1" data-bs-toggle="pill"
                                data-bs-target="#tablet-31" type="button" role="tab" aria-controls="tab-1"
                                aria-selected="true">PICL Abridged
                                Results</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="tab-3" data-bs-toggle="pill" data-bs-target="#tablet-33"
                                type="button" role="tab" aria-controls="tab-3" aria-selected="false">Shareholder's
                                Corner</button>
                        </li>
                    </ul>

                    <div class="tab-content my-3" style="height: 100%;">
                        <div class="tab-pane fade show active" id="tablet-31" role="tabpanel" aria-labelledby="tab-1">

                            <div>
                                <h5 class="px-4">March 2025</h5>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between">
                                <div class="ann-report">Abridged Unaudited Results for the Quarter</br>Ended 31 March 2025
                                </div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2025/Abridged_report/PICL_abridged_account-31.03.2025.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2025/Abridged_report/PICL_abridged_account-31.03.2025.pdf')); ?>"
                                        download="PICL_abridged_account-31.03.2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span>
                                        Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between">
                                <div class="ann-report">Abridged Unaudited Financial </br>Statements Notice, Ended 31 March
                                    2025</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2025/Notices/PICL_NOTICE-31.03.2025.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2025/Notices/PICL_NOTICE-31.03.2025.pdf')); ?>"
                                        download="PICL_NOTICE-31.03.2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span>
                                        Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between">
                                <div class="ann-report">Dividend Announcement, </br>March 2025</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2025/Dividends-information/PICL_DIVIDEND-31.03.2025.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2025/Dividends-information/PICL_DIVIDEND-31.03.2025.pdf')); ?>"
                                        download="PICL_DIVIDEND-31.03.2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span>
                                        Download PDF
                                    </a>
                                </div>
                            </div>

                            <hr class="gradient">

                            <div>
                                <h5 class="px-4">December 2024</h5>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between">
                                <div class="ann-report">Abridged Unaudited Results, December 2024</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Abridged_report/PICL-abridged_accounts_31.12.2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Abridged_report/PICL-abridged_accounts_31.12.2024.pdf')); ?>"
                                        download="PBL-abridged_accounts_31.12.2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span>
                                        Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between">
                                <div class="ann-report">PICL Abridged Unaudited Financial Statement Notice, December 2024
                                </div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Notices/PICL-Notice_to_Abridged_31.12.2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/PICL-Notice_to_Abridged_31.12.2024.pdf')); ?>"
                                        download="PICL-Notice_to_Abridged_31.12.2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"></span>
                                        Download PDF
                                    </a>
                                </div>
                            </div>

                            <hr class="gradient">

                            <div>
                                <h5 class="px-4">September 2024</h5>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between">
                                <div class="ann-report">Abridged Report</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Abridged_report/PICL-ABRIDGED-30.09.2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Abridged_report/PICL-ABRIDGED-30.09.2024.pdf')); ?>"
                                        download="PICL-ABRIDGED-30.09.2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between">
                                <div class="ann-report">Abridged Notice</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Notices/PICL-NOTICE-SeptemberT-2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Notices/PICL-NOTICE-SeptemberT-2024.pdf')); ?>"
                                        download="PICL-NOTICE-SeptemberT-2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between">
                                <div class="ann-report">Dividends Information</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Dividends-information/PICL-DIVIDEND-SeptemberT-2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Dividends-information/PICL-DIVIDEND-SeptemberT-2024.pdf')); ?>"
                                        download="PICL-DIVIDEND-SeptemberT-2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>

                            <hr class="gradient">

                            <div>
                                <h5 class="px-4">June 2024</h5>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between">
                                <div class="ann-report">Abridged Report</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Abridged_report/PICL-ABRIDGED-30_06_2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Abridged_report/PICL-ABRIDGED-30_06_2024.pdf')); ?>"
                                        download="PICL-ABRIDGED-30_06_2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="integrated-report-cards d-flex justify-content-between">
                                <div class="ann-report">Abridged Notice</div>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Notices/PICL-Notice_26_September_2024.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> View
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Notices/PICL-Notice_26_September_2024.pdf')); ?>"
                                        download="PICL-Notice_26_September_2024.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>

                            
                            <div class="learnMore text-right my-4">
                                <a href="<?php echo e(route('piclholding.report')); ?>" class="smaller-text">Explore</a>
                            </div>
                        </div>

                        <div id="tablet-33" class="tab-pane fade">
                            <div class="coporate-document-box">
                                <div class="coporate-document">
                                    <p>PICL Shareholders information</p>
                                    <div>
                                        <a href="<?php echo e(route('holding-companies-picl')); ?>" class="smaller-text">
                                            <span class="fa fa-eye mx-2"></span> Explore
                                            
                                        </a>
                                    </div>
                                </div>
                                <div class="coporate-document">
                                    <p>PICL Annual Report 2024</p>
                                    <div>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Annual_report/PICL_AR_2024_V2.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Annual_report/PICL_AR_2024_V2.pdf')); ?>"
                                            download="PICL_AR_2024_V2.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <div class="coporate-document-box">
                                <div class="coporate-document">
                                    <p class="fw-bold">PICL Notice of Annual Meeting to Shareholders</p>
                                    <div>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Notices/PICL_AR_2024_Annual_Meeting.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Phoenix_Investment_Company_Limited_PICL/2024/Notices/PICL_AR_2024_Annual_Meeting.pdf')); ?>"
                                            download="PICL_AR_2024_Annual_Meeting.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="page-blue py-6 px-3" data-aos="fade-down" data-aos-delay="200" >
                <div class="container">
                    <div class="investor-relations" style="padding-bottom: 700px">
                        <div class="mx-auto" style="width: 70%">
                            <h3>CICL financial results & presentations</h3>
                            <Camp>Camp Investment Company Limited (CICL) Holding Company</p>
                        </div>

                        <ul class="nav nav-pills dark"
                            style="width:70%; justify-content:space-between; padding: 20px 10px">
                            <li class="nav-item">
                                <button class="nav-link dark-nav-item active" id="tab-1" data-bs-toggle="pill"
                                    data-bs-target="#tablet-10" type="button" role="tab" aria-controls="tab-1"
                                    aria-selected="true">CICL Abridged
                                    Results</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link dark-nav-item" id="tab-3" data-bs-toggle="pill"
                                    data-bs-target="#tablet-13" type="button" role="tab" aria-controls="tab-3"
                                    aria-selected="false">Shareholder's
                                    Corner</button>
                            </li>
                        </ul>



                        <div class="tab-content mt-3">
                            <div class="tab-pane fade show active" id="tablet-10" role="tabpanel"
                                aria-labelledby="tab-1">

                                <div>
                                    <h5 class="px-4">March 2025</h5>
                                </div>
                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">Abridged Unaudited Results for the Quarter</br>Ended 31 March
                                        2025</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2025/Abridged_report/CICL_abridged_accounts-31.03.2025.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2025/Abridged_report/CICL_abridged_accounts-31.03.2025.pdf')); ?>"
                                            download="CICL_abridged_accounts-31.03.2025.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>
                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">Abridged Unaudited Financial </br>Statements Notice, Ended 31
                                        March 2025</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2025/Notices/CICL_NOTICE-31.03.2025.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('RReports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2025/Notices/CICL_NOTICE-31.03.2025.pdf')); ?>"
                                            download="CICL_NOTICE-31.03.2025.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>
                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">Dividend Announcement, March 2025</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2025/Dividends-information/CICL_DIVIDEND-31.02.2025.pd')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2025/Dividends-information/CICL_DIVIDEND-31.02.2025.pdf')); ?>"
                                            download="CICL_DIVIDEND-31.02.2025.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>

                                <hr class="gradient">

                                <div>
                                    <h5 class="px-4">December 2024</h5>
                                </div>
                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">Abridged Unaudited Results, December 2024</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Abridged_report/CICL-Abridged_accounts_31.12.2024.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Abridged_report/CICL-Abridged_accounts_31.12.2024.pdf')); ?>"
                                            download="CICL-Abridged_accounts_31.12.2024.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>

                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">CICL Abridged Unaudited Financial Statement Notice, December
                                        2024</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Notices/CICL-Notice_to_Abridged_31.12.2024.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Notices/CICL-Notice_to_Abridged_31.12.2024.pdf')); ?>"
                                            download="CICL-Notice_to_Abridged_31.12.2024.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>

                                <hr class="gradient">

                                <h5 class="px-4">September 2024</h5>
                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">Abridged Report</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Abridged_report/CICL-ABRIDGED-30.09.2024.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Abridged_report/CICL-ABRIDGED-30.09.2024.pdf')); ?>"
                                            download="CICL-ABRIDGED-30.09.2024.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>

                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">Abridged Notice</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Notices/CICL-NOTICE-SeptemberT-2024.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Notices/CICL-NOTICE-SeptemberT-2024.pdf')); ?>"
                                            download="CICL-NOTICE-SeptemberT-2024.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>

                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">Dividends Information</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Dividends-information/CICL-DIVIDEND-SeptemberT-2024.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Dividends-information/CICL-DIVIDEND-SeptemberT-2024.pdf')); ?>"
                                            download="CICL-DIVIDEND-SeptemberT-2024.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>

                                <hr class="gradient">

                                <h5 class="px-4">June 2024</h5>
                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">Abridged Report</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Abridged_report/CICL-ABRIDGED-30_06_2024.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Abridged_report/CICL-ABRIDGED-30_06_2024.pdf')); ?>"
                                            download="CICL-ABRIDGED-30_06_2024.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>

                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">Abridged Notice</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Notices/CICL-Notice_26_September_2024.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Notices/CICL-Notice_26_September_2024.pdf')); ?>"
                                            download="CICL-Notice_26_September_2024.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>

                                <hr class="gradient">

                                <h5 class="px-4">March 2024</h5>
                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">Abridged Report</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Abridged_report/CICL-ABRIDGED-March-2024.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Abridged_report/CICL-ABRIDGED-March-2024.pdf')); ?>"
                                            download="CICL-ABRIDGED-March-2024.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>

                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">Abridged Notice</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Notices/CICL-NOTICE-may-2024.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Notices/CICL-NOTICE-may-2024.pdf')); ?>"
                                            download="CICL-NOTICE-may-2024.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>

                                <div class="integrated-report-cards d-flex justify-content-between dark-document">
                                    <div class="ann-report">Dividends Information</div>
                                    <div class="document-actions">
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Dividends-information/CICL-DIVIDEND-ANNOUNCEMENT-may-2024.pdf')); ?>"
                                            target="_blank">
                                            <span class="fa fa-eye mx-1"></span> View
                                        </a>
                                        <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Dividends-information/CICL-DIVIDEND-ANNOUNCEMENT-may-2024.pdf')); ?>"
                                            download="CICL-DIVIDEND-ANNOUNCEMENT-may-2024.pdf" target="_blank">
                                            <span class="fa fa-download mx-1"> </span> Download PDF
                                        </a>
                                    </div>
                                </div>



                                <div class="learnMore text-right my-4">
                                    <a href="<?php echo e(route('ciclholding.report')); ?>" class="smaller-text">Explore</a>
                                </div>
                            </div>
                            <div id="tablet-13" class="tab-pane fade">
                                
                                <div class="coporate-document-box">
                                    <div class="coporate-document dark-document">
                                        <p class="fw-bold">CICL Shareholders information</p>
                                        <div>
                                            <a href="<?php echo e(route('holding-companies-cicl')); ?>" class="smaller-text">
                                                <span class="fa fa-eye mx-2"></span> Explore
                                            </a>
                                        </div>
                                    </div>

                                    <div class="coporate-document dark-document">
                                        <p class="fw-bold">CICL Annual Report 2024</p>
                                        <div>
                                            <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Annual_report/CICL_AR_2024_V2.pdf')); ?>"
                                                target="_blank">
                                                <span class="fa fa-eye mx-1"></span> View
                                            </a>
                                            <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Annual_report/CICL_AR_2024_V2.pdf')); ?>"
                                                download="CICL_AR_2024_V2.pdf" target="_blank">
                                                <span class="fa fa-download mx-1"> </span> Download PDF
                                            </a>
                                        </div>
                                    </div>
                                    <div class="coporate-document dark-document">
                                        <p class="fw-bold">PICL Notice of Annual Meeting to Shareholders</p>
                                        <div>
                                            <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Notices/CICL-NOTICE-may-2024.pdf')); ?>"
                                                target="_blank">
                                                <span class="fa fa-eye mx-1"></span> View
                                            </a>
                                            <a href="<?php echo e(asset('Reports/Shareholders-corner/Holding-Companies/Camp_Investment_Company_Limited_CICL/2024/Notices/CICL_AR_2024_Annual_Meeting.pdf')); ?>"
                                                download="CICL_AR_2024_Annual_Meeting.pdf" target="_blank">
                                                <span class="fa fa-download mx-1"> </span> Download PDF
                                            </a>
                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="py-6 text-center page-blue">
                <img src="<?php echo e(asset('images/corporate-governance/image3.png')); ?>" alt="" class="rounded" />
                <div>
                    *IBL Ltd is the ultimate holding company of Phoenix Beverages Limited
                </div>
            </div>
        </div>


        <script>
            // Global variables
            let currentChart = null;
            let currentPeriod = '1M';
            let stockMetrics = null;

            // Initialize everything when DOM is loaded
            document.addEventListener('DOMContentLoaded', function() {
                initializeStockChart();
                setupEventListeners();
            });

            // Setup event listeners
            function setupEventListeners() {
                // Timeframe button functionality
                document.querySelectorAll('.timeframe-btn').forEach(btn => {
                    btn.addEventListener('click', () => {
                        document.querySelectorAll('.timeframe-btn').forEach(b => b.classList.remove('active'));
                        btn.classList.add('active');
                        currentPeriod = btn.dataset.period;
                        updateChart(currentPeriod);
                    });
                });
            }

            // Main initialization function
            async function initializeStockChart() {
                try {
                    // Load stock metrics first
                    await loadStockMetrics();
                    
                    // Then create the chart
                    await createChart();
                    
                    // Set up auto-refresh every 5 minutes
                    setInterval(async () => {
                        await loadStockMetrics();
                        await updateChart(currentPeriod);
                    }, 300000); // 5 minutes
                    
                } catch (error) {
                    console.error('Error initializing stock chart:', error);
                }
            }

            // Load stock metrics and update UI
            async function loadStockMetrics() {
                try {
                    const response = await fetch('/api/stock-metrics');
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    
                    stockMetrics = await response.json();
                    
                    // Update UI elements
                    updateStockUI();
                    
                } catch (error) {
                    console.error('Error loading stock metrics:', error);
                    // Use fallback data
                    stockMetrics = getFallbackMetrics();
                    updateStockUI();
                }
            }

            // Update all stock UI elements
            function updateStockUI() {
                if (!stockMetrics) return;

                // Update price information
                const currentPriceElement = document.getElementById('current-price');
                const previousCloseElement = document.getElementById('previous-close');
                
                if (currentPriceElement) {
                    currentPriceElement.textContent = stockMetrics.currentPrice.toFixed(2);
                }
                
                if (previousCloseElement) {
                    previousCloseElement.textContent = stockMetrics.previousClose.toFixed(2);
                }
                
                // Update price change with color
                const priceChangeElement = document.getElementById('price-change');
                const percentageChangeElement = document.getElementById('percentage-change');
                
                if (priceChangeElement) {
                    priceChangeElement.textContent = (stockMetrics.priceChange >= 0 ? '+' : '') + stockMetrics.priceChange.toFixed(2);
                }
                
                if (percentageChangeElement) {
                    percentageChangeElement.textContent = (stockMetrics.percentageChange >= 0 ? '+' : '') + stockMetrics.percentageChange.toFixed(2) + '%';
                }
                
                // Set colors based on change
                const isPositive = stockMetrics.priceChange >= 0;
                const color = isPositive ? '#00ff88' : '#ff4444';
                if (priceChangeElement) priceChangeElement.style.color = color;
                if (percentageChangeElement) percentageChangeElement.style.color = color;

                // Update key metrics
                const volumeElement = document.getElementById('volume');
                const marketCapElement = document.getElementById('market-cap');
                const week52HighElement = document.getElementById('week52-high');
                const week52LowElement = document.getElementById('week52-low');
                const avgVolumeElement = document.getElementById('avg-volume');
                const yieldElement = document.getElementById('yield');
                
                if (volumeElement) volumeElement.textContent = stockMetrics.volume;
                if (marketCapElement) marketCapElement.textContent = stockMetrics.marketCap;
                if (week52HighElement) week52HighElement.textContent = stockMetrics.week52High;
                if (week52LowElement) week52LowElement.textContent = stockMetrics.week52Low;
                if (avgVolumeElement) avgVolumeElement.textContent = stockMetrics.avgVolume;
                if (yieldElement) yieldElement.textContent = stockMetrics.yield + '%';
            }

            // Fetch stock data for chart
            async function fetchStockData(period = '1M') {
                try {
                    const response = await fetch(`/api/stock-data-period?period=${period}`);
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    const data = await response.json();
                    
                    // Ensure data is an array
                    if (!Array.isArray(data)) {
                        return getFallbackStockData(period);
                    }
                    
                    // Ensure data has required properties
                    const validData = data.filter(item => 
                        item && 
                        typeof item.date === 'string' && 
                        typeof item.price === 'number' && 
                        !isNaN(item.price)
                    );
                    
                    if (validData.length === 0) {
                        return getFallbackStockData(period);
                    }
                    
                    return validData;
                } catch (error) {
                    console.error('Error fetching stock data:', error);
                    return getFallbackStockData(period);
                }
            }

            // Create the chart
            async function createChart() {
                try {
                    const stockData = await fetchStockData(currentPeriod);
                    
                    // Additional validation
                    if (!Array.isArray(stockData) || stockData.length === 0) {
                        return;
                    }
                    
                    const labels = stockData.map(stock => stock.date);
                    const priceData = stockData.map(stock => stock.price);

                    const canvas = document.getElementById('stockChart');
                    if (!canvas) {
                        return;
                    }

                    const ctx = canvas.getContext('2d');
                    if (!ctx) {
                        return;
                    }

                    // Destroy existing chart if it exists
                    if (currentChart) {
                        currentChart.destroy();
                    }

                    currentChart = new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: labels,
                            datasets: [{
                                label: 'Stock Price',
                                data: priceData,
                                borderColor: '#08BABB',
                                backgroundColor: 'rgba(8, 186, 187, 0.08)',
                                fill: true,
                                tension: 0.2,
                                borderWidth: 2.5,
                                pointRadius: 0,
                                pointHoverRadius: 5,
                                pointHoverBackgroundColor: '#08BABB',
                                pointHoverBorderColor: '#fff',
                                pointHoverBorderWidth: 2,
                                pointBorderWidth: 0,
                                pointBackgroundColor: 'transparent'
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            interaction: {
                                intersect: false,
                                mode: 'index'
                            },
                            plugins: {
                                legend: {
                                    display: false,
                                },
                                tooltip: {
                                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                                    titleColor: '#fff',
                                    bodyColor: '#fff',
                                    borderColor: '#08BABB',
                                    borderWidth: 1,
                                    cornerRadius: 8,
                                    displayColors: false,
                                    callbacks: {
                                        title: function(tooltipItems) {
                                            const date = new Date(tooltipItems[0].label);
                                            return date.toLocaleDateString('en-US', { 
                                                month: 'short', 
                                                day: 'numeric',
                                                year: 'numeric'
                                            });
                                        },
                                        label: function(tooltipItem) {
                                            return `Price: ${tooltipItem.raw.toFixed(2)} MUR`;
                                        }
                                    }
                                }
                            },
                            scales: {
                                x: {
                                    display: true,
                                    grid: {
                                        color: 'rgba(255, 255, 255, 0.05)',
                                        drawBorder: false
                                    },
                                    ticks: {
                                        color: '#888',
                                        font: {
                                            size: 10
                                        },
                                        maxTicksLimit: 6,
                                        callback: function(value, index, values) {
                                            const date = new Date(this.getLabelForValue(value));
                                            const today = new Date();
                                            const diffTime = Math.abs(today - date);
                                            const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
                                            
                                            // For 1D period, show just the date
                                            if (currentPeriod === '1D') {
                                                return date.toLocaleDateString('en-US', { 
                                                    month: 'short', 
                                                    day: 'numeric'
                                                });
                                            }
                                            // For recent dates (within 7 days), show day name
                                            else if (diffDays <= 7) {
                                                return date.toLocaleDateString('en-US', { 
                                                    weekday: 'short'
                                                });
                                            }
                                            // For dates within same year, show month and day
                                            else if (date.getFullYear() === today.getFullYear()) {
                                                return date.toLocaleDateString('en-US', { 
                                                    month: 'short', 
                                                    day: 'numeric'
                                                });
                                            }
                                            // For older dates, show month and year
                                            else {
                                                return date.toLocaleDateString('en-US', { 
                                                    month: 'short', 
                                                    year: '2-digit'
                                                });
                                            }
                                        }
                                    }
                                },
                                y: {
                                    display: true,
                                    position: 'right',
                                    grid: {
                                        color: 'rgba(255, 255, 255, 0.05)',
                                        drawBorder: false
                                    },
                                    ticks: {
                                        color: '#888',
                                        font: {
                                            size: 10
                                        },
                                        maxTicksLimit: 5,
                                        callback: function(value) {
                                            return value.toFixed(0);
                                        }
                                    },
                                    beginAtZero: false,
                                    suggestedMin: function(context) {
                                        const values = context.chart.data.datasets[0].data;
                                        return Math.min(...values) * 0.995;
                                    },
                                    suggestedMax: function(context) {
                                        const values = context.chart.data.datasets[0].data;
                                        return Math.max(...values) * 1.005;
                                    }
                                }
                            },
                            elements: {
                                point: {
                                    hoverRadius: 6
                                }
                            }
                        }
                    });
                } catch (error) {
                    console.error('Error creating chart:', error);
                }
            }

            // Update chart based on timeframe
            async function updateChart(period) {
                try {
                    const stockData = await fetchStockData(period);
                    
                    // Additional validation
                    if (!Array.isArray(stockData) || stockData.length === 0) {
                        return;
                    }
                    
                    const labels = stockData.map(stock => stock.date);
                    const priceData = stockData.map(stock => stock.price);

                    // Update chart data
                    if (currentChart) {
                        currentChart.data.labels = labels;
                        currentChart.data.datasets[0].data = priceData;
                        currentChart.update('none');
                    }
                } catch (error) {
                    console.error('Error updating chart:', error);
                }
            }

            // Fallback functions for when API fails
            function getFallbackMetrics() {
                const basePrice = 536.00;
                const change = (Math.random() - 0.5) * 10;
                
                return {
                    currentPrice: basePrice + change,
                    priceChange: change,
                    percentageChange: (change / basePrice) * 100,
                    previousClose: basePrice,
                    week52High: 124.69,
                    week52Low: 80.10,
                    volume: '4.804M',
                    avgVolume: '10.24M',
                    marketCap: '215.5B',
                    yield: 0.81,
                    lastUpdated: new Date().toLocaleString(),
                    currency: 'MUR',
                    exchange: 'SEMDEX'
                };
            }

            function getFallbackStockData(period = '1M') {
                const basePrice = 536.00;
                const volatility = 0.04;
                const trend = 0.002;
                
                let days;
                switch (period) {
                    case '1D':
                        days = 1; // Yesterday (most recent trading day)
                        break;
                    case '5D':
                        days = 5; // Last 5 days backwards from now
                        break;
                    case '1W':
                        days = 7; // Last 7 days backwards from now
                        break;
                    case '1M':
                        days = 30; // Last 30 days backwards from now
                        break;
                    case '3M':
                        days = 90; // Last 90 days backwards from now
                        break;
                    case '6M':
                        days = 180; // Last 180 days backwards from now
                        break;
                    case 'YTD':
                        const startOfYear = new Date(new Date().getFullYear(), 0, 1);
                        days = Math.ceil((new Date() - startOfYear) / (1000 * 60 * 60 * 24));
                        break;
                    case '1Y':
                        days = 365; // Last 365 days backwards from now
                        break;
                    case '2Y':
                        days = 730; // Last 730 days backwards from now
                        break;
                    default:
                        days = 30; // Default to last 30 days
                }
                
                const sampleData = [];
                const today = new Date();
                
                for (let i = days; i >= 0; i--) {
                    const date = new Date(today);
                    date.setDate(date.getDate() - i);
                    
                    const randomChange = (Math.random() - 0.5) * volatility;
                    const trendChange = trend * (days - i);
                    const priceChange = basePrice * (randomChange + trendChange);
                    const price = basePrice + priceChange;
                    
                    sampleData.push({
                        date: date.toISOString().split('T')[0],
                        price: Math.round(price * 100) / 100
                    });
                }
                
                return sampleData.sort((a, b) => new Date(a.date) - new Date(b.date));
            }
        </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views//investor-relations.blade.php ENDPATH**/ ?>