<style>
    .hero-section {
        position: relative;
        height: 80vh;
        width: 100%;
        overflow: hidden;
    }

    .hero-background {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-image: url('<?php echo e(asset('images/virtual-tour/img-virtual-cover.png')); ?>');
        background-size: cover;
        background-position: center;
        filter: brightness(0.5);
    }

    .hero-content {
        position: relative;
        z-index: 2;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        color: white;
        padding: 2rem;
    }

    .hero-text {
        max-width: 800px;
        margin-bottom: 2rem;
    }

    .hero-text h1 {
        font-size: 2.5rem;
        margin-bottom: 1.5rem;
        font-weight: bold;
    }

    .hero-text h3 {
        font-size: 2rem;
        margin-bottom: 1rem;
        font-weight: 500;
    }

    .hero-text p {
        font-size: 1.2rem;
        opacity: 0.9;
    }

    .play-button {
        width: 100px;
        height: 100px;
        border-radius: 50%;
        background-color: transparent;
        border: 3px solid #08BABB;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        padding: 0;
        gap: 8px;
        /* Add space between icon and text */
    }

    .play-button:hover {
        background-color: #08BABB;
        transform: scale(1.05);
    }

    .play-button .fa-play {
    font-size: 30px;
    color: #08BABB;
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-left: 4px;
    margin-bottom: 0;
}

.play-button .play-text {
    font-size: 12px;
    color: #08BABB;
    font-weight: bold;
    line-height: 1;
    margin: 0;
    padding: 0;
}

.play-button:hover {
    background-color: #08BABB;
    transform: scale(1.05);
    box-shadow: 0 0 20px rgba(0, 0, 0, 0.2);
}

    .play-button:hover .fa-play,
    .play-button:hover .play-text {
        color: white;
    }

    .video-modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.9);
        z-index: 1000;
    }

    .video-modal.active {
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .modal-content {
        position: relative;
        width: 80%;
        max-width: 1200px;
    }

    .close-modal {
        position: absolute;
        top: -40px;
        right: 0;
        color: white;
        font-size: 24px;
        cursor: pointer;
    }
</style>
<?php $__env->startSection('content'); ?>

    <div class="hero-section">
        <div class="hero-background"></div>
        <div class="hero-content">
            <div class="hero-text">
                <h1>Notre Héritage, Notre Savoir-Faire </h1>
                <h3>Brassage de la bière Phoenix chez Phoenix Beverages Limited</h3>
            </div>
            <button id="playButton" class="play-button">
                <span class="fa fa-play"></span>
                <div class="play-text">Regardez le processus de brassage</div>
            </button>
        </div>
    </div>

    <!-- Video Modal -->
    <div id="videoModal" class="video-modal">
        <div class="modal-content">
            <span class="close-modal">&times;</span>
            <video id="modalVideo" width="100%" controls>
                <source src="<?php echo e(asset('videos/virtual-tour/Voiceover_FRN.mp4')); ?>" type="video/mp4">
                Your browser does not support the video tag.
            </video>
        </div>
    </div>

    <div class="container landing-section-sus mb-6">
        <div class="row">
            <div class="col-12 col-lg-8 offset-lg-2">

                <p class="phoenix-bev-text" style="text-align: justify">
                    <b>Embarquez pour un voyage immersif au cœur de Phoenix Beverages Group. Découvrez notre riche héritage, nos processus de brassage
                        de pointe et notre engagement inébranlable à créer des boissons de qualité qui font partie de la vie mauricienne depuis des générations.</p>

                <p>

                <div class="d-flex justify-content-between align-items-center">
                    <p class="mb-0 fw-bold">Share</p>
                    <div class="footer-socials d-flex">
                        <span class="fa-brands fa-facebook-square mx-1"></span>
                        <span class="fa-brands fa-linkedin mx-1"></span>
                        <span class="fa fa-envelope mx-1" style="cursor: pointer"></span>
                    </div>
                </div>
                <hr>

            </div>
        </div>
    </div>

    <script>
        const playButton = document.getElementById('playButton');
        const videoModal = document.getElementById('videoModal');
        const modalVideo = document.getElementById('modalVideo');
        const closeModal = document.querySelector('.close-modal');

        playButton.addEventListener('click', () => {
            videoModal.classList.add('active');
            modalVideo.play();
        });

        closeModal.addEventListener('click', () => {
            videoModal.classList.remove('active');
            modalVideo.pause();
            modalVideo.currentTime = 0;
        });

        videoModal.addEventListener('click', (e) => {
            if (e.target === videoModal) {
                videoModal.classList.remove('active');
                modalVideo.pause();
                modalVideo.currentTime = 0;
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views//virtualtours/frn-virtualtours.blade.php ENDPATH**/ ?>