<?php $__env->startSection('content'); ?>
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url(<?php echo e(asset('images/sustainability/phoenix-earth_cover.png')); ?>);">
        </div>
        <div class="page-title-container">
            <h4>PHOENIXEARTH</h4>
            <span class="text-primary">The ESG Pole of Phoenix Beverages Group</span>
        </div>
    </div>

    <div class="container landing-section">
        <div class="row">
            <div class="col-12 col-lg-8 offset-lg-2">
                <div class="center">
                    <h2 data-aos="fade-up" data-aos-delay="500">A Step towards a Cleaner and Greener Planet</h2>
                    <p data-aos="fade-up" data-aos-delay="500">PhoenixEarth, an initiative by Phoenix Beverages Group, serves as the company's sustainability pillar,
                        positioning us as a key contributor to ecological and environmental development in Mauritius.
                        This initiative lies at the heart of our environmental efforts, which play a vital role in shaping
                        the reputation of Phoenix Beverages Group and its brands.
                    </p>
                </div>
            </div>
        </div>

        <div class="row pt-2 pb-5" data-aos="fade-up" data-aos-delay="500">
            <div class="col-12 w-50 mx-auto center" >
                <a href="https://phoenixearth.mu/" target="_blank">
                <img src="<?php echo e(asset('images/phoenix-earth/PhoenixEarth-logo.png')); ?>" alt="phoenix-Earth-Initiative" />
            </a>
            </div>

        </div>

    </div>

    <div class="main-section py-6 px-3">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-12" data-aos="fade-right" data-aos-delay="500">
                    <p class="px-2 fs-3">Advancing Sustainability and Environmental Stewardship in Mauritius</p>
                </div>

                <div class="col-lg-8 col-md-12" data-aos="fade-left" data-aos-delay="500">
                    <p style="text-align: justify" class="smaller-text">
                        To reduce plastic waste and its environmental impact, we collaborate with local stakeholders to implement various initiatives.
                        These include investing in plastic packaging collection and recycling, conducting community awareness campaigns, utilizing social media
                        to spread the message, and sponsoring litter bins. With the upcoming launch of PhoenixEarth, we aim to further scale up these efforts.
                    </p>
                    <p style="text-align: justify" class="smaller-text">
                        Our goal is to significantly increase PET collection rates in Mauritius, from the current 50% to 80%. By achieving this,
                        we aim to contribute to a sustainable future for our island and raise awareness about the environmental impact of resource consumption.
                        PhoenixEarth is committed to promoting PET recycling, responsible beverage consumption, and supporting sports and education initiatives.
                    </p>

                </div>

            </div>
        </div>
    </div>

    <div class="container my-6">
        <div class="row">
            <div class="col-lg-6 col-md-4 px-5" data-aos="fade-right" data-aos-delay="500">
                <h3>
                    The Legacy and Innovation of The Mauritius Glass Gallery
                </h3>
                <div>
                    <p style="text-align: justify"  class="smaller-text">
                        Founded in 1991, the Mauritius Glass Gallery is a captivating space where skilled artisans create unique, handcrafted glass artworks.
                        Located in Phoenix, this glass foundry was initially established as an environmental preservation initiative by the former
                        Mauritius Breweries Ltd and Phoenix Camp Minerals.
                    </p>
                    <p style="text-align: justify"  class="smaller-text">The primary goal was to recycle glass waste from these companies. Today, as part of the PhoenixEarth Initiative, we continue to champion
                        artistic innovation in glass upcycling and explore other sustainable recycling concepts, such as incorporating glass particles into asphalt production.
                    </p>
                </div>

            </div>
            <div class="col-lg-6 col-md-4 px-3" data-aos="fade-left" data-aos-delay="500">
                <div class="overview-image bg-image pbg-shadow"
                style="background-image: url(<?php echo e(asset('images/phoenix-earth/figure-4.png')); ?>)" class="rounded">
                </div>
            </div>
        </div>

        <div class="row mt-6">
            <div class="col-lg-6 col-md-4 px-3" data-aos="fade-right" data-aos-delay="500">
                <div class="overview-image bg-image pbg-shadow"
                style="background-image: url(<?php echo e(asset('images/phoenix-earth/figure-3.png')); ?>)" class="rounded">
                </div>
            </div>

            <div class="col-lg-6 col-md-4 px-4" data-aos="fade-left" data-aos-delay="500">
                <h3>
                    Experiences and Treasures at The Mauritius Glass Gallery
                </h3>
                <div>
                    <p style="text-align: justify"  class="smaller-text">
                        The Mauritius Glass Gallery offers visitors a unique opportunity to witness the traditional glass-blowing process firsthand
                        or even create a personalized glass keepsake with a hand or foot imprint. The gallery showcases a diverse collection of captivating
                        glass objects, including stunning lampshades, stained-glass paintings, vases, and drinking vessels, all available for purchase.
                    </p>
                    <p style="text-align: justify"  class="smaller-text">
                        Opening Hours :
                        <ul class="smaller-text">
                            <li>Monday to Friday: 08h00 - 17h00</li>
                            <li>Saturday: 08h00 - 12h00</li>
                            <li>Sunday & Public Holidays: 09h00 - 12h00 </li>

                        </ul>
                        <span class="smaller-text">For visits, it is mandatory to make reservations 24 hours before the desired visiting time.
                            All reservations can be done via the PhoenixEarth website or email on mgg@phoenixbev.mu
                        </span>
                    </p>
                </div>

            </div>
        </div>

        

        
        
    </div>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views//phoenix-earth.blade.php ENDPATH**/ ?>