<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <?php echo $__env->make('includes.head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>

<body class="stretched">

    <!-- Document Wrapper
 ============================================= -->
    <div id="wrapper">


        <!-- Header
  ============================================= -->
        <header id="header">
            <div id="header-wrap">
                <div class="container">
                    <div class="header-row">

                        <!-- Logo
      ============================================= -->
                        <div id="logo">
                            <a href="<?php echo e(route('home')); ?>">
                                <img class="logo-default" srcset="<?php echo e(URL::asset('images/pbg-logo.png')); ?>"
                                    src="<?php echo e(URL::asset('images/pbg-logo.png')); ?>" alt="PBG Logo">
                            </a>
                        </div><!-- #logo end -->

                        <div class="primary-menu-trigger">
                            <button class="cnvs-hamburger" type="button" title="Open Mobile Menu">
                                <span class="cnvs-hamburger-box"><span class="cnvs-hamburger-inner"></span></span>
                            </button>
                        </div>

                        <!-- Primary Navigation
      ============================================= -->
                    </div>
                </div>
            </div>
        </header><!-- #header end -->



        <div class="page-blue">
            <div class="about-banner contact-banner bg-image"
                style="background-image: url(<?php echo e(asset('images/news-room/newsroom.png')); ?>);">
            </div>
            <div class="page-title-container">
                <h4>NEWSROOM</h4>
                <span class="text-primary">Latest Update</span>
            </div>
        </div>

        <div class="container landing-section news-category">
            <div class="ul-container">
                <ul>
                    <li class="active">All</li>
                    <li>SDG's</li>
                    <li>Sustainability</li>
                    <li>Technology</li>
                </ul>
                <ul>
                    <li>Press Release</li>
                    <li>Press Articles</li>
                    <li>News</li>
                    <li>Events</li>
                </ul>
            </div>

            <div class="search-container">
                <span class="fa fa-search"></span>
                <input type="text" class="form-control" placeholder="Search here">
            </div>
        </div>


        <div class="container my-6">
            <h3 class="mb-6">latest news</h3>
            <div class="row newsroom-biobin newsroom-info-box">
                <div class="col-lg-6 col-md-12">
                    <img src="<?php echo e(asset('images/news-room/biobin.png')); ?>" alt="" />
                    <span class="overlay-button">Business</span>
                </div>
                <div class="col-lg-6 col-md-12 newsroom-text ">
                    <h2>Phoenix Beverages Group innovates with the implementation of BiobiN™</h2>
                    <p>As part of its commitment to reduce its carbon footprint, the Phoenix Beverages Group has decided
                        to
                        invest in a state-of-the-art
                        biowaste management system within its business unit since April 3rd.
                    </p>
                    <span class="date">11 June 2024</span>

                </div>
            </div>
        </div>


        <br>
        <div class="container my-6">
            <div class="row newsroom-crop">
                <div class="col-lg-5 col-md-12 newsroom-crop-box">
                    <img src="<?php echo e(asset('images/news-room/plants.png')); ?>" alt="" />
                    <div class="newsroom-plant">
                        <h4>A game changer in organic waste management</h4>
                        <p>As part of its commitment to reduce its carbon footprint, the Phoenix Beverages Group has
                            decided to
                            invest in a state-of-the-art biowaste</p>
                        <span class="date">11 June 2024</span>

                    </div>
                </div>
                <div class="col-lg-6 col-md-12 newsroom-div">
                    <h4>Most Read Articles</h4>
                    <div class="row ">
                        <div class="col-lg-6 col-md-6  news-room-content">
                            <img src="<?php echo e(asset('images/news-room/awareness.png')); ?>" alt="" />
                        </div>
                        <div class="col-lg-6 col-md-6 detail-news">
                            <p>Phoenix Beverages Group expands its ...</p>
                            <span>As part of its commitment to reduce its carbon footprint,
                                the Phoenix Beverages Group has decided to invest in a state-of-the-art biowaste
                            </span>
                            <p class="date">11 February, 2024</p>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-lg-6 col-md-6  news-room-content">
                            <img src="<?php echo e(asset('images/news-room/plants.png')); ?>" alt="" />
                        </div>
                        <div class="col-lg-6 col-md-6 detail-news">
                            <p>Phoenix Beverages Group expands its ...</p>
                            <span>As part of its commitment to reduce its carbon footprint,
                                the Phoenix Beverages Group has decided to invest in a state-of-the-art biowaste
                            </span>
                            <p class="date">11 February, 2024</p>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-lg-6 col-md-6 news-room-content">
                            <img src="<?php echo e(asset('images/news-room/plants.png')); ?>" alt="" />
                        </div>
                        <div class="col-lg-6 col-md-6 detail-news">
                            <p>Phoenix Beverages Group expands its ...</p>
                            <span>As part of its commitment to reduce its carbon footprint,
                                the Phoenix Beverages Group has decided to invest in a state-of-the-art biowaste
                            </span>
                            <p class="date">11 February, 2024</p>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <br>
        <div class="container my-6">
            <h3 class="text-center">All News</h3>

            <div class="row all-news-class" id="all-news-id"></div>

            <div class="row all-news-btn">
                <div class="col-12 center">
                    <button class="btn btn-default btn-pbg" id="load-more-button" onclick="loadNews()">Load
                        More</button>
                </div>
            </div>

        </div>



        <script>
            var current_page = 1;
            var image_base_path = "<?php echo e(asset('images')); ?>";
            console.log(image_base_path)

            function loadNews() {
                $("#load-more-button").html("<div class='loader'></div>");
                $.ajax({
                    url: "<?= route('news-api') ?>",
                    type: 'GET',
                    data: {
                        page: current_page
                    },
                    dataType: 'json',
                    success: function(data) {
                        var news = data.news.data;
                        for (let i = 0; i < news.length; i++) {
                            var news_column =
                                `<div class="col-md-12 col-lg-4">
                                <div class="news-box news-info-box">
                                        <img src="${image_base_path}${news[i]['image']}" alt="News Image">
                                        <div class="overlay">
                                            <span>Business</span>
                                        </div>
                                         <div class="news-text">
                                            <p class="news-title">${news[i]['title']}</p>
                                            <div class="news-meta">
                                                <p class="news-date">${news[i]['date']}</p>
                                                <div class="read-more">Read more</div>
                                            </div>
                                            
                                        </div>
                                </div>
                            </div>
                            </div>`;
                            $("#all-news-id").append(news_column);
                        }
                        $("#load-more-button").html("Load More");
                    },
                    error: function(request, error) {}
                });
                current_page = current_page + 1;
            }

            document.addEventListener("DOMContentLoaded", function(event) {
                loadNews()
            });
        </script>

    </div><!-- #wrapper end -->

    <!-- Go To Top
 ============================================= -->
    <div id="gotoTop" class="uil uil-angle-up"></div>

    <!-- JavaScripts
 <?php echo $__env->make('includes.script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

</body>
</html>

<?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views//integrated-report.blade.php ENDPATH**/ ?>