<?php $__env->startSection('content'); ?>
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url(<?php echo e(asset('images/corporate-governance/governance_cover.png')); ?>);">
        </div>
        <div class="page-title-container">
            <h4>Corporate Governance</h4>
            <span class="text-primary">Practicing Good Governance at Phoenix Beverages Group</span>
        </div>
    </div>

    <div class="container landing-section mb-6">
        <div class="row">
            <div class="col-lg-6 col-md-12 pt-4 px-4" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                <h3>Good Governance Principles</h3>
                <p class="text-justify smaller-text">The Board of Phoenix Beverages Group is committed to maintaining the highest
                    standards of responsible conduct and best practices in accordance with the Mauritius Code of Corporate Governance.
                    <br><br>
                    Aligned with this commitment, we foster a culture that prioritises exemplary ethics, personal integrity, and corporate responsibility.
                    Our policy requires directors, employees, shareholders, officers, and all stakeholders to uphold the highest ethical standards.
                </p>
            </div>

            <div class="col-lg-6 col-md-12" data-aos="fade-left" data-aos-duration="500" data-aos-easing="linear">

                <div class="overview-image bg-image pbg-shadow"
                    style="background-image: url(<?php echo e(asset('images/corporate-governance/BOD.png')); ?>)"  class="rounded" >

                </div>
            </div>
        </div>

    </div>


    <div class="main-section py-6 px-3" data-aos="fade-up" data-aos-duration="500" data-aos-easing="linear">
        <div class="container">
            <div class="corporate-governance">
                <ul class="nav nav-pills">
                    <li class="nav-item">
                        <a class="nav-link active" id="tab1-link" href="#tab1" data-bs-toggle="pill">Charter</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="tab2-link" href="#tab2" data-bs-toggle="pill">Code of Ethics</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="tab2-link" href="#tab3" data-bs-toggle="pill">Statutory Documents</a>
                    </li>
                </ul>

                <div class="tab-content mt-3">
                    <div id="tab1" class="tab-pane fade show active">
                        <!-- First row with a single image centered -->
                        <div class="coporate-document-box">
                            <div class="coporate-document">
                                <p class="fw-bold">Board Charter</p>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Governance/Board_Charter-May2025_signed.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> view
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Governance/Board_Charter-May2025_signed.pdf')); ?>"
                                        download="Board_Charter-May2025_signed.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>

                            <div class="coporate-document">
                                <p>Audit and Risk Committee Charter</p>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Governance/PBL-Audit_and_Risk_Committee_Charter_April_2025.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> view
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Governance/PBL-Audit_and_Risk_Committee_Charter_April_2025.pdf')); ?>"
                                        download="PBL-Audit_and_Risk_Committee_Charter_April_2025.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="coporate-document">
                                <p>Corporate Governance Committee Charter</p>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Governance/PBL-Corporate-Governance-Committee-Charter-May-2023.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> view
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Governance/PBL-Corporate-Governance-Committee-Charter-May-2023.pdf')); ?>"
                                        download="PBL-Corporate-Governance-Committee-Charter-May-2023.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="tab2" class="tab-pane fade">
                        <div class="coporate-document-box">
                            <div class="coporate-document">
                                <p class="fw-bold">Code of Ethics</p>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Governance/Cod_of_Ethics_Feb_2023-HR-PO-003-Rev_5_25_04_2023.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> view
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Governance/Cod_of_Ethics_Feb_2023-HR-PO-003-Rev_5_25_04_2023.pdf')); ?>"
                                        download="Cod_of_Ethics_Feb_2023-HR-PO-003-Rev_5_25_04_2023.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div id="tab3" class="tab-pane fade">
                        <div class="coporate-document-box">
                            <div class="coporate-document">
                                <p class="fw-bold">Certificate of Incorporation </br>on Change of Name</p>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Governance/certificate-of-incorporation-change-of-name.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> view
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Governance/certificate-of-incorporation-change-of-name.pdf')); ?>"
                                        download="certificate-of-incorporation-change-of-name.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>

                            <div class="coporate-document">
                                <p>Constitution</p>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Governance/Constitution.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> view
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Governance/Constitution.pdf')); ?>"
                                        download="Constitution.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>
                            <div class="coporate-document">
                                <p>Amendment to Constitution</p>
                                <div class="document-actions">
                                    <a href="<?php echo e(asset('Reports/Governance/Amendment-to-Constitution.pdf')); ?>"
                                        target="_blank">
                                        <span class="fa fa-eye mx-1"></span> view
                                    </a>
                                    <a href="<?php echo e(asset('Reports/Governance/Amendment-to-Constitution.pdf')); ?>"
                                        download="Amendment-to-Constitution.pdf" target="_blank">
                                        <span class="fa fa-download mx-1"> </span> Download PDF
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="container landing-section mb-6">
        <div class="row">
            <div class="col-lg-6 col-md-12 px-4" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                <h3>COMPLIANCE</h3>
                <p class="text-justify smaller-text">Phoenix Beverages Limited (“Phoenix Beverages Group” or the “Company”), established on 9 September 1960, is a public interest entity
                    as defined under the Financial Reporting Act 2004 and is listed on the Official Market of the Stock Exchange of Mauritius Ltd. The Corporate Governance
                    Report outlines how the Group has implemented the principles of the National Code of Corporate Governance for Mauritius (2016) (the “Code”).

                    <br><br>
                    The Board of Directors remains fully committed to integrating sound governance principles into all aspects of Phoenix Beverages Group's operations,
                    ensuring they are reflected throughout the organisation.

                    For the financial year ended 30 June 2021, the Board confirms, to the best of its knowledge, that Phoenix Beverages Group has complied with the Code,
                    fully applying all its principles.
                </p>
            </div>

            <div class="col-lg-6 col-md-12" data-aos="fade-left" data-aos-duration="500" data-aos-easing="linear">

                <div class="overview-image bg-image pbg-shadow"
                style="background-image: url(<?php echo e(asset('images/corporate-governance/complience-img.png')); ?>)"  class="rounded" >

            </div>
            </div>
        </div>



        <div class="my-6 py-6">
            <div class="row">
                <div class="col-lg-6 col-md-12 fw-bolder" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                    CASCADE HOLDING STRUCTURE
                </div>

                <div class="col-lg-6 col-md-12 smaller-text" data-aos="fade-left" data-aos-duration="1000" data-aos-easing="linear">
                    Phoenix Beverages Limited is listed on the Official Market of the Stock Exchange of Mauritius Ltd. As of 30 June 2021, the Company's share register recorded
                    a total of 2,151 shareholders. The Company's stated capital comprises 16,447,000 ordinary shares, each with a nominal value of Rs10.00.
                </br>The shareholding structure is outlined as follows:
                </div>

            </div>


            <div class="my-6 text-center" data-aos="fade-up" data-aos-duration="1000" data-aos-easing="linear">
                <img src="<?php echo e(asset('images/corporate-governance/image3.png')); ?>" alt="" class="rounded" />
                <div class="smaller-text text-center">
                    *IBL Ltd is the ultimate holding company of Phoenix Beverages Limited
                </div>
            </div>


            <div class="mt-6 pt-6" >
                <div class="row">
                    <div class="col-lg-6 col-md-12 px-3" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                        <div class="overview-image bg-image pbg-shadow"
                        style="background-image: url(<?php echo e(asset('images/corporate-governance/audit_and_risk_img.png')); ?>)"  class="rounded" >
                        </div>
                    </div>

                    <div class="col-lg-6 col-md-12 px-3" data-aos="fade-left" data-aos-duration="500" data-aos-easing="linear">
                        <h3>Audit & Risk</h3>
                        <p class="compliance smaller-text" style="text-align: justify">
                            Risk is an integral component of value creation. Through proactive and timely risk management, we aim to mitigate risks to acceptable levels
                            while optimising opportunities for growth. The Board of Directors holds ultimate accountability for ensuring that risks are managed within
                            the defined risk appetite and for evaluating the effectiveness of risk management practices and internal controls.
                            <br><br>
                            Our risk management approach is an ongoing process designed to identify, analyse, and address opportunities and threats affecting both
                            short-term performance and long-term value creation.
                            <br><br>
                            Risks are classified into two categories: external and internal. External risks, beyond our control, include macroeconomic factors and market
                            conditions. Internal risks, within our control, pertain to operational aspects such as procedural inefficiencies, mechanical failures in
                            production, and non-compliance with applicable laws and regulations.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>



<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views//corporate-governance.blade.php ENDPATH**/ ?>