<link rel="stylesheet" href="<?php echo e(URL::asset('layout/tree.css')); ?>">
<style>
    .pbg-accordion .white-accordion .accordion-button {
        background-color: white !important;
        font-size: 16px !important;
        color: black !important;
        font-weight: bold;
        box-shadow: none;
        padding: 0px !important;
    }

    .pbg-accordion .white-accordion .accordion-body p {
        color: black !important;
        font-weight: 400;
        font-size: 12px;
    }

    .pbg-accordion .white-accordion .accordion-body {
        border: none !important;
        margin: auto;
        width: 90%;
    }

    .white-accordion {
        background-color: white !important;
        font-size: 16px !important;
        color: black !important;
        font-weight: bold;
        box-shadow: none;
    }

    .operation-parent-container {
        position: relative;
        width: 100%;
        min-height: 100vh;
        padding-top: 60px;
    }

    .operation-container {
        background: url('images/operations-structure/phoenixbev_operations.png');
        background-position: center;
        background-repeat: no-repeat;
        background-size: cover;
        width: 100%;
        min-height: 100vh;
        padding: 40px 0;
    }

    .bg-phoenix {
        background-image: url('images/operations-structure/phoenixbev_operations.png') !important;
    }

    .bg-grand-baie {
        background-image: url('images/operations-structure/african_original_hero-brands.jpg') !important;
    }

    .bg-riviere-noire {
        background-image: url('images/operations-structure/edena_operations.png') !important;
    }

    .bg-SeyBrew {
        background-image: url('images/operations-structure/seyBrew_Obrien_House_office.png') !important;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .pbg-accordion {
            margin-top: 20px !important;
        }
    }

    /* Ensure accordion content is always visible */
    .accordion-collapse {
        overflow: hidden;
    }

    .accordion-collapse.show {
        overflow: visible;
    }

    /* Mobile Responsive Styles */
    @media (max-width: 768px) {
        .about-banner {
            height: 300px !important;
            min-height: 300px;
            background-size: cover !important;
            background-position: center !important;
        }

        .page-title-container {
            position: relative !important;
            margin: 20px auto !important;
            margin-left: auto !important;
            margin-right: auto !important;
            margin-top: 20px !important;
            width: 90% !important;
            max-width: 90% !important;
            min-height: auto !important;
            padding: 30px 20px !important;
            text-align: center;
        }

        .page-title-container h4 {
            font-size: 1.6rem !important;
            margin-bottom: 10px !important;
        }

        .page-title-container .text-primary {
            font-size: 1.1rem !important;
        }

        .landing-section {
            padding-top: 50px !important;
            padding-bottom: 50px !important;
        }

        .landing-section h4 {
            font-size: 1.6rem !important;
            line-height: 1.3 !important;
            margin-bottom: 20px !important;
            text-align: center;
        }

        .landing-section p {
            font-size: 0.95rem !important;
            line-height: 1.6 !important;
            text-align: justify;
        }

        /* Tree Structure Mobile Optimization */
        .tree {
            font-size: 0.85rem !important;
            padding: 10px !important;
        }

        .tree li {
            margin: 8px 0 !important;
        }

        .tree li div {
            padding: 8px 12px !important;
            font-size: 0.8rem !important;
            min-height: auto !important;
        }

        .tree .pulse-two {
            padding: 10px 15px !important;
        }

        .tree .cascade div {
            padding: 8px 10px !important;
            font-size: 0.75rem !important;
        }

        .tree ul {
            margin-left: 15px !important;
        }

        .tree ul ul {
            margin-left: 10px !important;
        }

        .tree img {
            max-width: 60px !important;
            height: auto !important;
        }

        /* Container adjustments */
        .container-fluid {
            padding: 0 15px !important;
        }

        .lg-center-item {
            text-align: center !important;
        }

        .md-overflow {
            overflow-x: auto !important;
            -webkit-overflow-scrolling: touch !important;
        }

        /* Shareholding text */
        .landing-section > div:last-child p {
            font-size: 0.9rem !important;
            text-align: center !important;
            margin-top: 30px !important;
        }

        /* Operation Container */
        .operation-parent-container {
            height: auto !important;
            min-height: 400px !important;
            padding-top: 30px !important;
        }

        .operation-container {
            padding: 30px 20px !important;
            min-height: 400px !important;
        }

        .operation-container .row {
            margin: 0 !important;
        }

        .operation-container .col-md-8 {
            display: none !important;
        }

        .operation-container .col-md-4 {
            width: 100% !important;
            padding: 0 !important;
        }

        .operation-container .accordion {
            margin-top: 0 !important;
        }

        .white-accordion .accordion-button {
            font-size: 1rem !important;
            padding: 15px 20px !important;
        }

        .white-accordion .accordion-body {
            padding: 20px !important;
            width: 100% !important;
        }

        .white-accordion .accordion-body p {
            font-size: 0.9rem !important;
            line-height: 1.6 !important;
        }

        .white-accordion .accordion-body a {
            font-size: 0.9rem !important;
            display: inline-block !important;
            margin-top: 15px !important;
            padding: 8px 15px !important;
            background: #08BABB !important;
            color: white !important;
            text-decoration: none !important;
            border-radius: 5px !important;
        }
    }

    @media (max-width: 480px) {
        .about-banner {
            height: 250px !important;
            min-height: 250px;
        }

        .page-title-container {
            width: 95% !important;
            padding: 25px 15px !important;
        }

        .page-title-container h4 {
            font-size: 1.4rem !important;
        }

        .page-title-container .text-primary {
            font-size: 1rem !important;
        }

        .landing-section h4 {
            font-size: 1.4rem !important;
        }

        .landing-section p {
            font-size: 0.9rem !important;
        }

        /* Tree Structure for smaller screens */
        .tree {
            font-size: 0.75rem !important;
            padding: 5px !important;
        }

        .tree li div {
            padding: 6px 8px !important;
            font-size: 0.7rem !important;
        }

        .tree .pulse-two {
            padding: 8px 12px !important;
        }

        .tree .cascade div {
            padding: 6px 8px !important;
            font-size: 0.65rem !important;
        }

        .tree ul {
            margin-left: 10px !important;
        }

        .tree ul ul {
            margin-left: 8px !important;
        }

        .tree img {
            max-width: 50px !important;
        }

        .operation-container {
            padding: 20px 15px !important;
            min-height: 350px !important;
        }

        .white-accordion .accordion-button {
            font-size: 0.95rem !important;
            padding: 12px 15px !important;
        }

        .white-accordion .accordion-body {
            padding: 15px !important;
        }

        .white-accordion .accordion-body p {
            font-size: 0.85rem !important;
        }

        .white-accordion .accordion-body a {
            font-size: 0.85rem !important;
            padding: 6px 12px !important;
        }
    }
</style>
<?php $__env->startSection('content'); ?>
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url(<?php echo e(asset('images/cover-banners/operations-structure.png')); ?>);">
        </div>
        <div class="page-title-container">
            <h4>OUR GROUP OPERATIONS STRUCTURE</h4>
            <span class="text-primary">Group Dynamics and Cohesiveness.</span>
        </div>
    </div>

    <div class="container landing-section">
        <div class="row">
            <div class="col-12 col-lg-8 offset-lg-2">
                <div class="center" data-aos="fade-up" data-aos-duration="500" data-aos-easing="linear">
                    <h4> A Hub of Excellence </h4>
                    <p>Throughout our journey, our group has successfully explored avenues for growth and continues
                        to see abundant opportunities ahead. As a market leader in the FMCG industry, we are expanding our
                        activities and driving innovation.
                    </p>
                </div>

            </div>
        </div>


        <div class="container-fluid my-6">
            <div class="row">
                <div class="col-12 lg-center-item md-overflow" style="overflow-x: auto" data-aos="fade-up" data-aos-duration="500" data-aos-easing="linear">
                    <div>
                        <ul class="tree vertical">
                            <li>
                                <div class="d-flex justify-content-center" style="width: 30%">
                                    <img class="img-fluid w-50" srcset="<?php echo e(URL::asset('images/pbg-logo.png')); ?>"
                                        src="<?php echo e(URL::asset('images/pbg-logo.png')); ?>" alt="Phoenix Beverages Group" />
                                </div>
                                <ul>
                                    <li>
                                        <div>MAURITIUS</div>
                                        <ul>
                                            <li>
                                                <div class="pulse-two">
                                                    <a href="https://www.phoenixbev.mu" target="_blank">
                                                        <b>PHOENIXBEV</b>
                                                    </a>
                                                </div>
                                                <ul>
                                                    <li class="cascade">
                                                        <div><b>Local activities</b></div>
                                                        <ul>
                                                            <li>
                                                                <div>Brewery plant</div>
                                                            </li>
                                                            <li>
                                                                <div>Carbonated soft drinks plant</div>
                                                            </li>
                                                            <li>
                                                                <div>Stills plant</div>
                                                            </li>
                                                            <li>
                                                                <div>Sales & Distribution</div>
                                                            </li>
                                                        </ul>
                                                    </li>
                                                    <li class="cascade">
                                                        <div><b>Other activities</b></div>
                                                        <ul>
                                                            <li>
                                                                <div>Imports</div>
                                                            </li>
                                                            <li>
                                                                <div>Exports</div>
                                                            </li>
                                                            <li>
                                                                <div>Recycling</div>
                                                            </li>
                                                        </ul>
                                                    </li>
                                                </ul>
                                            </li>
                                            <li>
                                                <div>
                                                    PHOENIXBEV<br />RODRIGUES
                                                </div>
                                                <ul>
                                                    <li>
                                                        <div>Sales & Distribution</div>
                                                    </li>
                                                </ul>
                                            </li>
                                        </ul>
                                    </li>
                                    <li>
                                        <div>REUNION</div>
                                        <ul>
                                            <li>
                                                <div class="pulse-two">
                                                    <a href="http://www.edena.re" target="_blank">
                                                        <b>EDENA SA</b>
                                                    </a>
                                                </div>
                                                <ul>
                                                    <li class="cascade">
                                                        <div><b>Local activities</b></div>
                                                        <ul>
                                                            <li>
                                                                <div>Bottling plant for spring water</div>
                                                            </li>
                                                            <li>
                                                                <div>Carbonated soft drinks plant</div>
                                                            </li>
                                                            <li>
                                                                <div>Imports</div>
                                                            </li>
                                                        </ul>
                                                    </li>
                                                    <li>
                                                        <div><b>Other activities</b></div>
                                                        <ul>
                                                            <li>
                                                                <div>Exports</div>
                                                            </li>
                                                        </ul>
                                                    </li>
                                                </ul>
                                            </li>
                                            <li>
                                                <div>PHOENIX REUNION SARL</div>
                                                <ul>
                                                    <li>
                                                        <div>Sales & Distribution</div>
                                                    </li>
                                                </ul>
                                            </li>
                                        </ul>
                                    </li>
                                    <li>
                                        <div>SEYCHELLES</div>
                                        <ul>
                                            <li>
                                                <div class="pulse-two">
                                                    <a href="https://www.seybrew.com/" target="_blank">
                                                        <b>SEYBREW</b>
                                                    </a>
                                                </div>
                                                <ul>
                                                    <li>
                                                        <div><b>Local activities</b></div>
                                                        <ul>
                                                            <li>
                                                                <div>Brewery and Carbonated soft drink plant</div>
                                                            </li>
                                                        </ul>
                                                        <ul>
                                                            <li>
                                                                <div>Imports </div>
                                                            </li>
                                                        </ul>

                                                    </li>
                                                </ul>
                                            </li>
                                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div data-aos="fade-up" data-aos-duration="500" data-aos-easing="linear">
            <p>Phoenix Beverages Limited holds a 34.66% shareholding in African Original - Kenya.</p>
        </div>

    </div>

    <div class="operation-parent-container">
        <div class="p-6 operation-container">
            <div class="row">
                <div class="col-md-8"></div>
                <div class="col-md-4">
                    <div class="accordion pbg-accordion" id="accordionPanelsStayOpenExample" style="margin-top:120px;">
                        <div class="accordion-item white-accordion">
                            <h2 class="accordion-header" id="panelsStayOpen-headingTwenty">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#panelsStayOpen-collapseTwenty" aria-expanded="true"
                                    aria-controls="panelsStayOpen-collapseTwenty">
                                    Phoenix Beverages (PhoenixBev)
                                </button>
                            </h2>
                            <div id="panelsStayOpen-collapseTwenty" class="accordion-collapse collapse show"
                                aria-labelledby="panelsStayOpen-headingTwenty"
                                data-bs-parent="#accordionPanelsStayOpenExample">
                                <div class="accordion-body">
                                    <p style="text-align: justify"> Phoenix Beverages Limited also known as PhoenixBev is the leading beverage producer, bottler,
                                        and distributor in Mauritius (including Rodrigues) with a heritage of excellence rooted in decades of industry leadership.
                                        It is a public limited company listed on the Stock Exchange of Mauritius. Our story began in 1953 with the signing
                                        of a bottling agreement with The Coca-Cola Company, marking the start of a journey defined by resilience, adaptability,
                                        and innovation.
                                    </p>
                                    <a href="<?php echo e(route('phoenix-bev')); ?>" class="fw-bold text-dark"
                                        style="font-size: 12px;">Explore</a>
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item white-accordion">
                            <h2 class="accordion-header" id="panelsStayOpen-headingEdena">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#panelsStayOpen-collapseEdena" aria-expanded="false"
                                    aria-controls="panelsStayOpen-collapseEdena">
                                    Edena SA (Edena Boissons)
                                </button>
                            </h2>
                            <div id="panelsStayOpen-collapseEdena" class="accordion-collapse collapse"
                                aria-labelledby="panelsStayOpen-headingEdena"
                                data-bs-parent="#accordionPanelsStayOpenExample">
                                <div class="accordion-body">
                                    <p style="text-align: justify">
                                        Founded in 1972 and based in La Possession, Réunion Island, Edena SA is a well-established player in the island’s beverage industry,
                                        known for its high-quality still and sparkling waters. In 2016, Edena was acquired by Phoenix Beverages Group, marking its first strategic
                                        expansion of the Group’s footprint in the Indian Ocean region.
                                    </p>
                                    <a href="<?php echo e(route('edena')); ?>" class="fw-bold text-dark" style="font-size: 12px;">Explore</a>
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item white-accordion">
                            <h2 class="accordion-header" id="panelsStayOpen-headingSeyBrew">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#panelsStayOpen-collapseSeyBrew" aria-expanded="false"
                                    aria-controls="panelsStayOpen-collapseSeyBrew">
                                    Seychelles Breweries (SeyBrew)
                                </button>
                            </h2>
                            <div id="panelsStayOpen-collapseSeyBrew" class="accordion-collapse collapse"
                                aria-labelledby="panelsStayOpen-headingSeyBrew"
                                data-bs-parent="#accordionPanelsStayOpenExample">
                                <div class="accordion-body">
                                    <p style="text-align: justify">
                                        Seychelles Breweries Limited, known locally as <i>SeyBrew</i>, is a trusted and iconic name in the Seychellois beverage industry. Established in 1972
                                        and employing a dedicated team of 160 professionals, the company has built a proud legacy of brewing award-winning beer, bottling high-quality soft drinks,
                                        and distributing a world-class portfolio of premium spirits.
                                    </p>
                                    <a href="<?php echo e(route('seybrew')); ?>" class="fw-bold text-dark" style="font-size: 12px;">Explore</a>
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item white-accordion">
                            <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false"
                                    aria-controls="panelsStayOpen-collapseTwo">
                                    African Originals
                                </button>
                            </h2>
                            <div id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse"
                                aria-labelledby="panelsStayOpen-headingTwo"
                                data-bs-parent="#accordionPanelsStayOpenExample">
                                <div class="accordion-body">
                                    <p style="text-align: justify">
                                        Established in 2018 in Nairobi, African Originals began with the launch of Kenyan Originals, a brand founded on the ambition to bring the authentic taste of Africa to the world.
                                        Combining traditional African ingredients with modern craft techniques, the company has developed a distinctive portfolio of ciders, tonics, and spirits that celebrate heritage,
                                        innovation, and sustainability.
                                    </p>
                                    <a href="https://africanoriginals.com/ " target="_blank" class="fw-bold text-dark" style="font-size: 12px;">Explore</a>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var accordion = document.getElementById('accordionPanelsStayOpenExample');
        var operationContainer = document.querySelector('.operation-container');

        // Function to update background
        function updateBackground(accordionId) {
            // Remove all background classes first
            operationContainer.classList.remove('bg-phoenix', 'bg-grand-baie', 'bg-riviere-noire', 'bg-SeyBrew');

            // Add appropriate background based on accordion
            switch(accordionId) {
                case 'panelsStayOpen-collapseTwenty':
                    operationContainer.classList.add('bg-phoenix');
                    break;
                case 'panelsStayOpen-collapseTwo':
                    operationContainer.classList.add('bg-grand-baie');
                    break;
                case 'panelsStayOpen-collapseEdena':
                    operationContainer.classList.add('bg-riviere-noire');
                    break;
                case 'panelsStayOpen-collapseSeyBrew':
                    operationContainer.classList.add('bg-SeyBrew');
                    break;
            }
        }

        // Listen for button clicks instead of collapse events for more reliable handling
        const accordionButtons = accordion.querySelectorAll('.accordion-button');
        accordionButtons.forEach(function(button) {
            button.addEventListener('click', function() {
                // Get the target accordion from the button's data-bs-target
                const targetId = this.getAttribute('data-bs-target');
                const targetAccordion = document.querySelector(targetId);

                // Check if this accordion is currently open
                const isCurrentlyOpen = targetAccordion.classList.contains('show');

                if (isCurrentlyOpen) {
                    // Accordion is being closed
                    setTimeout(function() {
                        const openAccordion = document.querySelector('.accordion-collapse.show');
                        if (openAccordion) {
                            updateBackground(openAccordion.id);
                        } else {
                            // No accordion is open, reset background
                            operationContainer.classList.remove('bg-phoenix', 'bg-grand-baie', 'bg-riviere-noire', 'bg-SeyBrew');
                        }
                    }, 100);
                } else {
                    // Accordion is being opened
                    updateBackground(targetId.substring(1)); // Remove the # from the ID
                }
            });
        });

        // Initialize background for the first open accordion
        const firstOpenAccordion = document.querySelector('.accordion-collapse.show');
        if (firstOpenAccordion) {
            updateBackground(firstOpenAccordion.id);
        }


    });
</script>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views//operation-structure.blade.php ENDPATH**/ ?>