<style>
    .pbg-accordion .accordion-item {
        background-color: white !important;
    }

    .pbg-accordion .accordion-button {
        background-color: white !important;
        font-size: 16px !important;
        color: black !important;
        font-weight: bold;
        box-shadow: none;
    }

    .accordion-button {
        padding: 0px !important;
    }

    .e-shop-container {
        background: url('images/our-brands/shopping-cart-img.png');
        background-position: center;
        background-repeat: no-repeat;
        background-size: cover;
        position: relative;

    }

    /* .e-shop-container::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.3);
        z-index: 1;
    } */


    .accordion-collapse {
        transition: height 0.3s ease;
        overflow: hidden;
    }

    .accordion-collapse.collapsing {
        height: 0;
    }

    .accordion-body h4,
    .accordion-body p {
        color: black;
    }

    .accordion-body p {
        margin-bottom: 0px;
    }

    .bg-phoenix {
        background-image: url('images/our-brands/phoenix-outlet-moments.png') !important;
    }

    .bg-grand-baie {
        background-image: url('images/our-brands/grand-baie-outlet-moments.png') !important;
    }

    .bg-riviere-noire {
        background-image: url('images/our-brands/riviere-noire-outlet-moments.png') !important;
    }

    .bg-tribeca-mall {
        background-image: url('images/our-brands/tribeca-outlet-moments.png') !important;
    }


    .nav-pills {
        position: relative;
        display: flex;
        justify-content: center;
        align-items: center;
        flex-wrap: wrap;
        margin: 10px;
        font-weight: bold;
        padding: 20px;
        height: auto;
        border-radius: 8px;
        max-width: 100%;
    }

    .nav-pills .nav-link.active {
        background-color: #08BABB !important;
        color: black !important;
        border-radius: 10px;
        font-size: 14px;
    }

    .nav-pills .nav-link {
        border-radius: 10px;
        padding: 12px;
        font-size: 16px;
        margin: 0 5px;
        color: #f8f9fa;
        font-size: 14px;
        transition: color 0.6s ease, background-color 0.6s ease;
        position: relative;
    }


    .nav-pills .nav-link.active::after {
        left: 0;
        width: 100%;
    }

    .nav-pills .nav-link.slide-in-left::after {
        left: 0;
        width: 100%;
    }

    .nav-pills .nav-link.slide-in-right::after {
        left: 100%;
        width: 0;
    }


    .nav-pills .nav-link:hover {
        color: #f8f9fa !important;
    }

    .nav-pills .nav-link.active:hover {
        color: black !important;
    }

    .nav-pills .nav-link:focus {
        box-shadow: none;
    }

    .tab-pane {
        visibility: hidden;
        opacity: 0;
        position: relative;
        width: 100%;
        transition: opacity 0.6s ease-out;
    }

    .tab-pane.fade.show {
        display: block;
        visibility: visible;
        opacity: 1;
        transition: opacity 0.6s ease-out, visibility 0s linear 0.6s;
    }

    .tab-pane.slide-in-left {
        animation: slide-in-left 0.8s cubic-bezier(0.4, 0, 0.2, 1) forwards;
    }

    .tab-pane.slide-in-right {
        animation: slide-in-right 0.8s cubic-bezier(0.4, 0, 0.2, 1) forwards;
    }

    .tab-pane.fade-out {
        animation: fade-out 0.5s ease forwards;
    }

    @keyframes slide-in-left {
        from {
            transform: translateX(-100%);
            opacity: 0;
        }

        to {
            transform: translateX(0);
            opacity: 1;
        }
    }

    @keyframes slide-in-right {
        from {
            transform: translateX(100%);
            opacity: 0;
        }

        to {
            transform: translateX(0);
            opacity: 1;
        }
    }

    @keyframes fade-out {
        from {
            opacity: 1;
        }

        to {
            opacity: 0;
        }
    }


    .col-lg-4 {
        /* flex: 0 0 auto; */
        width: 33.33%;
        !important;
    }

    body.modal-open {
    overflow:hidden;
    position:fixed;
    pointer-events: none;
}

    .modal {
        display: flex;
        align-items: center;
        justify-content: center;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(7, 22, 32, 0.9);
    }

    .modal-content {
    pointer-events: auto;
    background-color: #ced4da !important;
    padding: 40px;
    border-radius: 8px;
    width: 90%;
    max-width: 400px;
    text-align: center;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    position: relative;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
}

    .modal h2 {
        margin-bottom: 20px;
        color: #071620;
        font-weight: bold;
        text-align: center;
        font-size:18px;
    }

    .modal p {
        text-align: center;
        margin-bottom: 25px;
        color: #666;
        font-size:14px;
    }

    .modal-buttons {
        display: flex;
        justify-content: center;
        gap: 20px;
    }

    .modal-buttons button {
        padding: 8px 30px;
        border: none;
        border-radius: 7px;
        cursor: pointer;
        font-weight: bold;
        min-width: 100px;
        font-size:14px;
    }

    #yesBtn {
        background-color: #08BABB;
        color: #071620;
    }

    #yesBtn:hover {
        color: #08BABB;
        background-color: #071620;
    }

    #noBtn {
        background-color: white;
        color: #08BABB;
        border: 1px solid #08BABB;
    }

    #noBtn:hover {
        color: #071620;
        border: 1px solid #071620;
    }

    .modal-buttons button:hover {
        opacity: 0.9;
        transform: scale(1.05);
        transition: all 0.2s ease;
    }



    @media (max-width: 767px) {
    .nav-pills .nav-link {
        font-size: 14px; /* Smaller font for mobile */
        padding: 10px 12px; /* Adjust padding for smaller screens */
    }
}

@media (max-width: 480px) {
    .nav-pills {
        flex-direction: column; /* Stack items vertically on very small screens */
        height: auto; /* Allow it to grow as needed */
    }
}


/* Enhanced accordion CSS */
.accordion-collapse {
    transition: all 0.3s ease-out;
    overflow: hidden;
    display: none;
}

.accordion-collapse.collapse {
    display: none;
}

.accordion-collapse.collapse.show {
    display: block;
}

/* Ensure all accordion panels start hidden */
.accordion-collapse:not(.show) {
    display: none !important;
}

.accordion-body {
    opacity: 1;
    transition: opacity 0.3s ease-out;
}

/* Background transition for e-shop container */
.e-shop-container {
    transition: background-image 0.5s ease-in-out;
    background-position: center;
    background-repeat: no-repeat;
    background-size: cover;
}

/* Ensure background images are properly loaded */
/* .bg-phoenix {
    background-image: url('images/our-brands/image-10.png') !important;
}

.bg-grand-baie {
    background-image: url('images/our-brands/image-12.png') !important;
}

.bg-riviere-noire {
    background-image: url('images/our-brands/image-11.png') !important;
}

.bg-tribeca-mall {
    background-image: url('images/our-brands/image-13.png') !important;
} */


</style>
<?php $__env->startSection('content'); ?>

    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url(<?php echo e(asset('images/our-brands/brands-cover-2.png')); ?>);">
        </div>
        <div class="page-title-container">
            <h4>OUR BRANDS</h4>
            <span class="text-primary">Explore them</span>
        </div>
    </div>

    <div class="container landing-section">
        <div class="center">
            <h3 data-aos="fade-up" data-aos-delay="100">The Building Blocks of Phoenix <br>Beverages Group</h3>
            <p data-aos="fade-up" data-aos-delay="100">Phoenix Beverages Group crafts exceptional products using high-quality natural ingredients.
                The resourcefulness and adaptability of our team have elevated some of these products to become beloved
                local favourites,
                cherished by both Mauritians and visitors. </br>Explore our diverse range of locally produced and
                international brands.
            </p>
        </div>
    </div>

    <div class="pt-6" style="background-color: #071620">

        <div class="brand-table" data-aos="fade-up" data-aos-delay="100">
            <ul class="nav nav-pills mb-3 page-blue mx-auto" id="pills-tab" role="tablist" style="width:80%">
                <li class="nav-item" role="presentation">
                    <a class="nav-link active" id="pills-beers-tab" data-bs-toggle="pill" href="#beers" role="tab"
                        aria-controls="beers" aria-selected="true">Beer</a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="pills-soft-drinks-tab" data-bs-toggle="pill" href="#soft-drinks" role="tab"
                        aria-controls="soft-drinks" aria-selected="false">Carbonated Soft Drinks</a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="pills-water-tab" data-bs-toggle="pill" href="#water" role="tab"
                        aria-controls="water" aria-selected="false">Water & Stills</a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="pills-energy-drinks-tab" data-bs-toggle="pill" href="#energy-drinks"
                        role="tab" aria-controls="energy-drinks" aria-selected="false">Energy Drinks</a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="pills-wines-tab" data-bs-toggle="pill" href="#wines" role="tab"
                        aria-controls="wines" aria-selected="false">Wines & Spirits</a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="pills-spirits-tab" data-bs-toggle="pill" href="#spirits" role="tab"
                        aria-controls="spirits" aria-selected="false">Spirits Cooler</a>
                </li>
            </ul>

            <!-- Content Sections (Bootstrap tab content) -->
            <div class="tab-content" id="pills-tabContent">
                <div class="tab-pane fade show active" id="beers" role="tabpanel" aria-labelledby="pills-beers-tab">
                    <div class="mt-5">
                        <div class="row mx-auto w-75">
                            <?php $__currentLoopData = $beerProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brandProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4 col-md-6 col-sm-3 mb-3">
                                    <div class="our-brand-card">
                                        <img src="<?php echo e($brandProduct['image']); ?>" alt="<?php echo e($brandProduct['name']); ?>" />
                                        <div class="card-overlay">
                                            <div class="hamburger-menu animate__animated">
                                                <div class="menu-icon">&#9776;</div>
                                            </div>
                                            <div class="menu-content animate__animated">
                                                <p class="our-brand-header"><?php echo e($brandProduct['name']); ?></p>
                                                <br>
                                                <span class="fa fa-star"></span> <span
                                                    class="details"><?php echo e($brandProduct['rating']); ?></span>
                                            </div>
                                        </div>
                                        <div class="card-details">
                                            <div class="our-brand-header">
                                                <div class="brand-logo">
                                                    <img src="<?php echo e($brandProduct['image']); ?>"
                                                        alt="<?php echo e($brandProduct['name']); ?>" />
                                                </div>
                                                <div class="close-details">&#8592;</div>
                                            </div>

                                            <div class="details-content">
                                                <h5><?php echo e($brandProduct['name']); ?></h5>
                                                <p><span class="fa fa-star"></span><?php echo e($brandProduct['rating']); ?></p>
                                                <p class="desc"><?php echo e($brandProduct['description']); ?></p>
                                                <div class="read-more-link">
                                                    <a href="https://shop.phoenixbev.mu/product-category/craft-beer/">Read
                                                        More <i class='fas fa-arrow-right'></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="row mx-auto w-75 pb-6 pt-2">
                        <div class="col-lg-12 col-md-12">
                            <div class="video-container">
                                <video autoplay muted playsinline loop>
                                    <source src="<?php echo e(asset('videos/Dont-Drink-and-Drive-2024.mp4')); ?>" type="video/mp4">
                                    Your browser does not support the video tag.
                                </video>
                                <div class="video-container-overlay">
                                    <h3>Enjoy Responsibly</h3>
                                    <p>When you drive you should never drink.
                                        <br/>
                                        <a class="text-primary" href="<?php echo e(route('general-campaign')); ?>">Explore our campaign</a>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade" id="soft-drinks" role="tabpanel" aria-labelledby="pills-soft-drinks-tab">
                    <div class="mt-5">
                        <div class="row mx-auto w-75">
                            <?php $__currentLoopData = $carbonatedSoftDrinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brandProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4 col-md-6 col-sm-3 mb-3">
                                    <div class="our-brand-card">
                                        <img src="<?php echo e($brandProduct['image']); ?>" alt="<?php echo e($brandProduct['name']); ?>" />
                                        <div class="card-overlay">
                                            <div class="hamburger-menu animate__animated">
                                                <div class="menu-icon">&#9776;</div>
                                            </div>
                                            <div class="menu-content animate__animated">
                                                <p class="our-brand-header"><?php echo e($brandProduct['name']); ?></p>
                                                <br>
                                                <span class="fa fa-star"></span> <span
                                                    class="details"><?php echo e($brandProduct['rating']); ?></span>
                                            </div>
                                        </div>
                                        <div class="card-details">
                                            <div class="our-brand-header">
                                                <div class="brand-logo">
                                                    <img src="<?php echo e($brandProduct['image']); ?>"
                                                        alt="<?php echo e($brandProduct['name']); ?>" />
                                                </div>
                                                <div class="close-details">&#8592;</div>
                                            </div>

                                            <div class="details-content">
                                                <h5><?php echo e($brandProduct['name']); ?></h5>
                                                <p><span class="fa fa-star"></span><?php echo e($brandProduct['rating']); ?></p>
                                                <p class="desc"><?php echo e($brandProduct['description']); ?></p>
                                                <div class="read-more-link">
                                                    <a href="https://shop.phoenixbev.mu/product-category/craft-beer/">Read
                                                        More <i class='fas fa-arrow-right'></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="row mx-auto w-75 pb-6 pt-2" data-aos="fade-up" data-aos-delay="100">
                        <div class="col-lg-12 col-md-12">
                            <div class="video-container">
                                <video autoplay muted playsinline loop>
                                    <source src="<?php echo e(asset('videos/exercise_campaign_pbg.mp4')); ?>" type="video/mp4">
                                    Your browser does not support the video tag.
                                </video>
                                <div class="video-container-overlay">
                                    <h3>Enjoy Responsively</h3>
                                    <p>Sipping a cool drink during exercise refreshes and rehydrates you for a more effective workout.
                                        <br>
                                        <a class="text-primary" href="<?php echo e(route('general-campaign')); ?>">Explore our campaign</a>
                                    </p>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="water" role="tabpanel" aria-labelledby="pills-water-tab">
                    <div class="mt-5">
                        <div class="row mx-auto w-75">
                            <?php $__currentLoopData = $waterAndStills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brandProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4 col-md-6 mb-3">
                                    <div class="our-brand-card">
                                        <img src="<?php echo e($brandProduct['image']); ?>" alt="<?php echo e($brandProduct['name']); ?>" />
                                        <div class="card-overlay">
                                            <div class="hamburger-menu animate__animated">
                                                <div class="menu-icon">&#9776;</div>
                                            </div>
                                            <div class="menu-content animate__animated">
                                                <p class="our-brand-header"><?php echo e($brandProduct['name']); ?></p>
                                                <br>
                                                <span class="fa fa-star"></span> <span
                                                    class="details"><?php echo e($brandProduct['rating']); ?></span>
                                            </div>
                                        </div>
                                        <div class="card-details">
                                            <div class="our-brand-header">
                                                <div class="brand-logo">
                                                    <img src="<?php echo e($brandProduct['image']); ?>"
                                                        alt="<?php echo e($brandProduct['name']); ?>" />
                                                </div>
                                                <div class="close-details">&#8592;</div>
                                            </div>

                                            <div class="details-content">
                                                <h5><?php echo e($brandProduct['name']); ?></h5>
                                                <p><span class="fa fa-star"></span><?php echo e($brandProduct['rating']); ?></p>
                                                <p class="desc"><?php echo e($brandProduct['description']); ?></p>
                                                <div class="read-more-link">
                                                    <a href="https://shop.phoenixbev.mu/product-category/craft-beer/">Read
                                                        More <i class='fas fa-arrow-right'></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="row mx-auto w-75 pb-6 pt-2" data-aos="fade-up" data-aos-delay="100">
                        <div class="col-lg-12 col-md-12">
                            <div class="video-container">
                                <video autoplay muted playsinline loop>
                                    <source src="<?php echo e(asset('videos/exercise_campaign_water_pbg.mp4')); ?>" type="video/mp4">
                                    Your browser does not support the video tag.
                                </video>
                                <div class="video-container-overlay">
                                    <h3>Enjoy Responsively</h3>
                                    <p>Sipping a cool drink during exercise refreshes and rehydrates you for a more effective workout.
                                        <br>
                                        <a class="text-primary" href="<?php echo e(route('general-campaign')); ?>">Explore our campaign</a>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade" id="energy-drinks" role="tabpanel" aria-labelledby="pills-energy-drinks-tab">
                    <div class="mt-5">
                        <div class="row mx-auto w-75">
                            <?php $__currentLoopData = $energyDrinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brandProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4 col-md-6 mb-3">
                                    <div class="our-brand-card">
                                        <img src="<?php echo e($brandProduct['image']); ?>" alt="<?php echo e($brandProduct['name']); ?>" />
                                        <div class="card-overlay">
                                            <div class="hamburger-menu animate__animated">
                                                <div class="menu-icon">&#9776;</div>
                                            </div>
                                            <div class="menu-content animate__animated">
                                                <p class="our-brand-header"><?php echo e($brandProduct['name']); ?></p>
                                                <br>
                                                <span class="fa fa-star"></span> <span
                                                    class="details"><?php echo e($brandProduct['rating']); ?></span>
                                            </div>
                                        </div>
                                        <div class="card-details">
                                            <div class="our-brand-header">
                                                <div class="brand-logo">
                                                    <img src="<?php echo e($brandProduct['image']); ?>"
                                                        alt="<?php echo e($brandProduct['name']); ?>" />
                                                </div>
                                                <div class="close-details">&#8592;</div>
                                            </div>

                                            <div class="details-content">
                                                <h5><?php echo e($brandProduct['name']); ?></h5>
                                                <p><span class="fa fa-star"></span><?php echo e($brandProduct['rating']); ?></p>
                                                <p class="desc"><?php echo e($brandProduct['description']); ?></p>
                                                <div class="read-more-link">
                                                    <a href="https://shop.phoenixbev.mu/product-category/craft-beer/">Read
                                                        More <i class='fas fa-arrow-right'></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="row mx-auto w-75 pb-6 pt-2">
                            <div class="col-lg-12 col-md-12">
                                <div class="video-container">
                                    <video autoplay muted playsinline loop>
                                        <source src="<?php echo e(asset('videos/exercise_campaign_pbg.mp4')); ?>" type="video/mp4">
                                        Your browser does not support the video tag.
                                    </video>
                                    <div class="video-container-overlay">
                                        <h3>Enjoy Responsively</h3>
                                        <p>Sipping a cool drink during exercise refreshes and rehydrates you for a more effective workout.
                                            <br/>
                                            <a class="text-primary" href="<?php echo e(route('general-campaign')); ?>">Explore our campaign</a>
                                        </p>
                                    </div>
                                </div>
                            </div>
                    </div>

                </div>

                <div class="tab-pane fade" id="wines" role="tabpanel" aria-labelledby="pills-wines-tab">
                    <div class="mt-5">
                        <div class="row mx-auto w-75">
                            <?php $__currentLoopData = $wineAndSpirits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brandProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4 col-md-6 mb-3">
                                    <div class="our-brand-card">
                                        <img src="<?php echo e($brandProduct['image']); ?>" alt="<?php echo e($brandProduct['name']); ?>" />
                                        <div class="card-overlay">
                                            <div class="hamburger-menu animate__animated">
                                                <div class="menu-icon">&#9776;</div>
                                            </div>
                                            <div class="menu-content animate__animated">
                                                <p class="our-brand-header"><?php echo e($brandProduct['name']); ?></p>
                                                <br>
                                                <span class="fa fa-star"></span> <span
                                                    class="details"><?php echo e($brandProduct['rating']); ?></span>
                                            </div>
                                        </div>
                                        <div class="card-details">
                                            <div class="our-brand-header">
                                                <div class="brand-logo">
                                                    <img src="<?php echo e($brandProduct['image']); ?>"
                                                        alt="<?php echo e($brandProduct['name']); ?>" />
                                                </div>
                                                <div class="close-details">&#8592;</div>
                                            </div>

                                            <div class="details-content">
                                                <h5><?php echo e($brandProduct['name']); ?></h5>
                                                <p><span class="fa fa-star"></span><?php echo e($brandProduct['rating']); ?></p>
                                                <p class="desc"><?php echo e($brandProduct['description']); ?></p>
                                                <div class="read-more-link">
                                                    <a href="https://shop.phoenixbev.mu/product-category/craft-beer/">Read
                                                        More <i class='fas fa-arrow-right'></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="row mx-auto w-75 pb-6 pt-2">
                        <div class="col-lg-12 col-md-12">
                            <div class="video-container">
                                <video autoplay muted playsinline loop>
                                    <source src="<?php echo e(asset('videos/Dont-Drink-and-Drive-2024.mp4')); ?>" type="video/mp4">
                                    Your browser does not support the video tag.
                                </video>
                                <div class="video-container-overlay">
                                    <h3>Enjoy Responsively</h3>
                                    <p>When you drive you should never drink.
                                        <br/>
                                        <a class="text-primary" href="<?php echo e(route('general-campaign')); ?>">Explore our campaign</a>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane fade" id="spirits" role="tabpanel" aria-labelledby="pills-spirits-tab">
                    <div class="mt-5">
                        <div class="row mx-auto w-75">
                            <?php $__currentLoopData = $spiritCoolers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brandProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4 col-md-6 mb-3">
                                    <div class="our-brand-card">
                                        <img src="<?php echo e($brandProduct['image']); ?>" alt="<?php echo e($brandProduct['name']); ?>" />
                                        <div class="card-overlay">
                                            <div class="hamburger-menu animate__animated">
                                                <div class="menu-icon">&#9776;</div>
                                            </div>
                                            <div class="menu-content animate__animated">
                                                <p class="our-brand-header"><?php echo e($brandProduct['name']); ?></p>
                                                <br>
                                                <span class="fa fa-star"></span> <span
                                                    class="details"><?php echo e($brandProduct['rating']); ?></span>
                                            </div>
                                        </div>
                                        <div class="card-details">
                                            <div class="our-brand-header">
                                                <div class="brand-logo">
                                                    <img src="<?php echo e($brandProduct['image']); ?>"
                                                        alt="<?php echo e($brandProduct['name']); ?>" />
                                                </div>
                                                <div class="close-details">&#8592;</div>
                                            </div>

                                            <div class="details-content">
                                                <h5><?php echo e($brandProduct['name']); ?></h5>
                                                <p><span class="fa fa-star"></span><?php echo e($brandProduct['rating']); ?></p>
                                                <p class="desc"><?php echo e($brandProduct['description']); ?></p>
                                                <div class="read-more-link">
                                                    <a href="https://shop.phoenixbev.mu/product-category/craft-beer/">Read
                                                        More <i class='fas fa-arrow-right'></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="row mx-auto w-75 pb-6 pt-2" data-aos="fade-up" data-aos-delay="100">
                        <div class="col-lg-12 col-md-12">
                            <div class="video-container">
                                <video autoplay muted playsinline loop>
                                    <source src="<?php echo e(asset('videos/Dont-Drink-and-Drive-2024.mp4')); ?>" type="video/mp4">
                                    Your browser does not support the video tag.
                                </video>
                                <div class="video-container-overlay">
                                    <h3>Enjoy Responsively</h3>
                                    <p>When you drive you should never drink.
                                        <br/>
                                        <a class="text-primary" href="<?php echo e(route('general-campaign')); ?>">Explore our campaign</a>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>



    <div class="py-4" data-aos="fade-up" data-aos-delay="100">
        <a href="https://www.yesnosolutions.org/pet-plastic-drop-off/" target="_blank">
        <img src="<?php echo e(asset('images/track-your-recyclables.png')); ?>" alt="recycle image" />
        </a>
    </div>

    <div class="container-fluid py-6 px-6 e-shop-container">
        <div class="row">
            <div class="col-md-8"></div>
            <div class="col-md-4">
                <div class="card mb-4">
                    <div class="card-body">
                        <h5 class="text-dark">e-Shop</h5>
                        <p class="e-shop" style="text-align: justify">
                            The PhoenixBev Online E-Shop offers a convenient and seamless way to explore and purchase your
                            favourite beverages from the comfort of your home.
                            Whether you're stocking up for a family gathering, planning a celebration, or simply
                            replenishing your everyday drinks, our e-shop
                            provides a wide range of products to suit every occasion.
                        </p>
                        <div class="learnMore px-3 m-3 float-end text-smaller" >
                            <a class="text-primary" href="https://shop.phoenixbev.mu/"	target="_blank">
                                Visit e-Shop  <span class="fa fa-arrow-right get-direction"></span>
                            </a>
                        </div>

                    </div>
                </div>

                <div class="accordion pbg-accordion" id="accordionPanelsStayOpenBrand">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="panelsStayOpen-headingHundred">
                            <button class="accordion-button collapsed" type="button"
                                data-target="#panelsStayOpen-collapseHundred" aria-expanded="false"
                                aria-controls="panelsStayOpen-collapseHundred">
                                Phoenix Outlet - MOMENTS by PhoenixBev
                            </button>
                        </h2>
                        <div id="panelsStayOpen-collapseHundred" class="accordion-collapse collapse"
                            aria-labelledby="panelsStayOpen-headingHundred">
                            <div class="accordion-body">
                                <p class="e-shop" style="text-align: justify">Experience the convenience of online shopping with MOMENTS by PhoenixBev outlet and let us
                                    bring your favourite drinks to you. Cheers to hassle-free hydration and celebration!
                                    </br>Visit our online B2C platform (e-shop)
                                    <img src="<?php echo e(asset('images/our-brands/icons/cart.png')); ?>" alt="Icon"
                                        height="20" width="20" />
                                </p>
                                <div class="learnMore px-3 m-3 float-end text-smaller" >
                                    <a class="text-primary" href="https://www.google.com/maps/place/PhoenixBev+Wines+%26+Spirits+-+Pont+Fer,+Phoenix/@-20.2732643,57.4954314,17z/data=!3m1!4b1!4m5!3m4!1s0x217c5bf28b9d88cd:0x644ace022d335576!8m2!3d-20.2732684!4d57.4976118"
										target="_blank">
                                        Get Direction
                                        <span class="fa fa-arrow-right get-direction"></span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="panelsStayOpen-headingBrandTwo">
                            <button class="accordion-button collapsed" type="button"
                                data-target="#panelsStayOpen-collapseBrandTwo" aria-expanded="false"
                                aria-controls="panelsStayOpen-collapseBrandTwo">
                                Grand Baie Outlet - MOMENTS by PhoenixBev
                            </button>
                        </h2>
                        <div id="panelsStayOpen-collapseBrandTwo" class="accordion-collapse collapse"
                            aria-labelledby="panelsStayOpen-headingBrandTwo">
                            <div class="accordion-body">
                                <p class="e-shop" style="text-align: justify">Experience the convenience of online shopping with MOMENTS by PhoenixBev outlet and let us
                                    bring your favourite drinks to you. Cheers to hassle-free hydration and celebration!
                                    </br>Visit our online B2C platform (e-shop)
                                    <img src="<?php echo e(asset('images/our-brands/icons/cart.png')); ?>" alt="Icon"
                                        height="20" width="20" />
                                </p>
                                <div class="learnMore px-3 m-3 float-end text-smaller" >
                                    <a class="text-primary" href="https://www.google.com/maps/place/PhoenixBev+Wines+%26+Spirits+-+Grand+Baie/@-20.0165927,57.5854541,17z/data=!3m1!4b1!4m5!3m4!1s0x217dab854d745985:0x673d30d3c818c477!8m2!3d-20.0165927!4d57.5876428"
										target="_blank">
                                        Get Direction
                                        <span class="fa fa-arrow-right get-direction"></span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="panelsStayOpen-headingBrandThree">
                            <button class="accordion-button collapsed" type="button"
                                data-target="#panelsStayOpen-collapseBrandThree" aria-expanded="false"
                                aria-controls="panelsStayOpen-collapseBrandThree">
                                Tamarin Outlet - MOMENTS by PhoenixBev
                            </button>
                        </h2>
                        <div id="panelsStayOpen-collapseBrandThree" class="accordion-collapse collapse"
                            aria-labelledby="panelsStayOpen-headingBrandThree">
                            <div class="accordion-body">
                                <p class="e-shop" style="text-align: justify">Experience the convenience of online shopping with MOMENTS by PhoenixBev outlet and let us
                                    bring your favourite drinks to you. Cheers to hassle-free hydration and celebration!
                                    </br>Visit our online B2C platform (e-shop)
                                    <img src="<?php echo e(asset('images/our-brands/icons/cart.png')); ?>" alt="Icon"
                                        height="20" width="20" />
                                </p>
                                <div class="learnMore px-3 m-3 float-end text-smaller" >
                                    <a class="text-primary" href="https://www.google.com/maps/place/20%C2%B019'40.7%22S+57%C2%B023'00.0%22E/@-20.3279636,57.3807652,17z/data=!3m1!4b1!4m4!3m3!8m2!3d-20.3279636!4d57.3833401?entry=ttu&g_ep=EgoyMDI1MDQyMy4wIKXMDSoASAFQAw%3D%3D"
										target="_blank">
                                        Get Direction
                                        <span class="fa fa-arrow-right get-direction"></span>
                                    </a>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="panelsStayOpen-headingBrandFour">
                            <button class="accordion-button collapsed" type="button"
                                data-target="#panelsStayOpen-collapseBrandFour" aria-expanded="false"
                                aria-controls="panelsStayOpen-collapseBrandFour">
                                Tribeca Mall Outlet - MOMENTS by PhoenixBev
                            </button>
                        </h2>
                        <div id="panelsStayOpen-collapseBrandFour" class="accordion-collapse collapse"
                            aria-labelledby="panelsStayOpen-headingBrandFour">
                            <div class="accordion-body">
                                <p class="e-shop" style="text-align: justify">Experience the convenience of online shopping with MOMENTS by PhoenixBev outlet and let us
                                    bring your favourite drinks to you. Cheers to hassle-free hydration and celebration!
                                    </br>Visit our online B2C platform (e-shop)
                                    <img src="<?php echo e(asset('images/our-brands/icons/cart.png')); ?>" alt="Icon"
                                        height="20" width="20" />
                                </p>
                                <div class="learnMore px-3 m-3 float-end text-smaller" >
                                    <a class="text-primary" href="https://maps.app.goo.gl/NmdvnD2zPRoTJFJk6"
										target="_blank">Get Direction

                                        <span class="fa fa-arrow-right get-direction"></span>
                                    </a>

                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="ageVerificationModal" class="modal">
        <div class="modal-content">
            <h2>You are welcome!</h2>
            <p>Please confirm you are over 18 to continue</p>
            <div class="modal-buttons">
                <button id="yesBtn">Yes</button>
                <button id="noBtn">No</button>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>
<script>
    // document.addEventListener('DOMContentLoaded', function() {
    //     var accordion = document.getElementById('accordionPanelsStayOpenBrand');

    //     accordion.addEventListener('shown.bs.collapse', function(event) {
    //         var target = event.target;
    //         console.log(target.id);
    //         if (target.id === 'panelsStayOpen-collapseBrandHundred') {
    //             document.querySelector('.e-shop-container').classList.add('bg-phoenix');
    //             document.querySelector('.e-shop-container').classList.remove('bg-grand-baie',
    //                 'bg-riviere-noire', 'bg-tribeca-mall');
    //         } else if (target.id === 'panelsStayOpen-collapseBrandTwo') {
    //             document.querySelector('.e-shop-container').classList.add('bg-grand-baie');
    //             document.querySelector('.e-shop-container').classList.remove('bg-phoenix',
    //                 'bg-riviere-noire', 'bg-tribeca-mall');
    //         } else if (target.id === 'panelsStayOpen-collapseBrandThree') {
    //             document.querySelector('.e-shop-container').classList.add('bg-riviere-noire');
    //             document.querySelector('.e-shop-container').classList.remove('bg-phoenix',
    //                 'bg-grand-baie', 'bg-tribeca-mall');
    //         } else if (target.id === 'panelsStayOpen-collapseBrandFour') {
    //             document.querySelector('.e-shop-container').classList.add('bg-tribeca-mall');
    //             document.querySelector('.e-shop-container').classList.remove('bg-phoenix',
    //                 'bg-grand-baie', 'bg-riviere-noire');
    //         }
    //     });


    //     const accordions = document.querySelectorAll('.accordion-button');

    //     // accordions.forEach(button => {
    //     //     button.addEventListener('click', function() {
    //     //         const collapseElement = this.nextElementSibling;

    //     //         if (collapseElement.style.maxHeight) {
    //     //             // Accordion is collapsing
    //     //             collapseElement.style.maxHeight = null;
    //     //         } else {
    //     //             // Accordion is expanding
    //     //             const activeCollapse = document.querySelector('.accordion-collapse.show');
    //     //             if (activeCollapse && activeCollapse !== collapseElement) {
    //     //                 activeCollapse.style.maxHeight = null; // Collapse other panels
    //     //             }
    //     //             collapseElement.style.maxHeight = collapseElement.scrollHeight + 'px';
    //     //         }
    //     //     });
    //     // });
    // });



    document.addEventListener('DOMContentLoaded', function() {
        var accordion = document.getElementById('accordionPanelsStayOpenBrand');
        var eShopContainer = document.querySelector('.e-shop-container');
        var activePanel = null;

        // Initialize accordion functionality
        function initializeAccordion() {
            // Add event listeners to all accordion buttons
            var accordionButtons = accordion.querySelectorAll('.accordion-button');

            accordionButtons.forEach(function(button) {
                button.addEventListener('click', function(e) {
                    e.preventDefault();

                    var targetId = this.getAttribute('data-target');
                    var targetPanel = document.querySelector(targetId);

                    // Close all other panels
                    var allPanels = accordion.querySelectorAll('.accordion-collapse');
                    allPanels.forEach(function(panel) {
                        if (panel !== targetPanel) {
                            panel.classList.remove('show');
                            var button = panel.previousElementSibling.querySelector('.accordion-button');
                            button.classList.add('collapsed');
                            button.setAttribute('aria-expanded', 'false');
                        }
                    });

                    // Toggle current panel
                    if (targetPanel.classList.contains('show')) {
                        // Close panel
                        targetPanel.classList.remove('show');
                        this.classList.add('collapsed');
                        this.setAttribute('aria-expanded', 'false');
                        activePanel = null;

                        // Reset background
                        resetBackground();
                    } else {
                        // Open panel
                        targetPanel.classList.add('show');
                        this.classList.remove('collapsed');
                        this.setAttribute('aria-expanded', 'true');
                        activePanel = targetPanel;

                        // Change background based on panel
                        changeBackground(targetPanel.id);
                    }
                });
            });
        }

        // Function to change background based on active panel
        function changeBackground(panelId) {
            // Remove all background classes first
            eShopContainer.classList.remove('bg-phoenix', 'bg-grand-baie', 'bg-riviere-noire', 'bg-tribeca-mall');

            // Add appropriate background class
            switch(panelId) {
                case 'panelsStayOpen-collapseHundred':
                    eShopContainer.classList.add('bg-phoenix');
                    break;
                case 'panelsStayOpen-collapseBrandTwo':
                    eShopContainer.classList.add('bg-grand-baie');
                    break;
                case 'panelsStayOpen-collapseBrandThree':
                    eShopContainer.classList.add('bg-riviere-noire');
                    break;
                case 'panelsStayOpen-collapseBrandFour':
                    eShopContainer.classList.add('bg-tribeca-mall');
                    break;
            }
        }

        // Function to reset background
        function resetBackground() {
            eShopContainer.classList.remove('bg-phoenix', 'bg-grand-baie', 'bg-riviere-noire', 'bg-tribeca-mall');
        }

        // Initialize the accordion
        initializeAccordion();

        // Ensure all panels start closed
        var allPanels = accordion.querySelectorAll('.accordion-collapse');
        allPanels.forEach(function(panel) {
            panel.classList.remove('show');
            panel.style.display = 'none';
        });

        // Ensure all buttons start collapsed
        var allButtons = accordion.querySelectorAll('.accordion-button');
        allButtons.forEach(function(button) {
            button.classList.add('collapsed');
            button.setAttribute('aria-expanded', 'false');
        });
    });



    document.addEventListener('DOMContentLoaded', function() {
        const tabLinks = document.querySelectorAll('.nav-link');
        let lastTab = null;

        tabLinks.forEach(tab => {
            tab.addEventListener('click', function(e) {
                // Get the current tab and its target content
                const currentTab = e.target;
                const currentTabId = currentTab.getAttribute('href').substring(1);
                const currentTabContent = document.getElementById(currentTabId);

                if (lastTab) {
                    const lastTabIndex = [...tabLinks].indexOf(lastTab);
                    const currentTabIndex = [...tabLinks].indexOf(currentTab);
                    const direction = currentTabIndex > lastTabIndex ? 'right' : 'left';

                    const lastTabContent = document.querySelector(
                        `#${lastTab.getAttribute('href').substring(1)}`);
                    const lastNavLink = lastTab;

                    // Slide the indicator of the previous tab
                    lastNavLink.classList.remove('slide-in-left', 'slide-in-right');
                    lastNavLink.classList.add(direction === 'right' ? 'slide-in-left' :
                        'slide-in-right');

                    // Apply fade-out to the previous tab content
                    lastTabContent.classList.remove('slide-in-left', 'slide-in-right',
                        'fade-out');
                    lastTabContent.classList.add('fade-out');

                    // Transition for the current tab
                    setTimeout(() => {
                        currentTabContent.classList.remove('fade-out');
                        currentTabContent.classList.add(direction === 'right' ?
                            'slide-in-left' : 'slide-in-right');

                        currentTab.classList.remove('slide-in-left', 'slide-in-right');
                        currentTab.classList.add(direction === 'right' ?
                            'slide-in-left' : 'slide-in-right');
                    }, 300);
                }

                // Set the current tab as the last tab
                lastTab = currentTab;
            });
        });
    });


    document.addEventListener('DOMContentLoaded', function() {
        const modal = document.getElementById('ageVerificationModal');
        modal.style.display = "block";

        document.getElementById('yesBtn').addEventListener('click', function() {
            modal.style.display = "none";
        });

        document.getElementById('noBtn').addEventListener('click', function() {
            window.location.href = '/'; // Redirect to home page
        });
    });

</script>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views//our-brand.blade.php ENDPATH**/ ?>