
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<meta http-equiv="x-ua-compatible" content="IE=edge">

<?php
    $seoService = app('App\Services\SeoService');
    
    // Try to load from database first
    // Get route name or use URL path as fallback
    $currentRoute = request()->route() ? request()->route()->getName() : null;
    
    // If no route name, use URL path (without leading slash)
    if (!$currentRoute) {
        $currentRoute = trim(request()->path(), '/') ?: 'home';
    }
    
    $seoService->loadFromDatabase($currentRoute);
    
    // If SEO data is passed from controller, override database values
    if(isset($seo)) {
        $seoService->setTitle($seo['title'] ?? $seoService->getTitle() ?? 'Phoenix Beverages Group (PBG)')
                   ->setDescription($seo['description'] ?? $seoService->getDescription() ?? 'Phoenix Beverages Group is a leading beverage company in Mauritius and the Indian Ocean region, offering a diverse portfolio of alcoholic and non-alcoholic beverages.')
                   ->setKeywords($seo['keywords'] ?? $seoService->getKeywords() ?? 'Phoenix Beverages, PBG, Mauritius, beverages, beer, soft drinks, spirits, wine')
                   ->setImage($seo['image'] ?? $seoService->getImage() ?? asset('images/logo.png'))
                   ->setUrl($seo['url'] ?? $seoService->getUrl() ?? request()->url())
                   ->setType($seo['type'] ?? $seoService->getType() ?? 'website')
                   ->setAuthor($seo['author'] ?? $seoService->getAuthor() ?? 'Phoenix Beverages Group')
                   ->setCanonical($seo['canonical'] ?? $seoService->getCanonical() ?? request()->url());
    } else {
        // Use database values or defaults
        $seoService->setTitle($seoService->getTitle() ?? 'Phoenix Beverages Group (PBG)')
                   ->setDescription($seoService->getDescription() ?? 'Phoenix Beverages Group is a leading beverage company in Mauritius and the Indian Ocean region, offering a diverse portfolio of alcoholic and non-alcoholic beverages.')
                   ->setKeywords($seoService->getKeywords() ?? 'Phoenix Beverages, PBG, Mauritius, beverages, beer, soft drinks, spirits, wine')
                   ->setImage($seoService->getImage() ?? asset('images/logo.png'))
                   ->setUrl($seoService->getUrl() ?? request()->url())
                   ->setType($seoService->getType() ?? 'website')
                   ->setAuthor($seoService->getAuthor() ?? 'Phoenix Beverages Group')
                   ->setCanonical($seoService->getCanonical() ?? request()->url());
    }
?>

<?php echo $seoService->render(); ?>

<?php echo $seoService->generateOrganizationSchema(); ?>

<?php echo $seoService->renderStructuredData(); ?>

<?php echo $seoService->renderHreflang(); ?>

<?php echo $seoService->renderAlternateUrls(); ?>


<!-- Performance & SEO Optimizations -->
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<link rel="dns-prefetch" href="//fonts.googleapis.com">
<link rel="dns-prefetch" href="//fonts.gstatic.com">
<link rel="preload" href="<?php echo e(asset('images/logo.png')); ?>" as="image">

<!-- Font Imports -->
<link rel="icon" href="<?php echo e(asset('favicon.ico')); ?>" type="image/x-icon">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link
    href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Playfair+Display:ital@0;1&display=swap"
    rel="stylesheet">

<!-- Core Style -->
<link rel="stylesheet" href="<?php echo e(URL::asset('layout/style.css')); ?>">
<link rel="stylesheet" href="<?php echo e(URL::asset('layout/custom.css')); ?>">

<link rel="preload" as="image" href="<?php echo e(asset('images/corporate-governance.jpeg')); ?>">
<link rel="preload" as="image" href="<?php echo e(asset('images/homepage/1_holding_companies.jpeg')); ?>">
<link rel="preload" as="image" href="<?php echo e(asset('images/investor-relations/reports/annual-report-2024.png')); ?>">
<link rel="preload" as="image" href="<?php echo e(asset('images/homepage/3_shareholders_corner.jpeg')); ?>">

<!-- Font Icons -->
<link rel="stylesheet" href="<?php echo e(URL::asset('layout/css/font-icons.css')); ?>">

<!-- Custom CSS -->
<link rel="stylesheet" href="<?php echo e(URL::asset('layout/css/custom.css')); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- SLIDER REVOLUTION 5.x CSS SETTINGS -->
<link rel="stylesheet" href="<?php echo e(URL::asset('layout/include/rs-plugin/css/settings.css')); ?>" media="screen">
<link rel="stylesheet" href="<?php echo e(URL::asset('layout/include/rs-plugin/css/layers.css')); ?>">
<link rel="stylesheet" href="<?php echo e(URL::asset('layout/include/rs-plugin/css/navigation.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(URL::asset('layout/include/slick/slick/slick.css')); ?>">
<link rel="stylesheet" href="https://cdn.knightlab.com/libs/timeline3/latest/css/timeline.css">
<link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css" />
<link
rel="stylesheet"
href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"
/>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.10.377/pdf.min.js"></script>
<script src="https://js.hcaptcha.com/1/api.js" async defer></script>


<!-- Document Title
 ============================================= -->

<style>
    .revo-slider-emphasis-text {
        font-size: 58px;
        font-weight: 700;
        letter-spacing: 1px;
        font-family: 'Poppins', sans-serif;
        padding: 15px 20px;
        border-top: 2px solid #FFF;
        border-bottom: 2px solid #FFF;
    }

    .revo-slider-desc-text {
        font-size: 20px;
        font-family: 'Lato', sans-serif;
        width: 650px;
        text-align: center;
        line-height: 1.5;
    }

    .revo-slider-caps-text {
        font-size: 16px;
        font-weight: 400;
        letter-spacing: 3px;
        font-family: 'Poppins', sans-serif;
    }

    .tp-video-play-button {
        display: none !important;
    }

    .tp-caption {
        white-space: nowrap;
    }
</style>
<?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views/includes/head.blade.php ENDPATH**/ ?>