<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta http-equiv="x-ua-compatible" content="IE=edge">
    <meta name="author" content="SemiColonWeb">
    <meta name="description"
        content="Get Canvas to build powerful websites easily with the Highly Customizable &amp; Best Selling Bootstrap Template, today.">

    <!-- Font Imports -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Playfair+Display:ital@0;1&display=swap"
        rel="stylesheet">

    <!-- Core Style -->
    <link rel="stylesheet" href="<?php echo e(URL::asset('layout/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(URL::asset('layout/custom.css')); ?>">

    <!-- Font Icons -->
    <link rel="stylesheet" href="<?php echo e(URL::asset('layout/css/font-icons.css')); ?>">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo e(URL::asset('layout/css/custom.css')); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- SLIDER REVOLUTION 5.x CSS SETTINGS -->
    <link rel="stylesheet" href="<?php echo e(URL::asset('layout/include/rs-plugin/css/settings.css')); ?>" media="screen">
    <link rel="stylesheet" href="<?php echo e(URL::asset('layout/include/rs-plugin/css/layers.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(URL::asset('layout/include/rs-plugin/css/navigation.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(URL::asset('layout/include/slick/slick/slick.css')); ?>">
    <link rel="stylesheet" href="https://cdn.knightlab.com/libs/timeline3/latest/css/timeline.css">
    <link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <!-- Document Title
 ============================================= -->
    <title>Phoenix Beverages Group (PBG)</title>

</head>

<body class="stretched">

    <div id="wrapper">
        <header id="header">
            <div id="header-wrap">
                <div class="container py-3">
                    <div class="header-row">
                        <div id="logo">
                            <a href="<?php echo e(route('home')); ?>">
                                <img class="logo-default" srcset="<?php echo e(URL::asset('images/pbg-logo.png')); ?>"
                                    src="<?php echo e(URL::asset('images/pbg-logo.png')); ?>" alt="PBG Logo">
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </header>
    </div>

    <div class="page-blue ireport">
        <div class="row">
            <div class="col-lg-6 col-md-12">
                <div class="mx-auto justify-content-center align-items-center"
                    style="padding:120px 0px 0px 150px; width:80%;">
                    <h3 class="fw-bold">Integrated Report <br> <?php echo e($year); ?></h3>
                    <p class="smaller-text">This Integrated Report provides information about the strategy, activities
                        and performance of
                        Phoenix Beverages Limited (PhoenixBev or the Group) for the twelve months from 1 July 2023 to 30
                        June <?php echo e($year); ?>.
                        <br></br>
                        It is structured around the matters most material to the Group's ability to create value in the
                        short-,
                        medium- and longterm.
                        The activities of our operations in Mauritius and Réunion Island are included in the reporting
                        boundary..
                    </p>
                    <div class="cta">
                        <a href="<?php echo e(asset('Reports/PhoenixBev/pbl_annual_reports/2024/PBL_IAR_2024_V1.pdf')); ?>"
                                    download="PBL_IAR_2024_V1.pdf" target="_blank">
                        <button class="button pbg-button pbg-shadow-dash">Download Full PDF</button>
                        </a>
                    </div>
                </div>

            </div>
            <div class="col-lg-6 col-md-12">
                <img src="<?php echo e(asset('images/investor-relations/reports/annual-report-2024.png')); ?>" alt="integrated report"
                    class="responsive-image" />
            </div>
        </div>

    </div>


    <div class="ir-section">
        <div class="container w-75 mx-auto">
            <h3 class="py-5" data-aos="fade-down" data-aos-duration="500" data-aos-easing="linear">Financial Performance</h3>
            <div class="row pb-6 text-center">
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="50" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Team Member</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/fluent_people-team-16-regular.png')); ?>" alt="team" />
                                </div>
                                <div class="">
                                    <span class="fs-3">+</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="1750"
                                        data-speed="10000">1750</span>
                                    <span class="green-caret">
                                        <img src="<?php echo e(asset('icons/Vector_7.png')); ?>" alt="caret-up"> 2.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="100" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue (<?php echo e($year); ?>)</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/clarity_container-volume-line.png')); ?>"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">2.44</span><span class="fs-3">M HL</span>
                                    <span class="red-caret">
                                        <img src="<?php echo e(asset('icons/Vector_6.png')); ?>" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="150" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Turnover </h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/ph_coin.png')); ?>" alt="ph_coin" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR </span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="10609"
                                        data-speed="10000">10 609</span> <span class="fs-4">M</span>
                                    <span class="red-caret">
                                        <img src="<?php echo e(asset('icons/Vector_6.png')); ?>" alt="caret-down"> 0.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="200" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Operating Profit</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/fluent_money-20-regular.png')); ?>" alt="money" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR </span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="809"
                                        data-speed="10000">809</span>
                                    <span class="fs-4">M </span>
                                    <span class="green-caret">
                                        <img src="<?php echo e(asset('icons/Vector_7.png')); ?>" alt="caret-up"> 10%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="250" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Net Profit after Tax</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/fluent_coin-stack-24-regular.png')); ?>"
                                        alt="coin_stack" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="732"
                                        data-speed="10000">732</span> <span class="fs-4">M</span>
                                    <span class="green-caret">
                                        <img src="<?php echo e(asset('icons/Vector_7.png')); ?>" alt="caret-up"> 4%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="300" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Market Capitalization</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/heroicons_chart-pie.png')); ?>"
                                        alt="heroicons_chart-pie" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="8717"
                                        data-speed="10000">8717 </span> <span class="fs-4">M</span>
                                    <span class="red-caret">
                                        <img src="<?php echo e(asset('icons/Vector_6.png')); ?>" alt="caret-down">4%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6 col-sm-12" data-aos="fade-down" data-aos-duration="350" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue (<?php echo e($year); ?>)</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/clarity_container-volume-line.png')); ?>"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">2.44 </span>
                                    <span class="fs-4">M HL </span>
                                    <span class="red-caret">
                                        <img src="<?php echo e(asset('icons/Vector_6.png')); ?>" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="400" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue (<?php echo e($year); ?>)</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/clarity_container-volume-line.png')); ?>"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">244 </span><span class="fs-4">M HL </span>
                                    <span class="red-caret">
                                        <img src="<?php echo e(asset('icons/Vector_6.png')); ?>" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="500" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue (<?php echo e($year); ?>)</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="<?php echo e(asset('icons/clarity_container-volume-line.png')); ?>"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">2.44 </span>
                                    <span class="fs-4">M HL </span>
                                    <span class="red-caret">
                                        <img src="<?php echo e(asset('icons/Vector_6.png')); ?>" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <div class="ir-section-details py-6">
        <div class="container" style="width:80%;">
            <div class="row">
                <div class="col-lg-6 col-md-12 px-5" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                    <div class="overview-image bg-image pbg-shadow"
                        style="background-image: url(<?php echo e(asset('images/our-leadership/leader-1.png')); ?>)"
                        class="rounded">
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 px-3 py-4" data-aos="fade-left" data-aos-duration="500" data-aos-easing="linear">
                    <div >
                        <h3>Chairman's message</h3>
                        <h4>Vision in Action</h4>
                        <p class="smallest-text" style="text-align: justify">
                            I would like to extend my heartfelt thanks to my fellow
                            directors for their unwavering support and strategic insight
                            throughout the year. Their guidance has been instrumental in
                            navigating the challenges and seizing the opportunities that
                            have come our way.
                            <br><br>I also wish to express my appreciation to
                            the executives and management team, under the leadership
                            of our CEO, Bernard Theys and our COO/ CFO, Patrick Rivalland,
                            for their exemplary leadership and commitment to delivering
                            on our strategic objectives.<br><br>
                            To our dedicated team, your hard work, resilience and passion
                            are the foundation of our success, and I am truly grateful for
                            your continued contribution. Lastly, I would like to thank
                            our valued stakeholders for their trust, collaboration, and
                            confidence in our vision.
                        </p>
                        
                    </div>

                </div>
            </div>

            <div class="row mt-6">
                <div class="col-lg-6 col-md-12 px-3 py-4" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                    <h3>CEO'S review</h3>
                    <div>
                        <p class="smallest-text" style="text-align: justify">
                            Business conditions improved somewhat over the past year, but a number of
                            challenges remained.
                            <br><br>
                            These included a weaker currency and the ongoing shortage
                            of foreign currency to pay international suppliers, supply chain complexity that
                            delayed or disrupted deliveries of vital inputs, fluctuating freight costs, rising
                            energy costs and high interest rates.
                            <br></br>
                            We have successfully implemented strategies to mitigate supply chain disruptions caused by
                            raw material
                            shortages and foreign exchange issues.However, the labour market remains
                            extremely tight, particularly for technical skills, and we continue to explore ways
                            to secure the necessary skills to support production and expansion.
                        </p>
                        
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 px-5" data-aos="fade-left" data-aos-duration="500" data-aos-easing="linear">
                    <div class="overview-image bg-image pbg-shadow"
                        style="background-image: url(<?php echo e(asset('images/our-leadership/leader-11.png')); ?>)"
                        class="rounded">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer id="footer" class="dark">
        <div class="container">
            <div id="pbv-copyrights">
                <div class="container">

                    <div class="row col-mb-30">

                        <div class="col-md-5 text-center text-md-start">
                            Copyright &copy; <?php echo e(date('Y')); ?> Phoenix Beverages Group. All Rights Reserved.<br>
                        </div>
                        <div class="col-md-5 text-center text-md-start">
                            <div class="copyright-links"><a href="#">Terms & Conditions</a> | <a
                                    href="#">Cookies
                                    Policy</a> | <a href="#"> Privacy Policy</a></div>
                        </div>

                        <div class="col-md-2 text-center text-md-end">
                            Developed by Zethical
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://unpkg.com/aos@next/dist/aos.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/countup@1.8.2/countUp.js"></script>
    <script>
        AOS.init({
            once: true,
            duration: 500
        });

        $(document).ready(function() {
            // Iterate over all elements with class 'pbgCountUp'
            $('.pbgCountUp').each(function() {
                var $this = $(this);
                var target = parseFloat($this.data('to')); // Get the target value (float or int)
                var unit = $this.next('.fs-3').text().trim(); // Get the adjacent unit text

                // Initialize CountUp with the target number
                var countUp = new CountUp($this[0], 0, target, 0, 10, { // 10 seconds for animation
                    separator: ',', // Use comma for thousands separator
                    decimal: '.' // Use dot for decimal separator
                });

                // IntersectionObserver to trigger the count-up animation when the element enters the viewport
                var observer = new IntersectionObserver(function(entries, observer) {
                    entries.forEach(function(entry) {
                        if (entry.isIntersecting) {
                            countUp.start(); // Start the counting animation
                            observer.unobserve(entry
                                .target); // Stop observing after starting the animation
                        }
                    });
                }, {
                    threshold: 0.8
                }); // Element should be 80% visible to start animation

                // Start observing the element
                observer.observe($this[0]);

                // Callback function to format the number and append the unit after counting
                countUp.callback = function() {
                    var finalValue = countUp.endVal;

                    // If the number has a decimal part, format it to 2 decimal places
                    if (finalValue % 1 !== 0) {
                        finalValue = finalValue.toFixed(
                            2); // Apply toFixed(2) only if there is a decimal part
                    }

                    // Update the displayed text with the number and the unit
                    $this.text(finalValue + ' ' + unit); // Append the unit to the number
                };
            });
        });
    </script>

</body>

</html>
<?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views//pbl-integrated-report/report-2024.blade.php ENDPATH**/ ?>