<style>
    .show-alert {
        display: flex;
        align-items: center;
        justify-content: flex-start;
        position: relative;
        padding: 8px;
        font-size: 1rem;
        border-radius: 5px;
        margin-bottom: 20px;
    }

    .show-alert .alert-icon {
        font-size: 1.5rem;
        margin-right: 10px;
        vertical-align: middle;
    }

    /* Alert message text */
    .show-alert .alert-text {
        display: inline-block;
        vertical-align: middle;
        font-size: 1rem;
    }

    /* Success style */
    .show-alert.success {
        color: #28a745;
        /* Green color */
    }

    /* Error style */
    .show-alert.error {
        color: #dc3545;
        /* Red color */
    }

    #loading-spinner {
        display: inline-flex;
        justify-content: center;
        align-items: center;
        margin: 15px;
    }

    /* The spinner itself */
    .spinner {
        border: 4px solid #f3f3f3;
        border-top: 4px solid #3498db;
        border-radius: 50%;
        width: 20px;
        height: 20px;
        animation: spin 1s linear infinite;
    }

    #submit-button:disabled {
        background-color: #ddd;
        cursor: not-allowed;
        pointer-events: none;
        border: none;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }

    /* Close button styling for the alert */
    .alert .close {
        font-size: 1.5rem;
        color: #000;
        background: transparent;
        border: none;
        padding: 0.5rem;
        cursor: pointer;
    }

    /* Honeypot field styling - completely hidden */
    .honeypot-field {
        position: absolute !important;
        left: -9999px !important;
        top: -9999px !important;
        width: 1px !important;
        height: 1px !important;
        opacity: 0 !important;
        pointer-events: none !important;
        z-index: -1 !important;
    }
</style>
<?php $__env->startSection('content'); ?>
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url(<?php echo e(asset('images/Team-2-contact.jpg')); ?>);">
        </div>
        <div class="page-title-container">
            <h4>CONTACT US</h4>
            <span class="text-primary">Get in touch</span>
        </div>
    </div>

    <div class="container landing-section">
        <div class="row">
            <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 col-lg-4" data-aos="fade-up" data-aos-delay="<?php echo e($loop->index * 100); ?>">
                    <div class="contact-info-box contact-info-box-small mb-4">
                        <div class="country">
                            <h4 class="text-primary"> <?php echo e($contact['country'] ?? ''); ?></h4>
                        </div>
                        <div class="brand-name"><?php echo e($contact['name'] ?? ''); ?></div>
                        <div class="address"><span class="text-primary">Address: </span><?php echo e($contact['address'] ?? ''); ?>

                        </div>
                        <div class="email"><span class="text-primary">Email: </span><?php echo e($contact['email'] ?? ''); ?></div>
                        <div class="tel"><span class="text-primary">Tel: </span><?php echo e($contact['tel'] ?? ''); ?></div>
                        
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <div class="col-12">
                <div class="contact-info-box contact-info-box-big smaller-text" data-aos="fade-up" data-aos-delay="1000">
                    <h4 class="text-primary">MOMENTS by PhoenixBev</h4>
                    <div class="" style="margin-left: 10px">
                        <div class="row">
                            <div class="col-12 col-lg-6">
                                <div class="address">Address: Pont Fer, Phoenix, Mauritius</div>
                                <div class="tel">Tel: +230 601 2083</div>
                            </div>
                            <div class="col-12 col-lg-6">
                                <div class="address">Address: La Place Cap Tamarin, Mauritius
                                </div>
                                <div class="tel">Tel: +230 484 5206</div>
                            </div>
                        </div>
                        <div class="row mt-5">
                            <div class="col-12 col-lg-6">
                                <div class="address">Address: Shop A82-A83, Tribeca Mall, Ebène, Mauritius</div>
                                <div class="tel">Tel: +230 471 3009</div>
                            </div>
                            <div class="col-12 col-lg-6">
                                <div class="address">Address: Chemin Vingt Pieds, Grand Baie, Mauritius 30513</div>
                                <div class="tel">Tel: +230 268 2384</div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <br><br><br>
            <div class="col-12 col-lg-4" data-aos="fade-up" data-aos-delay="1000">
                <div class="contact-info-box contact-info-box-small smaller-text mb-5">
                    <div class="country">
                        <h4 class="text-primary">Phoenix Shop</h4>
                        <div class="tel">Tel: +230 601 2171</div>
                    </div>

                    <br><br><br>

                    <div class="address"><span class="text-primary">Export Division</span></div>
                    <div class="tel">Tel: +230 601 2000</div>
                </div>
            </div>
            <div class="col-12 col-lg-4" data-aos="fade-up" data-aos-delay="1000">
                <div class="contact-info-box contact-info-box-small smaller-text mb-5">
                    <div class="country">
                        <h4 class="text-primary">Public Relations</h4>
                    </div>
                    <div class="brand-name">Zethical Ltd</div>
                    <br>

                    <div class="address"><span class="text-primary">Address: </span>Port Louis, Mauritius</div>
                    <div class="email"><span class="text-primary">Email: </span> enquiries@zethical.com</div>
                    <div class="tel"><span class="text-primary">Tel: </span> +230 260 6050</div>
                </div>
            </div>
            <div class="col-12 col-lg-4" data-aos="fade-up" data-aos-delay="1000">
                <div class="contact-info-box contact-info-box-small smaller-text">
                    <div class="country">
                        <h4 class="text-primary">Customer Response Unit</h4>
                    </div>
                    <br><br>

                    <div class="tel"><span class="text-primary">Tel: </span> +230 601 2091</div>
                    <div class="tel"><span class="text-primary">Tel: </span> +230 601 2092</div>
                    
                </div>
            </div>

            <br><br><br>
        </div>

        <div class="row get-in-touch">
            <div class="col-12 col-lg-4 px-4" data-aos="fade-right" data-aos-delay="1000">
                <div class="text-primary">Get in touch</div>
                <h3>Write Us A Message</h3>
                <div class="contact-message" style="text-align: justify">
                    Do not hesistate to contact us if you require any further information. The contact details of
                    phoenix Beverages Group is available on this page,
                    you can give us a call or send us a message through our contact form.
                </div>
                &nbsp

                <div class="text-primary">Careers</div>
                <h3>Come in, find your seat</h3>
                <div class="contact-message" style="text-align: justify">
                    We nurture people who are generous in their
                    sharing of ideas and passionate about delivering quality to our customers and our consumers.

                    <div class="LearnMore">
                        <a href="<?php echo e(route('careers')); ?>" class="smallest-text">Explore more about our recruitment.</a>
                    </div>
                </div>
            </div>

            <div class="col-12 col-lg-8" data-aos="fade-left" data-aos-delay="1000">
                <form id="contact-form">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="form_start_time" value="<?php echo e(time()); ?>">
                    
                    <!-- Honeypot fields - hidden from users but visible to bots -->
                    <div class="honeypot-field">
                        <input type="text" name="website" tabindex="-1" autocomplete="off">
                        <input type="text" name="url" tabindex="-1" autocomplete="off">
                        <input type="text" name="phone" tabindex="-1" autocomplete="off">
                        <input type="text" name="company" tabindex="-1" autocomplete="off">
                        <input type="text" name="subject" tabindex="-1" autocomplete="off">
                    </div>
                    
                    <div class="custom-form-group">
                        <input type="text" class="form-control" placeholder="Full Name" name="full_name"
                            value="<?php echo e(old('full_name')); ?>" required minlength="3" maxlength="50">
                        <?php $__errorArgs = ['full_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                        <input type="email" class="form-control" placeholder="Email" name="email"
                            value="<?php echo e(old('email')); ?>" required>
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <textarea class="form-control" name="message" placeholder="Message" rows="7" required 
                            minlength="10" maxlength="1000"><?php echo e(old('message')); ?></textarea>
                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="alert alert-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="custom-form-group">
                        <div class="h-captcha" data-sitekey="<?php echo e(env('NOCAPTCHA_SITEKEY')); ?>"></div>
                    </div>
                    <div class="cta">
                        <input type="button" class="button pbg-button pbg-shadow" id="submit-button" value="Submit" />
                        <div id="loading-spinner" style="display: none; margin-left: 10px;">
                            <div class="spinner"></div>
                        </div>
                        <div class="show-alert" style="display: none">
                            <span class="alert-icon">&#x2714;</span>
                            <span class="alert-text text-smaller">Your submission was successful!</span>
                        </div>
                    </div>
                </form>
            </div>

        </div>

        <br><br><br>
        <h2>Locate us at</h2>
    </div>

    <div class="mt-5">
        <div class="map-container container-fluid">
            <iframe src="https://maps.google.com/maps?q=Pont Fer, Phoenix, 73544, Mauritius&amp;output=embed"></iframe>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<script src="<?php echo e(URL::asset('jquery/dist/jquery.js')); ?>"></script>
<script>
    var tpj = jQuery.noConflict();
    tpj(document).ready(function() {
        tpj("#contact-form").validate({
            rules: {
                full_name: {
                    required: true,
                    minlength: 3
                },
                email: {
                    required: true,
                    email: true
                },
                message: {
                    required: true,
                    minlength: 10
                }
            },
            messages: {
                full_name: {
                    required: "Please enter your name",
                    minlength: "Your name must be at least 3 characters long"
                },
                email: {
                    required: "Please enter your email",
                    email: "Please enter a valid email address"
                },
                message: {
                    required: "Please enter your message",
                    minlength: "Your message must be at least 10 characters long"
                }
            }
        });

        tpj("#submit-button").on('click', function(event) {
            event.preventDefault();
            
            // Prevent rapid submissions
            if (tpj("#submit-button").prop('disabled')) {
                return;
            }
            
            if (tpj("#contact-form").valid()) {
                // Check if form was filled too quickly (less than 3 seconds)
                var formStartTime = tpj('input[name="form_start_time"]').val();
                var currentTime = Math.floor(Date.now() / 1000);
                var timeDiff = currentTime - formStartTime;
                
                if (timeDiff < 3) {
                    tpj(".show-alert")
                        .removeClass("success")
                        .addClass("error")
                        .find(".alert-icon")
                        .html("&#10060;")
                        .end()
                        .find(".alert-text")
                        .text("Please take your time to fill out the form properly.")
                        .end()
                        .show();
                    return;
                }

                var hcaptchaResponse = grecaptcha.getResponse();

                if (hcaptchaResponse === "") {
                    tpj(".show-alert")
                        .removeClass("success")
                        .addClass("error")
                        .find(".alert-icon")
                        .html("&#10060;")
                        .end()
                        .find(".alert-text")
                        .text("Please complete the reCAPTCHA.")
                        .end()
                        .show();
                    return;
                }

                $("#submit-button").prop("disabled", true);
                $("#loading-spinner").show();

                $.ajax({
                    url: "<?php echo e(route('send.email')); ?>",
                    method: "POST",
                    data: tpj("#contact-form").serialize() + "&h-recaptcha-response=" + hcaptchaResponse,
                    success: function(response) {

                        $("#loading-spinner").hide();
                        if (response.status === 'success') {
                            const caseId = response.data;
                            tpj(".show-alert")
                                .removeClass("error")
                                .addClass("success")
                                .find(".alert-icon")
                                .html("&#x2714;")
                                .end()
                                .find(".alert-text")
                                .text(`Your submission was successful! case id : ${caseId} `)
                                .end()
                                .show();
                        } else {
                            $(".show-alert")
                                .removeClass("success")
                                .addClass("error")
                                .find(".alert-icon")
                                .html("&#10060;")
                                .end()
                                .find(".alert-text")
                                .text("Something went wrong, please try again later.")
                                .end()
                                .show();
                        }


                        tpj("#contact-form")[0].reset();

                    },
                    error: function(xhr, status, error) {
                        tpj("#loading-spinner").hide();
                        tpj(".show-alert")
                            .removeClass("success")
                            .addClass("error")
                            .find(".alert-icon")
                            .html("&#10060;")
                            .end()
                            .find(".alert-text")
                            .text("Something went wrong, please try again later.")
                            .end()
                            .show();
                    },
                    complete: function() {
                        $("#submit-button").prop("disabled", false);
                    }
                });
            }
        });
    });


    tpj(document).on('click', '.alert .close', function() {
        tpj(this).parent().hide();
    });
</script>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views//contact-us.blade.php ENDPATH**/ ?>