<style>
    .pdf-container {
        margin: 150px auto;
        padding: 20px;
        max-width: 1000px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        border-radius: 8px;
        text-align: center;
        background: #08BABB;
    
    }

    #pdf-canvas {
        border-radius: 8px;
    }

    canvas {
        border: 1px solid #ddd;
    }

    .navigation {
        display: flex;
        justify-content: space-evenly;
        align-items: center;
        margin-top: 30px;
    }

    .navigation button {
        padding: 6px 14px;
        font-size: 14px;
        background-color: #0A1F2E;
        color: white;
        border: none;
        border-radius: 4px;
        cursor: pointer;
    }

    .navigation button:disabled {
        background-color: #EBEBE4;
    }

    .page-info {
        font-size: 14px;
        color: #0A1F2E;
        font-weight: bold;
    }
</style>
<?php $__env->startSection('content'); ?>

    <div class="container landing-section">
        <div class="row">
            <div class="col-12 col-lg-8 offset-lg-2">
                <div class="mb-5">
                    <div class="back-button">
                        <a href="<?php echo e(route('news-room')); ?>">
                            <span class="fas fa-arrow-left"></span> Back
                        </a>
                    </div>
                </div>

                <div class="">
                    <div class="mb-5 text-left">
                        <span class="fas fa-calendar"></span> <?php echo e($news->date); ?>

                        <span class="read-time"><i> 5 min read</i></span>
                    </div>
                    <h4 class="text-left w-75 mb-3">
                        <?php echo e($news->title); ?>

                    </h4>
                </div>

                <div class="my-5">
                     <img src="<?php echo e($news->image_url); ?>" 
                            alt=<?php echo e($news->title); ?>}">
                </div>

                <?php echo $news->body; ?>



                <?php if($news->pdf): ?>
                    <div class="pdf-container mx-auto w-75">
                        <canvas id="pdf-canvas"></canvas>
                        <div class="navigation">
                            <button id="prevBtn">Previous</button>
                            <span class="page-info" id="page-info">Page 1</span>
                            <button id="nextBtn">Next</button>
                        </div>
                    </div>
                <?php endif; ?>



                <div class="d-flex justify-content-between align-items-center mt-6">
                    <p class="mb-0 fw-bold">Share</p>
                    <div class="footer-socials d-flex">
                        <span class="fa-brands fa-facebook-square mx-1"></span>
                        <span class="fa-brands fa-linkedin mx-1"></span>
                        <span class="fa fa-envelope mx-1" style="cursor: pointer"></span>
                    </div>
                </div>
                <hr class="m-0">

            </div>
        </div>


        <div class="container" style="margin:150px 0px;">
            <h5 class="all-news-class p-3">More News</h5>
            <div class="row all-news-class" id="all-news-id">
                <?php if (! (empty($news))): ?>
                    <?php $__currentLoopData = $randomNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $newsDetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-12 col-lg-4">
                            <div class="news-room-container">
                                <div class="news-box">
                                    <img src="<?php echo e(url(str_replace('assets/', '', $newsDetail->image_url))); ?>" alt="News Image">
                                    <div class="overlay">
                                        <span>Business</span>
                                    </div>
                                </div>
                                <div class="news-room-text">
                                    <p class="news-room-title">
                                        <a href="<?php echo e(route('news.details', $newsDetail->id)); ?>"><?php echo e($newsDetail->title); ?></a>
                                    </p>
                                    <div class="news-meta">
                                        <p class="news-room-date"><?php echo e($newsDetail->date); ?></p>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>

            

        </div>


    </div>


    <script>
        const url = "<?php echo e($news->pdf); ?>";
        let pdfDoc = null;
        let currentPage = 1;

        const canvas = document.getElementById('pdf-canvas');
        const context = canvas.getContext('2d');
        const prevBtn = document.getElementById('prevBtn');
        const nextBtn = document.getElementById('nextBtn');
        const pageInfo = document.getElementById('page-info');

        // Load PDF
        const loadingTask = pdfjsLib.getDocument(url);

        loadingTask.promise.then(function(pdf) {
            pdfDoc = pdf;
            renderPage(currentPage);
            updateNavigation();
        }).catch(function(error) {
            console.error('Error while loading PDF: ', error);
        });

        function renderPage(pageNum) {
            pdfDoc.getPage(pageNum).then(function(page) {
                const scale = 1; // Adjust zoom level
                const viewport = page.getViewport({
                    scale: scale
                });

                canvas.height = viewport.height;
                canvas.width = viewport.width;

                // Render page to canvas
                page.render({
                    canvasContext: context,
                    viewport: viewport
                });

                pageInfo.textContent = `Page ${pageNum} of ${pdfDoc.numPages}`;
            });
        }

        // Previous page
        prevBtn.addEventListener('click', () => {
            if (currentPage > 1) {
                currentPage--;
                renderPage(currentPage);
                updateNavigation();
            }
        });

        // Next page
        nextBtn.addEventListener('click', () => {
            if (currentPage < pdfDoc.numPages) {
                currentPage++;
                renderPage(currentPage);
                updateNavigation();
            }
        });

        // Update navigation buttons
        function updateNavigation() {
            prevBtn.disabled = currentPage <= 1;
            nextBtn.disabled = currentPage >= pdfDoc.numPages;
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views//news/news-details.blade.php ENDPATH**/ ?>