<style>
    .pbg-accordion .white-accordion .accordion-button {
        background-color: white !important;
        font-size: 16px !important;
        color: black !important;
        font-weight: bold;
        box-shadow: none;
        padding: 0px !important;
    }

    .pbg-accordion .white-accordion .accordion-body p {
        color: black !important;
        font-weight: 400;
        font-size: 12px;
    }

    .about-us-container {
        background: url('images/about-pbg/about_perp.png');
        background-position: center;
        background-repeat: no-repeat;
        background-size: cover;
        width: 100%;
        height: 100%;
    }

    .white-accordion {
        background-color: white !important;
        font-size: 16px !important;
        color: black !important;
        font-weight: bold;
        box-shadow: none;
    }

    /* Mobile Responsive Styles */
    @media (max-width: 768px) {
        .about-banner {
            height: 300px !important;
            min-height: 300px;
            background-size: cover !important;
            background-position: center !important;
        }

        .page-title-container {
            position: relative !important;
            margin: 20px auto !important;
            margin-left: auto !important;
            margin-right: auto !important;
            margin-top: 20px !important;
            width: 90% !important;
            max-width: 90% !important;
            min-height: auto !important;
            padding: 30px 20px !important;
            text-align: center;
        }

        .page-title-container h4 {
            font-size: 1.8rem !important;
            margin-bottom: 10px !important;
        }

        .page-title-container .text-primary {
            font-size: 1.2rem !important;
        }

        .landing-section {
            padding-top: 50px !important;
            padding-bottom: 50px !important;
        }

        .landing-section .header h2 {
            font-size: 1.8rem !important;
            line-height: 1.3 !important;
            margin-bottom: 30px !important;
        }

        .row.mx-auto {
            width: 100% !important;
            padding: 0 15px !important;
        }

        .column-padding {
            padding: 15px !important;
            margin-bottom: 20px !important;
        }

        .glance-container {
            padding: 0 15px !important;
        }

        .glance-box {
            height: auto !important;
            min-height: 200px !important;
            margin-bottom: 20px !important;
            padding: 25px 20px !important;
        }

        .glance-box-image {
            margin-bottom: 15px !important;
        }

        .glance-box-image img {
            max-width: 60px !important;
            height: auto !important;
        }

        .glance-box-figure {
            font-size: 1.8rem !important;
            margin-bottom: 10px !important;
        }

        .glance-box-title {
            font-size: 0.9rem !important;
            line-height: 1.4 !important;
        }

        .about-us-container {
            min-height: 300px !important;
            padding: 20px !important;
        }
    }

    @media (max-width: 480px) {
        .about-banner {
            height: 250px !important;
            min-height: 250px;
        }

        .page-title-container {
            width: 95% !important;
            padding: 25px 15px !important;
        }

        .page-title-container h4 {
            font-size: 1.5rem !important;
        }

        .page-title-container .text-primary {
            font-size: 1.1rem !important;
        }

        .landing-section .header h2 {
            font-size: 1.5rem !important;
        }

        .glance-box {
            min-height: 180px !important;
            padding: 20px 15px !important;
        }

        .glance-box-figure {
            font-size: 1.5rem !important;
        }

        .glance-box-title {
            font-size: 0.8rem !important;
        }
    }
</style>
<?php $__env->startSection('content'); ?>
    <div class="page-blue">
        <div class="about-banner bg-image"
            style="background-image: url(<?php echo e(asset('images/about-pbg/about-banner-24.png')); ?>)">
        </div>
        <div class="page-title-container">
            <h4>ABOUT US</h4>
            <span class="text-primary">Securing the Future</span>
        </div>


        <div class="container landing-section">
            <div class="header center">
                <h2 data-aos="fade-down" data-aos-duration="500" data-aos-easing="linear">The Foundation of <br>Phoenix Beverages Group</h2>
            </div>
            <div class="row mx-auto" style="width:80%">
                <div class="col-12 col-lg-6 column-padding" style="text-align: justify" data-aos="fade-right" data-aos-duration="500"
                    data-aos-easing="linear">
                    Phoenix Beverages Group boasts a rich legacy in the beverage industry, tracing its roots back to 1931.
                    Over the decades, it has grown into a leading FMCG company in Mauritius, with aspirations to become
                    a market leader in the region. Since 1993, the Group has been listed on the official market of the
                    Mauritius Stock Exchange.
                </div>
                <div class="col-12 col-lg-6 column-padding" style="text-align: justify" data-aos="fade-right" data-aos-duration="500"
                    data-aos-easing="linear">
                    We aim to lead the commercial beverage industry in the Indian Ocean region by ensuring the availability
                    and affordability of our products locally and internationally. Our mission is to build meaningful,
                    valuable brands through sustainable and profitable operations aligned with five key Sustainable
                    Development Goals (SDGs).
                </div>
            </div>
            <div class="row mx-auto" style="width:80%">
                <div class="col-12 col-lg-6 column-padding" style="text-align: justify" data-aos="fade-left" data-aos-duration="500"
                    data-aos-easing="linear">
                    Our portfolio features a diverse range of alcoholic and non-alcoholic beverages, including beers, wines,
                    spirits, soft drinks, table water, juices, and more. In addition to producing and selling our own
                    products,
                    we are the authorised bottler for The Coca-Cola Company and Diageo products in Mauritius.
                </div>
                <div class="col-12 col-lg-6 column-padding" style="text-align: justify" data-aos="fade-left" data-aos-duration="500"
                    data-aos-easing="linear">
                    Our progress is driven by a dedicated team of over 1,650 collaborators, whose efforts have earned
                    Phoenix Beverages Group numerous international accolades. Together, they enable us to operate
                    four state-of-the-art production plants in Mauritius and Réunion Island.
                </div>
            </div>
        </div>
    </div>

    <div class="container landing-section">
        <div class="header center">
            <h2 data-aos="fade-down" data-aos-duration="500" data-aos-easing="linear">Phoenix Beverages Group <br>at a Glance (2024 - 2025)</h2>
        </div>
        <div class="row glance-container">
            <?php $__currentLoopData = $stats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-6 col-lg-3" data-aos="fade-up" data-aos-duration="<?php echo e($loop->index * 100); ?>" data-aos-easing="linear">
                    <div class="glance-box center">
                        <div class="glance-box-image">
                            <img src="<?php echo e(asset('images/' . $stat['image'])); ?>">
                        </div>
                        <div class="glance-box-figure text-primary countUpElement"
                            data-to="<?php echo e(preg_replace('/[^0-9.]/', '', $stat['value'])); ?>" data-speed="10000"
                            data-symbol="<?php echo e($stat['figure']); ?>">

                            <span class="count"><?php echo e($stat['value']); ?></span><span
                                class="count"><?php echo e($stat['figure']); ?></span>
                        </div>
                        <div class="glance-box-title"><?php echo e($stat['title']); ?></div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <div class="landing-section">
        <div class="px-6 about-us-container">
            <div class="row">
                <div class="col-md-8"></div>
                <div class="col-md-4" style="margin-top:120px;">
                </div>
            </div>
            
        </div>
    </div>

    <script>
        var current_page = 1;
        var image_base_path = "<?php echo e(asset('images/brands')); ?>" + "/";
        console.log(image_base_path);

        function loadBrands() {
            $("#load-more-button").html("<div class='loader'></div>");
            $.ajax({
                url: "<?= route('brand-data-brands-api') ?>",
                type: 'GET',
                data: {
                    page: current_page
                },
                dataType: 'json',
                success: function(data) {
                    var brands = data.brands.data;

                    if (brands.length < 1) {
                        // $("#load-more-button").html("Load More").prop('disabled', true);
                        $("#load-more-button").remove();
                    } else {
                        for (let i = 0; i < brands.length; i++) {
                            var brand_column = `
                                <div class="col-6 col-lg-3">
                                    <div class="brand-box rounded">
                                        <img src="${image_base_path + brands[i]['logo']}" alt="Brand Logo">
                                        <div class="content-area rounded">
                                            <p>${brands[i]['year']} - ${brands[i]['description']}.</p>
                                        </div>
                                    </div>
                                </div>`;

                            $("#brands-over-years").append(brand_column);
                        }

                        $("#load-more-button").html("Load More");
                        current_page = current_page + 1;
                    }
                },
                error: function(request, error) {
                    console.error('Error fetching brand data:', error);
                }
            });
        }

        document.addEventListener("DOMContentLoaded", function(event) {
            loadBrands();

        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views/about-us.blade.php ENDPATH**/ ?>