@extends('layouts.app')
@section('content')
    <!-- Mobile Hero Section (hidden on desktop) -->
    <div class="mobile-hero-content d-block d-md-none">
        <div class="container">
            <div class="mobile-hero-slide active">
                <img src="{{ asset('images/homepage/PB_beer_welcome.png') }}" class="mobile-hero-image" alt="pbg-foster-brand-slider">
                <h4 class="mobile-hero-title">Thirst For The Best. <br> First For You.</h4>
                <p class="mobile-hero-description">Phoenix Beverages Group (PBG) is renowned for creating innovative beverages that elevate life's special moments.
                    We craft innovative beverages, from refreshing soft drinks and water to premium beers, wines, and spirits.
                    Made with high-quality ingredients, our products are enjoyed across Mauritius and beyond.
                </p>
                <a href="{{route('about-us')}}" class="mobile-hero-button">Explore</a>
            </div>

            <div class="mobile-hero-slide">
                <img src="{{ asset('images/homepage/pbg-foster-brand-slider.png') }}" class="mobile-hero-image" alt="pbg-foster-brand-slider">
                <h4 class="mobile-hero-title">Inspiring Brands <br />Since 1931</h4>
                <p class="mobile-hero-description">Since 1931, our beverages have been an integral part of Mauritius's cultural identity. Today, we proudly share
                    our award-winning portfolio of high-quality alcoholic and non-alcoholic drinks beyond our shores. We are driven
                    by a continued commitment to excellence and innovation locally and beyond borders.
                </p>
                <a href="{{route('our-brand')}}" class="mobile-hero-button">Explore</a>
            </div>

            <div class="mobile-hero-slide">
                <img src="{{ asset('images/homepage/pbg-innovation-slider.png') }}" class="mobile-hero-image" alt="pbg-innovation-slider">
                <h4 class="mobile-hero-title">Driving an Innovation-Led <br />Beverage Revolution</h4>
                <p class="mobile-hero-description">With a diverse and evolving portfolio, Phoenix Beverages Group leads the way in shaping both beloved favourites and bold new offerings.
                    We remain attuned to changing consumer preferences, continually introducing innovative flavours and expanding our range to include
                    lower-alcohol and reduced-sugar options, all while upholding our commitment to quality and taste.
                </p>
                <a href="{{route('innovation')}}" class="mobile-hero-button">Explore</a>
            </div>

            <div class="mobile-hero-slide">
                <img src="{{ asset('images/homepage/pbg-phoenix-earth-sdg-slider.png') }}" class="mobile-hero-image" alt="pbg-phoenix-earth-slider">
                <h4 class="mobile-hero-title">Act Responsibly, <br /> Think Sustainable</h4>
                <p class="mobile-hero-description">At Phoenix Beverages Group, sustainability is embedded in every facet of our operations. As a responsible producer, we are firmly committed to our ESG principles,
                    from the sustainable management of natural resources to strict adherence to environmental regulations. Our objective is clear:
                    to minimise our ecological footprint while maintaining the highest standards of operational excellence.
                </p>
                <a href="{{route('phoenix-earth')}}" class="mobile-hero-button">Explore</a>
            </div>

            <div class="mobile-hero-slide">
                <img src="{{ asset('images/homepage/pbg-our-reach-map-slider.png') }}" class="mobile-hero-image" alt="pbg-our-reach-slider">
                <h4 class="mobile-hero-title">Expanding Our Regional <br />Footprint</h4>
                <p class="mobile-hero-description">In 2025, Phoenix Beverages Group stands at the forefront of the Indian Ocean's beverage industry. With the acquisition of Seychelles Breweries
                    and the launch of Coca-Cola production at Edena SA in Réunion Island, we now extend our manufacturing reach. Our brands are also present across
                    key international markets — spanning the Indian Ocean, Africa, Australia, and Europe. As we continue to grow, we remain firmly committed to our vision:
                    <i>Providing happiness through beverages.</i>
                </p>
                <a href="{{route('our-reach')}}" class="mobile-hero-button">Explore</a>
            </div>

            <!-- Mobile Indicators -->
            <div class="mobile-indicators">
                <span class="mobile-indicator active"></span>
                <span class="mobile-indicator"></span>
                <span class="mobile-indicator"></span>
                <span class="mobile-indicator"></span>
                <span class="mobile-indicator"></span>
            </div>
        </div>
    </div>

    <!-- Desktop Hero Section (hidden on mobile) -->
    <div class="page-blue d-none d-md-block">
        <div class="hero-content">
            <div class="slider">
                <div class="dashSlides">

                    <div class="dashSlide animate__animated animate__fadeIn animate__slower 3s">
                        <div class="slide-content">
                            <div class="left-content" style="text-align: justify">
                                <h4>Thirst For The Best. <br> First For You.</h4>
                                <p>Phoenix Beverages Group (PBG) is renowned for creating innovative beverages that elevate life's special moments.
                                    We craft innovative beverages, from refreshing soft drinks and water to premium beers, wines, and spirits.
                                    Made with high-quality ingredients, our products are enjoyed across Mauritius and beyond.
                                </p>
                                <div class="cta">
                                    <button class="button pbg-button pbg-shadow-dash">
                                        <a class="black" href="{{route('about-us')}}">Explore </a>
                                    </button>
                                </div>
                            </div>
                            <div class="right-content">
                                <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                    <img src="{{ asset('images/homepage/PB_beer_welcome.png') }}" class="bg-image" alt="pbg-foster-brand-slider">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="dashSlide active animate__animated animate__fadeIn animate__slower 3s">
                        <div class="slide-content">
                            <div class="left-content" style="text-align: justify">
                                <h4>Inspiring Brands <br />Since 1931</h4>
                                <p>Since 1931, our beverages have been an integral part of Mauritius's cultural identity. Today, we proudly share
                                    our award-winning portfolio of high-quality alcoholic and non-alcoholic drinks beyond our shores. We are driven
                                    by a continued commitment to excellence and innovation locally and beyond borders.
                                </p>
                                <div class="cta">
                                    <button class="button pbg-button pbg-shadow-dash">
                                        <a class="black" href="{{route('our-brand')}}">Explore </a>
                                    </button>
                                </div>
                            </div>
                            <div class="right-content">
                                <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                    <img src="{{ asset('images/homepage/pbg-foster-brand-slider.png') }}" class="bg-image" alt="pbg-foster-brand-slider">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="dashSlide animate__animated animate__fadeIn animate__slower 3s">
                        <div class="slide-content">
                            <div class="left-content" style="text-align: justify">
                                <h4>Driving an Innovation-Led <br />Beverage Revolution </h4>
                                <p>With a diverse and evolving portfolio, Phoenix Beverages Group leads the way in shaping both beloved favourites and bold new offerings.
                                    We remain attuned to changing consumer preferences, continually introducing innovative flavours and expanding our range to include
                                    lower-alcohol and reduced-sugar options, all while upholding our commitment to quality and taste.
                                </p>
                                <div class="cta">
                                    <button class="button pbg-button pbg-shadow-dash">
                                        <a class="black" href="{{route('innovation')}}">Explore </a>
                                    </button>
                                </div>
                            </div>
                            <div class="right-content">
                                <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                    <img src="{{ asset('images/homepage/pbg-innovation-slider.png') }}" class="bg-image" alt="pbg-foster-brand-slider">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="dashSlide animate__animated animate__fadeIn animate__slower 3s">
                        <div class="slide-content">
                            <div class="left-content" style="text-align: justify">
                                <h4>Act Responsibly, <br /> Think Sustainable</h4>
                                <p>At Phoenix Beverages Group, sustainability is embedded in every facet of our operations. As a responsible producer, we are firmly committed to our ESG principles,
                                    from the sustainable management of natural resources to strict adherence to environmental regulations. Our objective is clear:
                                    to minimise our ecological footprint while maintaining the highest standards of operational excellence.
                                </p>
                                <div class="cta">
                                    <button class="button pbg-button pbg-shadow-dash">
                                        <a class="black" href="{{route('phoenix-earth')}}">Explore </a>
                                    </button>
                                </div>
                            </div>
                            <div class="right-content">
                                <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                    <img src="{{ asset('images/homepage/pbg-phoenix-earth-sdg-slider.png') }}" class="bg-image" alt="pbg-innovation-slider">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="dashSlide active animate__animated animate__fadeIn animate__slower 3s">
                        <div class="slide-content">
                            <div class="left-content" style="text-align: justify">
                                <h4>Expanding Our Regional <br />Footprint</h4>
                                <p>In 2025, Phoenix Beverages Group stands at the forefront of the Indian Ocean's beverage industry. With the acquisition of Seychelles Breweries
                                    and the launch of Coca-Cola production at Edena SA in Réunion Island, we now extend our manufacturing reach. Our brands are also present across
                                    key international markets — spanning the Indian Ocean, Africa, Australia, and Europe. As we continue to grow, we remain firmly committed to our vision:
                                    <i>Providing happiness through beverages.</i>
                                </p>
                                <div class="cta">
                                    <button class="button pbg-button pbg-shadow-dash">
                                        <a class="black" href="{{route('our-reach')}}">Explore </a>
                                    </button>
                                </div>
                            </div>
                            <div class="right-content">
                                <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                    <img src="{{ asset('images/homepage/pbg-our-reach-map-slider.png')  }}" class="bg-image" alt="hero-slider">
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Add more slides as needed -->
                </div>
                {{-- <div class ="navBtn">
                    <button class="dashPrev">&#10094;</button>
                    <button class="dashNext">&#10095;</button>
                </div> --}}

                <div class="indicators">
                    <span class="indicator active" onclick="currentSlide(0)"></span>
                    <span class="indicator" onclick="currentSlide(1)"></span>
                    <span class="indicator" onclick="currentSlide(2)"></span>
                    <span class="indicator" onclick="currentSlide(3)"></span>
                    <span class="indicator" onclick="currentSlide(4)"></span>
                    <!-- Add more indicators as needed -->
                </div>
            </div>
        </div>

    </div>

    <div class="our-story">
        <div class="container">
            <div class="mx-auto" style="width:100%">
                <h1 class="fw-bold" style="margin-bottom:5px" data-aos="fade-down" data-aos-duration="1000" data-aos-easing="linear">Get to know our Story</h1>
                <div class="row">
                    <div class="col-lg-6 col-md-12 column-padding" style="text-align: justify; position: relative;" data-aos="fade-down" data-aos-duration="1000" data-aos-easing="linear">
                        <span class="large-p">W</span>
                        <span class="story-text">ith a legacy in the beverage industry dating back to 1931, Phoenix Beverages Group has evolved into a leading FMCG company in Mauritius, striving to become the regional market leader.
                            Listed on the Mauritius Stock Exchange since 1993, we are dedicated to excellence in both local and international markets.
                        </span>
                    </div>
                    <div class="col-lg-6 col-md-12 column-padding" style="text-align: justify" data-aos="fade-down" data-aos-duration="1000" data-aos-easing="linear">
                        <span class="story-text">Phoenix Beverages Group (PBG) is renowned for creating innovative beverages that elevate life's special moments. We craft innovative beverages,
                            from refreshing soft drinks and water to premium beers, wines, and spirits. Made with high-quality ingredients, our products are enjoyed across Mauritius and beyond.
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container" data-aos="fade-down" data-aos-duration="500" data-aos-easing="linear" data-aos-delay="500">
        <div class="landing-page-video bg-image" style="background-image: url({{ asset('images/welcome-img-bck.png') }})">
            <div class="landing-video-overlay">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12" >
                        <div id="text-content">
                            <h4>Embark on a journey through <br>our evolution over the years.</h4>
                            <h6 class="smallest-text">Explore the rich legacy of our journey, uncovering our evolution, key milestones, and unwavering commitment to excellence over the years.</h6>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 text-center">
                        <div class="video-cta" id="play-btn">
                            <svg version="1.1" class="play-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" height="100px" width="100px"
                            viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve">
                         <path class="stroke-solid" fill="none" stroke="#08BABB"  d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7
                           C97.3,23.7,75.7,2.3,49.9,2.5"/>
                         <path class="stroke-dotted" fill="none" stroke="#08BABB"  d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7
                           C97.3,23.7,75.7,2.3,49.9,2.5"/>
                         <path class="icon" fill="#08BABB" d="M38,69c-1,0.5-1.8,0-1.8-1.1V32.1c0-1.1,0.8-1.6,1.8-1.1l34,18c1,0.5,1,1.4,0,1.9L38,69z"/>
                       </svg>
                        </div>

                        <div class="video-cta" id="pause-btn" style="display: none;">
                            <svg version="1.1" class="play-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" height="100px" width="100px"
                            viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve">
                         <path class="stroke-solid" fill="none" stroke="#08BABB"  d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7
                           C97.3,23.7,75.7,2.3,49.9,2.5"/>
                         <path class="stroke-dotted" fill="none" stroke="#08BABB"  d="M49.9,2.5C23.6,2.8,2.1,24.4,2.5,50.4C2.9,76.5,24.7,98,50.3,97.5c26.4-0.6,47.4-21.8,47.2-47.7
                           C97.3,23.7,75.7,2.3,49.9,2.5"/>
                         <path class="icon" fill="#08BABB" d="M38,69c-1,0.5-1.8,0-1.8-1.1V32.1c0-1.1,0.8-1.6,1.8-1.1l34,18c1,0.5,1,1.4,0,1.9L38,69z"/>
                       </svg>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Hidden video element -->
            <video id="landing-video" width="100%" height="auto" style="display: none;" disablePictureInPicture>
                <source src="{{asset('videos/pbg-coporation-launch.mp4')}}" type="video/mp4">
                Your browser does not support the video tag.
            </video>
        </div>
    </div>








    <div class="mt-6">
        <div class="container">
            <h4>Overview</h4>
        </div>
        <div class="dash-slider">
            <div class="dash-containers container">
                <div class="dash-container active animate__animated animate__fadeIn animate__slower 3s" id="container1">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right" data-aos-duration="1000" data-aos-easing="linear">
                            <div class="overview-image bg-image pbg-shadow"
                                style="background-image: url({{ asset('images/our-brands/brands-cover-2.png') }})">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left" data-aos-duration="1000" data-aos-easing="linear">
                            <h4>Our brands</h4>
                            <p style="text-align: justify">Phoenix Beverages Group creates exceptional products with premium natural ingredients,
                                earning a special place as local favourites among Mauritians and visitors alike. Discover our wide
                                range of locally crafted and international brands.
                            </p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="{{route('our-brand')}}">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dash-container animate__animated animate__fadeIn animate__slower 3s" id="container2">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right">
                            <div class="overview-image bg-image pbg-shadow"
                                style="background-image: url({{ asset('images/our-leadership/cover.png') }})">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left">
                            <h4>Our Leadership</h4>
                            <p style="text-align: justify">Phoenix Beverages Group's Board upholds the highest standards of governance,
                                aligning with Mauritius' Code of Corporate Governance. We foster a culture of ethical
                                excellence and integrity among all stakeholders.</p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="{{route('our-leadership')}}">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dash-container animate__animated animate__fadeIn animate__slower 3s" id="container3">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right">
                            <div class="overview-image bg-image pbg-shadow"
                                style="background-image: url({{ asset('images/sustainability/esg-img-cover.png') }})">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left">
                            <h4>ESG</h4>
                            <p style="text-align: justify">At Phoenix Beverages Group, sustainability is at the core of our operations,
                                shaping a responsible and thriving ecosystem. Our dedicated strategy drives
                                clear actions to embed sustainability into our brand DNA.</p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="{{route('esg')}}">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dash-container animate__animated animate__fadeIn animate__slower 3s" id="container4">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right">
                            <div class="overview-image bg-image pbg-shadow"
                                style="background-image: url({{ asset('images/innovation/cover.png') }})">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left">
                            <h4>Innovations</h4>
                            <p style="text-align: justify">Phoenix Beverages Group fosters talent through its Innovation Department, a hub for creativity where ideas are nurtured
                                and realised. We encourage everyone across the organisation to contribute and bring innovations to life.
                            </p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="{{route('innovation')}}">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dash-container animate__animated animate__fadeIn animate__slower 3s" id="container5">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right">
                            <div class="overview-image bg-image pbg-shadow"
                                style="background-image: url({{ asset('images/our-reach/cover.png') }})">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left">
                            <h4>Our Reach</h4>
                            <p style="text-align: justify"> For 22 years, Phoenix Beverages Group has expanded its global footprint,
                                starting with its first beer export. Driven by our International Business Units, our beers have gained a strong presence in international markets.
                            </p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="{{route('our-reach')}}">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dash-container animate__animated animate__fadeIn animate__slower 3s" id="container6">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right">
                            <div class="overview-image bg-image pbg-shadow "
                                style="background-image: url({{ asset('images/our-culture/cover.png') }})">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left">
                            <h4>Our Culture</h4>
                            <p style="text-align: justify">Phoenix Beverages Group thrives on a high-performance culture, driven by talent development,
                                market agility, and operational excellence. Client-centricity, innovation, and trust are the pillars of our brand DNA.
                           </p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="{{route('our-culture')}}">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dash-container animate__animated animate__fadeIn animate__slower 200s" id="container7">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-12 mb-4 mb-lg-0" data-aos="fade-right">
                            <div class="overview-image bg-image pbg-shadow"
                                style="background-image: url({{ asset('images/investor-relations/cover.png') }})">
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-12" data-aos="fade-left">
                            <h4>Investor Relations</h4>
                            <p style="text-align: justify">Phoenix Beverages Group's business model ensures sustainable, long-term value, supported by a strong strategic foundation.
                                We are committed to transparent communication, delivering accurate financial information to our shareholders.
                            </p>
                            <div class="cta">
                                <div class="row">
                                    <div class="learnMore" >
                                        <a class="text-primary" href="{{route('investor-relations')}}">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="dash-controls">
                <div class="dash-control" data-target="container1" id="control1">
                    <span>Our Brands</span>
                </div>
                <div class="dash-control" data-target="container2" id="control2">
                    <span>Leadership</span>
                </div>
                <div class="dash-control" data-target="container3" id="control3">
                    <span>ESG</span>
                </div>
                <div class="dash-control" data-target="container4" id="control4">
                    <span>Innovations</span>
                </div>
                <div class="dash-control" data-target="container5" id="control5">
                    <span>Our Reach</span>
                </div>
                <div class="dash-control" data-target="container6" id="control6">
                    <span>Our Culture</span>
                </div>
                <div class="dash-control" data-target="container7" id="control7">
                    <span>Investor Relations</span>
                </div>
            </div>

        </div>
    </div>


    {{-- <div class="container">
        <div class="landing-overview">
            <div class="row">
                <div class="col-12">
                    <h4>Overview</h4>
                </div>
                <div class="col-7" data-aos="flip-left" data-aos-duration="1000" data-aos-easing="linear">
                    <div class="overview-image bg-image pbg-shadow"
                        style="background-image: url({{ asset('images/pbg-drinks.png') }})">

                    </div>
                </div>
                <div class="col-5" data-aos="flip-down" data-aos-duration="1000" data-aos-easing="linear">
                    <h4>Our brands</h4>
                    <p>Phoenix Beverages Group manufactures exceptional products from high quality natural ingredients. Our
                        team's resourcefulness and capacity to adapt have made some of these products become favourite local
                        brands, enjoyed by Mauritians and foreigners alike. Discover our full range of locally produced and
                        global brands.</p>
                    <div class="cta">
                        <div class="row">
                            <div class="col-7">
                                <div class="text-primary">Explore</div>
                            </div>
                            <div class="col-5">
                                <div class="row">
                                    <div class="col"><button class="button pbg-button-bg black-text"><span
                                                class="fa fa-arrow-left"></span></button></div>
                                    <div class="col"><button class="button pbg-button-bg black-text"><span
                                                class="fa fa-arrow-right"></span></button></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> --}}


    <div class="container landing-section">
        <div class="investors-corner">
            <div class="row">
                <div class="col-12">
                    <h4>Investor's Corner</h4>
                </div>
                <div class="col-lg-5 col-md-12 mb-4 mb-lg-0">
                    <a href="{{route('investor-relations')}}">
                    <div class="main-investor-box bg-image"
                        style="background-image: url({{ asset('images/homepage/investors_corner.png') }}); background-size: cover; background-position: center;" data-aos="fade-down"
                        data-aos-duration="700" data-aos-easing="linear">
                        <div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0, 0, 0, 0.3); z-index: 1;"></div>
                        <div class="row" style="position: relative; color: white; text-align: center; z-index: 2; padding: 20px;">
                            <div class="col-9">
                                <div class="box-title">
                                    <h5>Investor's Corner</h5>
                                    A Strategic Partner for Sustainable Growth
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="box-arrow"><span class="fa fa-arrow-right"></span></div>
                            </div>
                        </div>
                    </div>
                    </a>
                </div>
                <div class="col-lg-7 col-md-12">
                    <div class="row">
                        <div class="col-lg-6 col-md-6 col-sm-6 mb-3">
                            <a href="{{route('corporate-governance')}}">
                            <div class="investor-box overview-image pbg-shadow  bg-image" id="corporate-governance"
                                data-aos="fade-down" data-aos-duration="700" data-aos-easing="linear">
                                <div class="row">
                                    <div class="col-9">
                                        <div class="box-title">
                                            Corporate Governance
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="box-arrow"><span class="fa fa-arrow-right"></span></div>
                                    </div>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-6 mb-3">
                            <a href="{{route('holding-companies')}}">
                            <div class="investor-box overview-image pbg-shadow  bg-image" id="quaterly-financial"
                                data-aos="fade-down" data-aos-duration="700" data-aos-easing="linear">
                                <div class="row">
                                    <div class="col-9">
                                        <div class="box-title">Holding Companies </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="box-arrow"><span class="fa fa-arrow-right"></span></div>
                                    </div>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-6 mb-3">
                            <a href="{{route('integratedReport')}}">
                            <div class="investor-box overview-image pbg-shadow bg-image" id="annual-report"
                                data-aos="fade-down" data-aos-duration="700" data-aos-easing="linear">
                                <div class="row">
                                    <div class="col-9">
                                        <div class="box-title">Latest Annual <br>Report</div>
                                    </div>
                                    <div class="col-3">
                                        <div class="box-arrow"><span class="fa fa-arrow-right"></span></div>
                                    </div>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-6 mb-3">
                            <a href="{{route('shareholders')}}">
                            <div class="investor-box overview-image pbg-shadow bg-image" id="share-price"
                                data-aos="fade-down" data-aos-duration="700" data-aos-easing="linear">
                                <div class="row">
                                    <div class="col-9">
                                        <div class="box-title">Shareholder's Corner</div>
                                    </div>
                                    <div class="col-3">
                                        <div class="box-arrow"><span class="fa fa-arrow-right"></span></div>
                                    </div>
                                </div>
                            </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container landing-section">
        <div class="news-corner">
            <div class="row">
                <div class="col-12">
                    <h4>Latest News</h4>
                </div>


                @unless (empty($news))
                @foreach ($news as $newsData)

                <div class="col-12 col-lg-4" data-aos="fade-down" data-aos-duration="700" data-aos-easing="linear">
                    <div class="news-container">
                        <div class="news-image bg-image"
                        style="background-image: url({{ $newsData->image_url }})">
                            <div class="news-date">{{$newsData->date}}</div>
                            <div class="news-tag">{{$newsData->category}}</div>
                            <div class="news-title">
                                <h4>{{\Str::limit($newsData->title, 80, '...')}}</h4>
                            </div>
                            <div class="latestNewsDetails">
                                <h6>{!!  \Str::limit($newsData->body, 120, '...') !!}</h6>
                                <div class="learnMoreDash text-center mx-auto w-50" >
                                    <a class="" href="{{route('news.details',$newsData->id)}}">Read More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                @endforeach
                @else
                <i class="text-center smallest-text">No News to display </i>
                @endunless


                <!-- News Item 1 -->


                <!-- News Item 2 -->
                {{-- <div class="col-12 col-lg-4" data-aos="fade-down" data-aos-duration="800" data-aos-easing="linear">
                    <div class="news-container">
                        <div class="news-image bg-image pbg-radius" style="background-image: url({{ asset('images/homepage/news/sprit-clear.png') }})">
                            <div class="news-date">13 October, 2022</div>
                            <div class="news-tag">Business</div>
                            <div class="news-title">
                                <h4>Sprite: Bottles Go From Green To Clear For Easier Recycling.</h4>
                            </div>
                            <div class="latestNewsDetails">
                                <h6>Port-Louis, October 12, 2022: In line with its sustainability strategy called World Without Waste (WWW), Coca-Cola in Mauritius, with the support of its bottling partner Phoenix Beverages Limited...</h6>
                                <div class="learnMoreDash text-center mx-auto w-50" >
                                    <a class="" href="{{route('news.details',31)}}">Read More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> --}}

                <!-- News Item 3 -->
                {{-- <div class="col-12 col-lg-4" data-aos="fade-down" data-aos-duration="900" data-aos-easing="linear">
                    <div class="news-container">
                        <div class="news-image bg-image pbg-radius" style="background-image: url({{ asset('images/homepage/news/renaisenses-banner.png') }})">
                            <div class="news-date">01 July, 2022</div>
                            <div class="news-tag">Business</div>
                            <div class="news-title">
                                <h4>The Statue of the RenaiSenses: A breathtaking sculpture.</h4>
                            </div>
                            <div class="latestNewsDetails">
                                <h6>The result of the innovation highlighted through the execution of the Phoenix Beverages Group (PBG) sustainable development plan, the new Phoenix statue was born after more than three years of work...</h6>
                                <div class="learnMoreDash text-center mx-auto w-50" >
                                    <a class="" href="{{route('news.details',28)}}">Read More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> --}}

                <!-- News Item 4 -->
                {{-- <div class="col-12 col-lg-3" data-aos="zoom-in-up" data-aos-duration="1000" data-aos-easing="linear">
                    <div class="news-container">
                        <div class="news-image bg-image pbg-radius" style="background-image: url({{ asset('images/news-three.png') }})">
                            <div class="news-date">26 August, 2024</div>
                            <div class="news-tag">Business</div>
                            <div class="news-title">
                                <h4>Phoenix Beverages Group Expands its Footprint Over. </h4>
                            </div>
                            <div class="latestNewsDetails">
                                <h4 class="">As part of its commitment to reduce its carbon footprint.</h4>
                                <div class="latestReadMore text-center mx-auto w-50">
                                    <a class="" href="#">Read More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
     --}}
                <div class="news-see-more col-12">
                    <div class="learnMore" >
                        <a class="text-primary" href="{{route('news-room')}}">Explore</a>
                    </div>
                </div>
            </div>
        </div>
    </div>


    {{-- <section id="slider" class="slider-element slider-parallax revslider-wrap overflow-hidden">

    <!--
    #################################
        - THEMEPUNCH BANNER -
    #################################
    -->
    <div id="rev_slider_ishop_wrapper" class="rev_slider_wrapper fullwidth-container" data-alias="default-slider" style="padding:0px;">
            <!-- START REVOLUTION SLIDER 5.1.4 fullwidth mode -->
        <div id="rev_slider_ishop" class="rev_slider fullwidthbanner" style="display:none;" data-version="5.1.4">
            <ul>    <!-- SLIDE  -->
                <li data-transition="fade" data-slotamount="1" data-masterspeed="1500" data-delay="5000" data-saveperformance="off" data-title="Latest Collections" style="background-color: #F6F6F6;">
                    <!-- LAYERS -->

                    <!-- LAYER NR. 2 -->
                    <div class="tp-caption ltl tp-resizeme revo-slider-caps-text text-uppercase"
                    data-x="100"
                    data-y="50"
                    data-transform_in="x:-200;y:0;z:0;rotationZ:0;scaleX:1;scaleY:1;skewX:0;skewY:0;opacity:0;s:700;e:Power4.easeOutQuad;"
                    data-speed="400"
                    data-start="1000"
                    data-easing="easeOutQuad"
                    data-splitin="none"
                    data-splitout="none"
                    data-elementdelay="0.01"
                    data-endelementdelay="0.1"
                    data-endspeed="1000"
                    data-endeasing="Power4.easeIn"><img src="images/slider/rev/shop/girl1.jpg" alt="Girl"></div>

                    <div class="tp-caption ltl tp-resizeme revo-slider-caps-text text-uppercase"
                    data-x="570"
                    data-y="75"
                    data-transform_in="x:0;y:150;z:0;rotationZ:0;scaleX:1.3;scaleY:1;skewX:0;skewY:0;opacity:0;s:700;e:Power4.easeOutQuad;"
                    data-speed="700"
                    data-start="1000"
                    data-easing="easeOutQuad"
                    data-splitin="none"
                    data-splitout="none"
                    data-elementdelay="0.01"
                    data-endelementdelay="0.1"
                    data-endspeed="1000"
                    data-endeasing="Power4.easeIn" style=" color: #333;">Get your Shopping Bags Ready</div>

                    <div class="tp-caption ltl tp-resizeme revo-slider-emphasis-text p-0 border-0"
                    data-x="570"
                    data-y="105"
                    data-transform_in="x:0;y:150;z:0;rotationZ:0;scaleX:1.3;scaleY:1;skewX:0;skewY:0;opacity:0;s:700;e:Power4.easeOutQuad;"
                    data-speed="700"
                    data-start="1200"
                    data-easing="easeOutQuad"
                    data-splitin="none"
                    data-splitout="none"
                    data-elementdelay="0.01"
                    data-endelementdelay="0.1"
                    data-endspeed="1000"
                    data-endeasing="Power4.easeIn" style=" color: #333; max-width: 430px; line-height: 1.15;">Latest Fashion<br>Collections</div>

                    <div class="tp-caption ltl tp-resizeme revo-slider-desc-text text-start"
                    data-x="570"
                    data-y="275"
                    data-transform_in="x:0;y:150;z:0;rotationZ:0;scaleX:1.3;scaleY:1;skewX:0;skewY:0;opacity:0;s:700;e:Power4.easeOutQuad;"
                    data-speed="700"
                    data-start="1400"
                    data-easing="easeOutQuad"
                    data-splitin="none"
                    data-splitout="none"
                    data-elementdelay="0.01"
                    data-endelementdelay="0.1"
                    data-endspeed="1000"
                    data-endeasing="Power4.easeIn" style=" color: #333; max-width: 550px; white-space: normal;">We have created a Design that looks Awesome, performs Brilliantly &amp; senses Orientations.</div>

                    <div class="tp-caption ltl tp-resizeme"
                    data-x="570"
                    data-y="375"
                    data-transform_in="x:0;y:150;z:0;rotationZ:0;scaleX:1.3;scaleY:1;skewX:0;skewY:0;opacity:0;s:700;e:Power4.easeOutQuad;"
                    data-speed="700"
                    data-start="1550"
                    data-easing="easeOutQuad"
                    data-splitin="none"
                    data-splitout="none"
                    data-elementdelay="0.01"
                    data-endelementdelay="0.1"
                    data-endspeed="1000"
                    data-endeasing="Power4.easeIn"><a href="#" class="button button-border button-large button-rounded text-end m-0"><span>Start Shopping</span> <i class="uil uil-angle-right-b"></i></a></div>

                </li>
                <!-- SLIDE  -->
                <li data-transition="slideup" data-slotamount="1" data-masterspeed="1500" data-delay="5000"  data-saveperformance="off"  data-title="Messenger bags" style="background-color: #E9E8E3;">
                    <!-- LAYERS -->

                    <div class="tp-caption ltl tp-resizeme revo-slider-caps-text text-uppercase"
                    data-x="630"
                    data-y="78"
                    data-transform_in="x:250;y:0;z:0;rotationZ:0;scaleX:1;scaleY:1;skewX:0;skewY:0;opacity:0;s:400;e:Power4.easeOutQuad;"
                    data-speed="400"
                    data-start="1000"
                    data-easing="easeOutQuad"
                    data-splitin="none"
                    data-splitout="none"
                    data-elementdelay="0.01"
                    data-endelementdelay="0.1"
                    data-endspeed="1000"
                    data-endeasing="Power4.easeIn"><img src="images/slider/rev/shop/bag.png" alt="Bag"></div>

                    <!-- LAYER NR. 2 -->
                    <div class="tp-caption ltl tp-resizeme revo-slider-caps-text text-uppercase"
                    data-x="0"
                    data-y="110"
                    data-transform_in="x:0;y:150;z:0;rotationZ:0;scaleX:1.3;scaleY:1;skewX:0;skewY:0;opacity:0;s:700;e:Power4.easeOutQuad;"
                    data-speed="700"
                    data-start="1000"
                    data-easing="easeOutQuad"
                    data-splitin="none"
                    data-splitout="none"
                    data-elementdelay="0.01"
                    data-endelementdelay="0.1"
                    data-endspeed="1000"
                    data-endeasing="Power4.easeIn" style=" color: #333;">Buy Stylish Bags at Discounted Prices</div>

                    <div class="tp-caption ltl tp-resizeme revo-slider-emphasis-text p-0 border-0"
                    data-x="0"
                    data-y="140"
                    data-transform_in="x:0;y:150;z:0;rotationZ:0;scaleX:1.3;scaleY:1;skewX:0;skewY:0;opacity:0;s:700;e:Power4.easeOutQuad;"
                    data-speed="700"
                    data-start="1200"
                    data-easing="easeOutQuad"
                    data-splitin="none"
                    data-splitout="none"
                    data-elementdelay="0.01"
                    data-endelementdelay="0.1"
                    data-endspeed="1000"
                    data-endeasing="Power4.easeIn" style=" color: #333; line-height: 1.15;">Messenger Bags</div>

                    <div class="tp-caption ltl tp-resizeme revo-slider-desc-text text-start"
                    data-x="0"
                    data-y="240"
                    data-transform_in="x:0;y:150;z:0;rotationZ:0;scaleX:1.3;scaleY:1;skewX:0;skewY:0;opacity:0;s:700;e:Power4.easeOutQuad;"
                    data-speed="700"
                    data-start="1400"
                    data-easing="easeOutQuad"
                    data-splitin="none"
                    data-splitout="none"
                    data-elementdelay="0.01"
                    data-endelementdelay="0.1"
                    data-endspeed="1000"
                    data-endeasing="Power4.easeIn" style=" color: #333; max-width: 550px; white-space: normal;">Grantees insurmountable challenges invest protect, growth improving quality social entrepreneurship.</div>

                    <div class="tp-caption ltl tp-resizeme"
                    data-x="0"
                    data-y="340"
                    data-transform_in="x:0;y:150;z:0;rotationZ:0;scaleX:1.3;scaleY:1;skewX:0;skewY:0;opacity:0;s:700;e:Power4.easeOutQuad;"
                    data-speed="700"
                    data-start="1550"
                    data-easing="easeOutQuad"
                    data-splitin="none"
                    data-splitout="none"
                    data-elementdelay="0.01"
                    data-endelementdelay="0.1"
                    data-endspeed="1000"
                    data-endeasing="Power4.easeIn"><a href="#" class="button button-border button-large button-rounded text-end m-0"><span>Start Shopping</span> <i class="uil uil-angle-right-b"></i></a></div>

                    <div class="tp-caption utb tp-resizeme revo-slider-caps-text text-uppercase"
                    data-x="510"
                    data-y="0"
                    data-transform_in="x:0;y:-236;z:0;rotationZ:0;skewX:0;skewY:0;opacity:0;s:700;e:Power4.easeOutQuad;"
                    data-speed="600"
                    data-start="2100"
                    data-easing="easeOutQuad"
                    data-splitin="none"
                    data-splitout="none"
                    data-elementdelay="0.01"
                    data-endelementdelay="0.1"
                    data-endspeed="1000"
                    data-endeasing="Power4.easeIn"><img src="images/slider/rev/shop/tag.png" alt="Bag"></div>

                </li>
            </ul>
        </div>
    </div><!-- END REVOLUTION SLIDER -->

</section>

<!-- Content
============================================= -->
<section id="content">
    <div class="content-wrap">
        <div class="container">

            <div class="row align-items-stretch g-4 min-vh-60">
                <div class="col-md-8">

                    <div class="row align-items-stretch g-4 h-100">
                        <div class="col-md-6 min-vh-25 min-vh-md-0">
                            <a href="#" class="grid-inner d-block h-100">
                                <img src="images/shop/banners/2.jpg" alt="Image" class="w-100 h-100 object-cover rounded">
                            </a>
                        </div>

                        <div class="col-md-6 min-vh-25 min-vh-md-0">
                            <a href="#" class="grid-inner d-block h-100">
                                <img src="images/shop/banners/8.jpg" alt="Image" class="w-100 h-100 object-cover rounded">
                            </a>
                        </div>

                        <div class="col-md-12 min-vh-25 min-vh-md-0 pb-md-0">
                            <a href="#" class="grid-inner d-block h-100">
                                <img src="images/shop/banners/4.jpg" alt="Image" class="w-100 h-100 object-cover rounded">
                            </a>
                        </div>
                    </div>

                </div>

                <div class="col-md-4 min-vh-50">
                    <a href="#" class="grid-inner d-block h-100">
                        <img src="images/shop/banners/9.jpg" alt="Image" class="w-100 h-100 object-cover rounded">
                    </a>
                </div>
            </div>

            <div class="clear"></div>

            <div class="tabs mt-6">
                <ul class="nav canvas-tabs tabs nav-tabs justify-content-center mb-4" id="tab-3" role="tablist" style="--bs-nav-link-font-weight: 600;">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="canvas-home-tab" data-bs-toggle="pill" data-bs-target="#home2" type="button"
                            role="tab" aria-controls="canvas-home" aria-selected="true">New Arrivals</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="canvas-profile-tab" data-bs-toggle="pill" data-bs-target="#profile2" type="button"
                            role="tab" aria-controls="canvas-profile" aria-selected="false">Best sellers</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="canvas-contact-tab" data-bs-toggle="pill" data-bs-target="#contact2" type="button"
                            role="tab" aria-controls="canvas-contact" aria-selected="false">You may like</button>
                    </li>
                </ul>

                <div id="canvas-TabContent2" class="tab-content">
                    <div class="tab-pane fade show active" id="home2" role="tabpanel" aria-labelledby="canvas-home-tab" tabindex="0">

                        <div class="shop row gutter-30">

                            <div class="product col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="grid-inner">
                                    <div class="product-image">
                                        <a href="#"><img src="images/shop/dress/1.jpg" alt="Checked Short Dress"></a>
                                        <a href="#"><img src="images/shop/dress/1-1.jpg" alt="Checked Short Dress"></a>
                                        <div class="sale-flash badge bg-success p-2">50% Off*</div>
                                        <div class="bg-overlay">
                                            <div class="bg-overlay-content align-items-end justify-content-between" data-hover-animate="fadeIn" data-hover-speed="400">
                                                <a href="#" class="btn btn-dark me-2" title="Add to Cart"><i class="bi-bag-plus"></i></a>
                                                <a href="include/ajax/shop-item.html" class="btn btn-dark" data-lightbox="ajax" title="Quick View"><i class="bi-eye"></i></a>
                                            </div>
                                            <div class="bg-overlay-bg bg-transparent"></div>
                                        </div>
                                    </div>
                                    <div class="product-desc">
                                        <div class="product-title"><h3><a href="#">Checked Short Dress</a></h3></div>
                                        <div class="product-price"><del>$24.99</del> <ins>$12.49</ins></div>
                                        <div class="product-rating">
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-half"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="product col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="grid-inner">
                                    <div class="product-image">
                                        <a href="#"><img src="images/shop/pants/1-1.jpg" alt="Slim Fit Chinos"></a>
                                        <a href="#"><img src="images/shop/pants/1.jpg" alt="Slim Fit Chinos"></a>
                                        <div class="bg-overlay">
                                            <div class="bg-overlay-content align-items-end justify-content-between" data-hover-animate="fadeIn" data-hover-speed="400">
                                                <a href="#" class="btn btn-dark me-2" title="Add to Cart"><i class="bi-bag-plus"></i></a>
                                                <a href="include/ajax/shop-item.html" class="btn btn-dark" data-lightbox="ajax" title="Quick View"><i class="bi-eye"></i></a>
                                            </div>
                                            <div class="bg-overlay-bg bg-transparent"></div>
                                        </div>
                                    </div>
                                    <div class="product-desc">
                                        <div class="product-title"><h3><a href="#">Slim Fit Chinos</a></h3></div>
                                        <div class="product-price">$39.99</div>
                                        <div class="product-rating">
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-half"></i>
                                            <i class="bi-star"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="product col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="grid-inner">
                                    <div class="product-image">
                                        <div class="fslider" data-arrows="false">
                                            <div class="flexslider">
                                                <div class="slider-wrap">
                                                    <div class="slide"><a href="#"><img src="images/shop/shoes/1.jpg" alt="Dark Brown Boots"></a></div>
                                                    <div class="slide"><a href="#"><img src="images/shop/shoes/1-1.jpg" alt="Dark Brown Boots"></a></div>
                                                    <div class="slide"><a href="#"><img src="images/shop/shoes/1-2.jpg" alt="Dark Brown Boots"></a></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="bg-overlay">
                                            <div class="bg-overlay-content align-items-end justify-content-between" data-hover-animate="fadeIn" data-hover-speed="400">
                                                <a href="#" class="btn btn-dark me-2" title="Add to Cart"><i class="bi-bag-plus"></i></a>
                                                <a href="include/ajax/shop-item.html" class="btn btn-dark" data-lightbox="ajax" title="Quick View"><i class="bi-eye"></i></a>
                                            </div>
                                            <div class="bg-overlay-bg bg-transparent"></div>
                                        </div>
                                    </div>
                                    <div class="product-desc">
                                        <div class="product-title"><h3><a href="#">Dark Brown Boots</a></h3></div>
                                        <div class="product-price">$49</div>
                                        <div class="product-rating">
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star"></i>
                                            <i class="bi-star"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="product col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="grid-inner">
                                    <div class="product-image">
                                        <a href="#"><img src="images/shop/dress/2.jpg" alt="Light Blue Denim Dress"></a>
                                        <a href="#"><img src="images/shop/dress/2-2.jpg" alt="Light Blue Denim Dress"></a>
                                        <div class="bg-overlay">
                                            <div class="bg-overlay-content align-items-end justify-content-between" data-hover-animate="fadeIn" data-hover-speed="400">
                                                <a href="#" class="btn btn-dark me-2" title="Add to Cart"><i class="bi-bag-plus"></i></a>
                                                <a href="include/ajax/shop-item.html" class="btn btn-dark" data-lightbox="ajax" title="Quick View"><i class="bi-eye"></i></a>
                                            </div>
                                            <div class="bg-overlay-bg bg-transparent"></div>
                                        </div>
                                    </div>
                                    <div class="product-desc">
                                        <div class="product-title"><h3><a href="#">Light Blue Denim Dress</a></h3></div>
                                        <div class="product-price">$19.95</div>
                                        <div class="product-rating">
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="tab-pane fade" id="profile2" role="tabpanel" aria-labelledby="canvas-profile-tab" tabindex="0">

                        <div class="shop row gutter-30">

                            <div class="product col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="grid-inner">
                                    <div class="product-image">
                                        <a href="#"><img src="images/shop/sunglasses/1.jpg" alt="Unisex Sunglasses"></a>
                                        <a href="#"><img src="images/shop/sunglasses/1-1.jpg" alt="Unisex Sunglasses"></a>
                                        <div class="sale-flash badge bg-danger p-2">Sale!</div>
                                        <div class="bg-overlay">
                                            <div class="bg-overlay-content align-items-end justify-content-between" data-hover-animate="fadeIn" data-hover-speed="400">
                                                <a href="#" class="btn btn-dark me-2" title="Add to Cart"><i class="bi-bag-plus"></i></a>
                                                <a href="include/ajax/shop-item.html" class="btn btn-dark" data-lightbox="ajax" title="Quick View"><i class="bi-eye"></i></a>
                                            </div>
                                            <div class="bg-overlay-bg bg-transparent"></div>
                                        </div>
                                    </div>
                                    <div class="product-desc">
                                        <div class="product-title"><h3><a href="#">Unisex Sunglasses</a></h3></div>
                                        <div class="product-price"><del>$19.99</del> <ins>$11.99</ins></div>
                                        <div class="product-rating">
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star"></i>
                                            <i class="bi-star"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="product col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="grid-inner">
                                    <div class="product-image">
                                        <a href="#"><img src="images/shop/tshirts/1.jpg" alt="Blue Round-Neck Tshirt"></a>
                                        <a href="#"><img src="images/shop/tshirts/1-1.jpg" alt="Blue Round-Neck Tshirt"></a>
                                        <div class="bg-overlay">
                                            <div class="bg-overlay-content align-items-end justify-content-between" data-hover-animate="fadeIn" data-hover-speed="400">
                                                <a href="#" class="btn btn-dark me-2" title="Add to Cart"><i class="bi-bag-plus"></i></a>
                                                <a href="include/ajax/shop-item.html" class="btn btn-dark" data-lightbox="ajax" title="Quick View"><i class="bi-eye"></i></a>
                                            </div>
                                            <div class="bg-overlay-bg bg-transparent"></div>
                                        </div>
                                    </div>
                                    <div class="product-desc">
                                        <div class="product-title"><h3><a href="#">Blue Round-Neck Tshirt</a></h3></div>
                                        <div class="product-price">$9.99</div>
                                        <div class="product-rating">
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-half"></i>
                                            <i class="bi-star"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="product col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="grid-inner">
                                    <div class="product-image">
                                        <a href="#"><img src="images/shop/watches/1.jpg" alt="Silver Chrome Watch"></a>
                                        <a href="#"><img src="images/shop/watches/1-1.jpg" alt="Silver Chrome Watch"></a>
                                        <div class="bg-overlay">
                                            <div class="bg-overlay-content align-items-end justify-content-between" data-hover-animate="fadeIn" data-hover-speed="400">
                                                <a href="#" class="btn btn-dark me-2" title="Add to Cart"><i class="bi-bag-plus"></i></a>
                                                <a href="include/ajax/shop-item.html" class="btn btn-dark" data-lightbox="ajax" title="Quick View"><i class="bi-eye"></i></a>
                                            </div>
                                            <div class="bg-overlay-bg bg-transparent"></div>
                                        </div>
                                    </div>
                                    <div class="product-desc">
                                        <div class="product-title"><h3><a href="#">Silver Chrome Watch</a></h3></div>
                                        <div class="product-price">$129.99</div>
                                        <div class="product-rating">
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-half"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="product col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="grid-inner">
                                    <div class="product-image">
                                        <a href="#"><img src="images/shop/shoes/2.jpg" alt="Men Grey Casual Shoes"></a>
                                        <a href="#"><img src="images/shop/shoes/2-1.jpg" alt="Men Grey Casual Shoes"></a>
                                        <div class="sale-flash badge bg-danger p-2">Sale!</div>
                                        <div class="bg-overlay">
                                            <div class="bg-overlay-content align-items-end justify-content-between" data-hover-animate="fadeIn" data-hover-speed="400">
                                                <a href="#" class="btn btn-dark me-2" title="Add to Cart"><i class="bi-bag-plus"></i></a>
                                                <a href="include/ajax/shop-item.html" class="btn btn-dark" data-lightbox="ajax" title="Quick View"><i class="bi-eye"></i></a>
                                            </div>
                                            <div class="bg-overlay-bg bg-transparent"></div>
                                        </div>
                                    </div>
                                    <div class="product-desc">
                                        <div class="product-title"><h3><a href="#">Men Grey Casual Shoes</a></h3></div>
                                        <div class="product-price"><del>$45.99</del> <ins>$39.49</ins></div>
                                        <div class="product-rating">
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-half"></i>
                                            <i class="bi-star"></i>
                                            <i class="bi-star"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="tab-pane fade" id="contact2" role="tabpanel" aria-labelledby="canvas-contact-tab" tabindex="0">

                        <div class="shop row gutter-30">

                            <div class="product col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="grid-inner">
                                    <div class="product-image">
                                        <div class="fslider" data-arrows="false">
                                            <div class="flexslider">
                                                <div class="slider-wrap">
                                                    <div class="slide"><a href="#"><img src="images/shop/dress/3.jpg" alt="Pink Printed Dress"></a></div>
                                                    <div class="slide"><a href="#"><img src="images/shop/dress/3-1.jpg" alt="Pink Printed Dress"></a></div>
                                                    <div class="slide"><a href="#"><img src="images/shop/dress/3-2.jpg" alt="Pink Printed Dress"></a></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="bg-overlay">
                                            <div class="bg-overlay-content align-items-end justify-content-between" data-hover-animate="fadeIn" data-hover-speed="400">
                                                <a href="#" class="btn btn-dark me-2" title="Add to Cart"><i class="bi-bag-plus"></i></a>
                                                <a href="include/ajax/shop-item.html" class="btn btn-dark" data-lightbox="ajax" title="Quick View"><i class="bi-eye"></i></a>
                                            </div>
                                            <div class="bg-overlay-bg bg-transparent"></div>
                                        </div>
                                    </div>
                                    <div class="product-desc">
                                        <div class="product-title"><h3><a href="#">Pink Printed Dress</a></h3></div>
                                        <div class="product-price">$39.49</div>
                                        <div class="product-rating">
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star"></i>
                                            <i class="bi-star"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="product col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="grid-inner">
                                    <div class="product-image">
                                        <a href="#"><img src="images/shop/pants/5.jpg" alt="Green Trousers"></a>
                                        <a href="#"><img src="images/shop/pants/5-1.jpg" alt="Green Trousers"></a>
                                        <div class="sale-flash badge bg-danger p-2">Sale!</div>
                                        <div class="bg-overlay">
                                            <div class="bg-overlay-content align-items-end justify-content-between" data-hover-animate="fadeIn" data-hover-speed="400">
                                                <a href="#" class="btn btn-dark me-2" title="Add to Cart"><i class="bi-bag-plus"></i></a>
                                                <a href="include/ajax/shop-item.html" class="btn btn-dark" data-lightbox="ajax" title="Quick View"><i class="bi-eye"></i></a>
                                            </div>
                                            <div class="bg-overlay-bg bg-transparent"></div>
                                        </div>
                                    </div>
                                    <div class="product-desc">
                                        <div class="product-title"><h3><a href="#">Green Trousers</a></h3></div>
                                        <div class="product-price"><del>$24.99</del> <ins>$21.99</ins></div>
                                        <div class="product-rating">
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-half"></i>
                                            <i class="bi-star"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="product col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="grid-inner">
                                    <div class="product-image">
                                        <a href="#"><img src="images/shop/sunglasses/2.jpg" alt="Men Aviator Sunglasses"></a>
                                        <a href="#"><img src="images/shop/sunglasses/2-1.jpg" alt="Men Aviator Sunglasses"></a>
                                        <div class="bg-overlay">
                                            <div class="bg-overlay-content align-items-end justify-content-between" data-hover-animate="fadeIn" data-hover-speed="400">
                                                <a href="#" class="btn btn-dark me-2" title="Add to Cart"><i class="bi-bag-plus"></i></a>
                                                <a href="include/ajax/shop-item.html" class="btn btn-dark" data-lightbox="ajax" title="Quick View"><i class="bi-eye"></i></a>
                                            </div>
                                            <div class="bg-overlay-bg bg-transparent"></div>
                                        </div>
                                    </div>
                                    <div class="product-desc">
                                        <div class="product-title"><h3><a href="#">Men Aviator Sunglasses</a></h3></div>
                                        <div class="product-price">$13.49</div>
                                        <div class="product-rating">
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="product col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="grid-inner">
                                    <div class="product-image">
                                        <a href="#"><img src="images/shop/tshirts/4.jpg" alt="Black Polo Tshirt"></a>
                                        <a href="#"><img src="images/shop/tshirts/4-1.jpg" alt="Black Polo Tshirt"></a>
                                        <div class="bg-overlay">
                                            <div class="bg-overlay-content align-items-end justify-content-between" data-hover-animate="fadeIn" data-hover-speed="400">
                                                <a href="#" class="btn btn-dark me-2" title="Add to Cart"><i class="bi-bag-plus"></i></a>
                                                <a href="include/ajax/shop-item.html" class="btn btn-dark" data-lightbox="ajax" title="Quick View"><i class="bi-eye"></i></a>
                                            </div>
                                            <div class="bg-overlay-bg bg-transparent"></div>
                                        </div>
                                    </div>
                                    <div class="product-desc">
                                        <div class="product-title"><h3><a href="#">Black Polo Tshirt</a></h3></div>
                                        <div class="product-price">$11.49</div>
                                        <div class="product-rating">
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                            <i class="bi-star-fill"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="clear mb-4"></div>

            <div class="row justify-content-center col-mb-50 mb-0">
                <div class="col-sm-6 col-lg-4">
                    <div class="fancy-title title-border">
                        <h4>About Us</h4>
                    </div>
                    <p>Jane Jacobs educate, leverage affiliate Martin Luther King Jr. agriculture conflict resolution dignity. Cooperation international progress non-partisan lasting change meaningful.</p>
                </div>

                <div class="col-sm-6 col-lg-4 subscribe-widget">
                    <div class="fancy-title title-border">
                        <h4>Subscribe for Offers</h4>
                    </div>
                    <p>Subscribe to Our Newsletter to get Important News, Amazing Offers &amp; Inside Scoops:</p>
                    <div class="widget-subscribe-form-result"></div>
                    <form id="widget-subscribe-form2" action="include/subscribe.php" method="post" class="mb-0">
                        <div class="input-group mx-auto">
                            <div class="input-group-text"><i class="bi-envelope-plus"></i></div>
                            <input type="email" name="widget-subscribe-form-email" class="form-control required email" placeholder="Enter your Email">
                            <button class="btn btn-secondary" type="submit">Subscribe</button>
                        </div>
                    </form>
                </div>

                <div class="col-sm-6 col-lg-4">
                    <div class="fancy-title title-border">
                        <h4>Connect with Us</h4>
                    </div>

                    <div class="d-flex flex-wrap" style="--cnvs-socialicon-gap-y:5px;">
                        <a href="#" class="social-icon h-bg-facebook" data-bs-toggle="tooltip" data-bs-placement="top" title="Facebook">
                            <i class="fa-brands fa-facebook-f"></i>
                            <i class="fa-brands fa-facebook-f"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-delicious" data-bs-toggle="tooltip" data-bs-placement="top" title="Delicious">
                            <i class="fa-brands fa-delicious"></i>
                            <i class="fa-brands fa-delicious"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-paypal" data-bs-toggle="tooltip" data-bs-placement="top" title="PayPal">
                            <i class="fa-brands fa-paypal"></i>
                            <i class="fa-brands fa-paypal"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-waze" data-bs-toggle="tooltip" data-bs-placement="top" title="Flattr">
                            <i class="fa-brands fa-waze"></i>
                            <i class="fa-brands fa-waze"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-android" data-bs-toggle="tooltip" data-bs-placement="top" title="Android">
                            <i class="fa-brands fa-android"></i>
                            <i class="fa-brands fa-android"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-discord" data-bs-toggle="tooltip" data-bs-placement="top" title="Smashing Magazine">
                            <i class="fa-brands fa-discord"></i>
                            <i class="fa-brands fa-discord"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-google" data-bs-toggle="tooltip" data-bs-placement="top" title="Google+">
                            <i class="fa-brands fa-google"></i>
                            <i class="fa-brands fa-google"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-wikipedia" data-bs-toggle="tooltip" data-bs-placement="top" title="Wikipedia">
                            <i class="fa-brands fa-wikipedia-w"></i>
                            <i class="fa-brands fa-wikipedia-w"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-stumbleupon" data-bs-toggle="tooltip" data-bs-placement="top" title="StumbleUpon">
                            <i class="fa-brands fa-stumbleupon"></i>
                            <i class="fa-brands fa-stumbleupon"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-foursquare" data-bs-toggle="tooltip" data-bs-placement="top" title="FourSquare">
                            <i class="fa-brands fa-foursquare"></i>
                            <i class="fa-brands fa-foursquare"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-call" data-bs-toggle="tooltip" data-bs-placement="top" title="Call">
                            <i class="fa-solid fa-phone"></i>
                            <i class="fa-solid fa-phone"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-twitch" data-bs-toggle="tooltip" data-bs-placement="top" title="Twitch">
                            <i class="fa-brands fa-twitch"></i>
                            <i class="fa-brands fa-twitch"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-forrst" data-bs-toggle="tooltip" data-bs-placement="top" title="Forrst">
                            <i class="fa-solid fa-tree"></i>
                            <i class="fa-solid fa-tree"></i>
                        </a>

                        <a href="#" class="social-icon h-bg-digg" data-bs-toggle="tooltip" data-bs-placement="top" title="Digg">
                            <i class="fa-brands fa-digg"></i>
                            <i class="fa-brands fa-digg"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="clear"></div>

            <div class="fancy-title title-border title-center mt-4">
                <h4>Popular Brands</h4>
            </div>

            <ul class="clients-grid row row-cols-2 row-cols-sm-3 row-cols-md-6 mb-0">
                <li class="grid-item"><a href="#"><img src="images/clients/logo/1.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/2.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/3.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/4.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/5.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/6.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/7.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/8.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/9.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/10.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/11.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/12.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/13.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/14.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/15.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/16.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/19.png" alt="Clients"></a></li>
                <li class="grid-item"><a href="#"><img src="images/clients/logo/18.png" alt="Clients"></a></li>
            </ul>

        </div>

        <div class="section mb-0">
            <div class="container">

                <div class="row col-mb-50">
                    <div class="col-sm-6 col-lg-3">
                        <div class="feature-box fbox-plain fbox-dark fbox-sm">
                            <div class="fbox-icon">
                                <i class="bi-hand-thumbs-up"></i>
                            </div>
                            <div class="fbox-content">
                                <h3>100% Original</h3>
                                <p class="mt-0">We guarantee you the sale of Original Brands.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-6 col-lg-3">
                        <div class="feature-box fbox-plain fbox-dark fbox-sm">
                            <div class="fbox-icon">
                                <i class="bi-credit-card"></i>
                            </div>
                            <div class="fbox-content">
                                <h3>Payment Options</h3>
                                <p class="mt-0">We accept Visa, MasterCard and American Express.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-6 col-lg-3">
                        <div class="feature-box fbox-plain fbox-dark fbox-sm">
                            <div class="fbox-icon">
                                <i class="bi-truck"></i>
                            </div>
                            <div class="fbox-content">
                                <h3>Free Shipping</h3>
                                <p class="mt-0">Free Delivery to 100+ Locations on orders above $40.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-6 col-lg-3">
                        <div class="feature-box fbox-plain fbox-dark fbox-sm">
                            <div class="fbox-icon">
                                <i class="bi-arrow-counterclockwise"></i>
                            </div>
                            <div class="fbox-content">
                                <h3>30-Days Returns</h3>
                                <p class="mt-0">Return or exchange items purchased within 30 days.</p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <div class="section border-top-0 border-bottom-0 mb-0 p-0 bg-transparent footer-stick">
            <div class="container">

                <div class="row col-mb-50">
                    <div class="col-md-6 d-none d-md-flex align-self-end">
                        <img src="images/services/4.jpg" alt="Image" class="mb-0">
                    </div>

                    <div class="col-md-6 mb-5 subscribe-widget">
                        <div class="heading-block">
                            <h3><strong>GET 20% OFF*</strong></h3>
                            <span>Our App scales beautifully to different Devices.</span>
                        </div>

                        <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Eveniet cumque, perferendis accusamus porro illo exercitationem molestias.</p>

                        <div class="widget-subscribe-form-result"></div>
                        <form id="widget-subscribe-form3" action="include/subscribe.php" method="post" class="mb-0">
                            <div class="input-group" style="max-width:400px;">
                                <div class="input-group-text"><i class="bi-envelope-plus"></i></div>
                                <input type="email" name="widget-subscribe-form-email" class="form-control required email" placeholder="Enter your Email">
                                <button class="btn btn-danger" type="submit">Subscribe Now</button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section><!-- #content end --> --}}


{{--
<div class="hero-content">
    <div class="left-hero-content hero-text">
        <h4>Thirst For The Best.</h4>
        <p>Phoenix Beverages Group (PBG) is known for producing innovative beverages to enhance meaningful moments
            to its consumers. At PBG, we strive to offer a wide selection of alcoholic and non-alcoholic products,
            including beers, wines and spirits, soft drinks, table water and other beverages to our customers.</p>

        <p>All our products are made from high quality natural ingredients and are distributed all over Mauritius
            and internationally.</p>
        <div class="cta">
            <button class="button pbg-button pbg-shadow">Explore</button>
        </div>
    </div>
    <div class="right-hero-content">
        <div class="slider">
            <div class="dashSlides">
                <div class="dashSlide active animate__animated animate__fadeIn animate__slower	3s">
                    <img src="{{ asset('images/homepage/pbg-phoenix-beer-thirst-for-best-logo-changed.png') }}" class="bg-image"  alt="hero-slider">
                </div>
                <div class="dashSlide  animate__animated animate__fadeIn animate__slower	3s">
                    <img src="{{ asset('images/homepage/pbg-foster-brand-slider.png') }}" class="bg-image" alt="pbg-foster-brand-slider">
                </div>
                <div class="dashSlide  animate__animated animate__fadeIn animate__slower	3s">
                    <img src="{{ asset('images/homepage/pbg-innovation-slider.png') }}" class="bg-image" alt="pbg-innovation-slider">
                </div>
                <div class="dashSlide  animate__animated animate__fadeIn animate__slower	3s">
                    <img src="{{ asset('images/homepage/pbg-manawa-beer-slider.png') }}" class="bg-image" alt="pbg-manawa-beer-slider">
                </div>
                <div class="dashSlide  animate__animated animate__fadeIn animate__slower	3s">
                    <img src="{{ asset('images/homepage/pbg-our-reach-map-slider.png') }}" class="bg-image" alt="pbg-our-reach-map-slider">
                </div>
                <div class="dashSlide  animate__animated animate__fadeIn animate__slower	3s">
                    <img src="{{ asset('images/homepage/pbg-phoenix-earth-sdg-slider.png') }}" class="bg-image" alt="pbg-phoenix-earth-sdg-slider">
                </div>
                <div class="dashSlide  animate__animated animate__fadeIn animate__slower	3s">
                    <img src="{{ asset('images/homepage/virtual-tour-brewery-01.png') }}"  class="bg-image" alt="virtual-tour-brewery-01">
                </div>
            </div>
            <button class="dashPrev">&#10094;</button>
            <button class="dashNext">&#10095;</button>
            <div class="indicators">
                <span class="indicator active" onclick="currentSlide(0)"></span>
                <span class="indicator" onclick="currentSlide(1)"></span>
                <span class="indicator" onclick="currentSlide(2)"></span>
                <span class="indicator" onclick="currentSlide(3)"></span>
                <span class="indicator" onclick="currentSlide(4)"></span>
                <span class="indicator" onclick="currentSlide(5)"></span>
                <span class="indicator" onclick="currentSlide(6)"></span>
            </div>
        </div>

    </div>

</div>
</div> --}}


@stop

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Mobile Hero Slider Functions
    let currentMobileSlideIndex = 0;
    const mobileSlides = document.querySelectorAll('.mobile-hero-slide');
    const mobileIndicators = document.querySelectorAll('.mobile-indicator');

    function currentMobileSlide(n) {
        // Hide all slides
        mobileSlides.forEach(slide => {
            slide.classList.remove('active');
        });

        // Remove active class from all indicators
        mobileIndicators.forEach(indicator => {
            indicator.classList.remove('active');
        });

        // Show current slide and activate indicator
        if (mobileSlides[n]) {
            mobileSlides[n].classList.add('active');
        }
        if (mobileIndicators[n]) {
            mobileIndicators[n].classList.add('active');
        }

        currentMobileSlideIndex = n;
    }

    // Auto-advance mobile slider
    function autoAdvanceMobileSlider() {
        if (mobileSlides.length > 0) {
            currentMobileSlideIndex = (currentMobileSlideIndex + 1) % mobileSlides.length;
            currentMobileSlide(currentMobileSlideIndex);
        }
    }

    // Add click event listeners to indicators
    mobileIndicators.forEach((indicator, index) => {
        indicator.addEventListener('click', function() {
            currentMobileSlide(index);
        });
    });

    // Start auto-advance for mobile slider
    if (mobileSlides.length > 1) {
        setInterval(autoAdvanceMobileSlider, 5000); // Change slide every 5 seconds
    }

    // Video Functions
    const video = document.getElementById('landing-video');
    const videoOverlay = document.querySelector('.landing-video-overlay');
    const playBtn = document.getElementById('play-btn');
    const pauseBtn = document.getElementById('pause-btn');


    if (playBtn && video) {
        playBtn.addEventListener('click', function() {
            console.log('Play button clicked');

            // Show video and hide overlay
            video.style.display = 'block';
            video.classList.add('playing');
            if (videoOverlay) {
                videoOverlay.classList.add('hidden');
            }

            // Hide play button, show pause button
            playBtn.style.display = 'none';
            pauseBtn.style.display = 'block';

            // Play video
            video.play().then(function() {
                console.log('Video started playing');
            }).catch(function(error) {
                console.error('Error playing video:', error);
            });
        });
    }

    if (pauseBtn && video) {
        pauseBtn.addEventListener('click', function() {
            console.log('Pause button clicked');

            // Pause video
            video.pause();
            video.classList.remove('playing');
            if (videoOverlay) {
                videoOverlay.classList.remove('hidden');
            }

            // Show play button, hide pause button
            playBtn.style.display = 'block';
            pauseBtn.style.display = 'none';
        });
    }

    // Handle video end
    if (video) {
        video.addEventListener('ended', function() {
            console.log('Video ended');
            video.style.display = 'none';
            video.classList.remove('playing');
            if (videoOverlay) {
                videoOverlay.classList.remove('hidden');
            }

            // Show play button, hide pause button
            playBtn.style.display = 'block';
            pauseBtn.style.display = 'none';
        });

        // Add click to pause functionality
        video.addEventListener('click', function() {
            if (!video.paused) {
                console.log('Video clicked to pause');
                video.pause();
                video.classList.remove('playing');
                if (videoOverlay) {
                    videoOverlay.classList.remove('hidden');
                }

                // Show play button, hide pause button
                playBtn.style.display = 'block';
                pauseBtn.style.display = 'none';
            }
        });

        // Add error handling
        video.addEventListener('error', function(e) {
            console.error('Video error:', e);
        });

        // Add load event to check if video loads properly
        video.addEventListener('loadeddata', function() {
            console.log('Video data loaded successfully');
        });

        video.addEventListener('loadstart', function() {
            console.log('Video loading started');
        });
    }

    // OVERVIEW SLIDER WITH DASH-CONTROLS (manual navigation only)
    const overviewSlides = document.querySelectorAll('.dash-container');
    const dashControls = document.querySelectorAll('.dash-control');
    let currentOverviewIndex = 0;

    function showOverviewSlide(index) {
        // Hide all slides
        overviewSlides.forEach((slide, i) => {
            if (i === index) {
                slide.classList.add('active');
            } else {
                slide.classList.remove('active');
            }
        });

        // Update dash controls
        dashControls.forEach((control, i) => {
            if (i === index) {
                control.classList.add('active');
            } else {
                control.classList.remove('active');
            }
        });

        currentOverviewIndex = index;
    }

    // Add click event listeners to dash controls
    dashControls.forEach((control, index) => {
        control.addEventListener('click', function() {
            showOverviewSlide(index);
        });
    });

    // Initialize first slide as active
    if (overviewSlides.length > 0) {
        showOverviewSlide(0);
    }
});
</script>
@endsection
