@extends('layouts.report')

@section('title', 'Phoenix Beverages Group - Integrated Report '. $year)

@section('content')
    <div class="page-blue ireport">
        <div class="row">
            <div class="col-lg-6 col-md-12">
                <div class="mx-auto justify-content-center align-items-center hero-content-desktop"
                    style="padding:120px 0px 0px 150px; width:80%;">
                    <h3 class="fw-bold">Phoenix Beverages Limited Integrated Report {{ $year }}</h3>
                    <p class="smaller-text">This Integrated Report provides information about the strategy, activities
                        and performance of
                        Phoenix Beverages Limited (PhoenixBev or the Group) for the twelve months from 1 July 2024 to 30
                        June {{ $year }}.
                        <br></br>
                        It is structured around the matters most material to the Group's ability to create value in the
                        short-,
                        medium- and longterm.
                        The activities of our operations in Mauritius and Réunion Island are included in the reporting
                        boundary..
                    </p>
                    <div class="cta d-flex align-items-center gap-3 flex-wrap" style="display: flex !important; align-items: center !important; gap: 1rem !important;">
                        <a href="@pdfViewerUrl(asset('Reports/PhoenixBev/pbl_annual_reports/2025/PBL_IR 2025.pdf'), 'PBL Integrated Report 2025', route('integratedReport', $year))" >
                            <button class="button pbg-button pbg-shadow-dash">View 2025 Integrated Report</button>
                        </a>
                        <div class="learnMore" style="display: block !important; visibility: visible !important;">
                            <a href="{{ asset('Reports/PhoenixBev/pbl_annual_reports/2025/PBL_IR 2025.pdf') }}" class="smaller-text" download="PBL_IR 2025.pdf" target="_blank" style="display: inline-block !important; visibility: visible !important;">
                                Download 2025 Report
                            </a>
                        </div>
                    </div>

                    {{-- <div class="learnMore text-right my-4">
                                <a href="{{ asset('Reports/PhoenixBev/pbl_annual_reports/2025/PBL_IR 2025.pdf') }}" class="smaller-text" download="PBL_IR 2025.pdf" target="_blank">
                                    Download 2025 Report
                                </a>
                            </div> --}}
                </div>

                <!-- Mobile Hero Content -->
                <div class="hero-content-mobile d-lg-none">
                    <div class="container">
                        <div class="text-center">
                            <h3 class="fw-bold mb-3">Integrated Report <br> {{ $year }}</h3>
                            <p class="smaller-text mb-4">This Integrated Report provides information about the strategy, activities
                                and performance of Phoenix Beverages Limited (PhoenixBev or the Group) for the twelve months from 1 July 2024 to 30
                                June {{ $year }}. It is structured around the matters most material to the Group's ability to create value in the
                                short-, medium- and longterm. The activities of our operations in Mauritius and Réunion Island are included in the reporting
                                boundary.</p>
                            <div class="cta d-flex align-items-center justify-content-center gap-3 flex-wrap" style="display: flex !important; align-items: center !important; justify-content: center !important; gap: 1rem !important;">
                                <a href="@pdfViewerUrl(asset('Reports/PhoenixBev/pbl_annual_reports/2025/PBL_IR 2025.pdf'), 'PBL Integrated Report 2025', route('integratedReport', $year))" >
                                    <button class="button pbg-button pbg-shadow-dash">View 2025 Integrated Report</button>
                                </a>
                                <div class="learnMore" style="display: block !important; visibility: visible !important;">
                                    <a href="{{ asset('Reports/PhoenixBev/pbl_annual_reports/2025/PBL_IR 2025.pdf') }}" class="smaller-text" download="PBL_IR 2025.pdf" target="_blank" style="display: inline-block !important; visibility: visible !important;">
                                        Download 2025 Report
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-12">
                <img src="{{ asset('images/investor-relations/reports/PBL_IR 2025_cover.png') }}" alt="integrated report"
                    class="responsive-image" />
            </div>
        </div>
    </div>

    <div class="ir-section" id="finance-at-a-glance">
        <div class="container w-75 mx-auto">
            <h3 class="py-5 text-center" data-aos="fade-down" data-aos-duration="500" data-aos-easing="linear">FINANCIAL HIGHLIGHTS</h3>
            <div class="row pb-6 text-center financial-performance-grid">
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="150" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">TURNOVER </h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/ph_coin.png') }}" alt="ph_coin" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR </span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="13400"
                                        data-speed="10000">13.4</span> <span class="fs-4">Bn</span>
                                    <span class="green-caret">
                                        <img src="{{ asset('icons/Vector_7.png') }}" alt="caret-up"> 10.1%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="200" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">OPERATING PROFIT</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/fluent_money-20-regular.png') }}" alt="money" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR </span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="1200"
                                        data-speed="10000">1.2</span>
                                    <span class="fs-4">Bn </span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down"> 13.0%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="250" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">NET PROFIT AFTER TAX</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/fluent_coin-stack-24-regular.png') }}"
                                        alt="coin_stack" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="804"
                                        data-speed="10000">804</span> <span class="fs-4">M</span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down"> 26.3%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="250" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">TOTAL ASSETS</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/fluent_coin-stack-24-regular.png') }}"
                                        alt="coin_stack" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="16000"
                                        data-speed="10000">16.0</span> <span class="fs-4">Bn</span>
                                    <span class="green-caret">
                                        <img src="{{ asset('icons/Vector_7.png') }}" alt="caret-up"> 58.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="250" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">EBITDA</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/fluent_coin-stack-24-regular.png') }}"
                                        alt="coin_stack" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="1900"
                                        data-speed="10000">1.9</span> <span class="fs-4">Bn</span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down"> 5.0%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="250" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">SHAREHOLDERS’ FUND</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/fluent_coin-stack-24-regular.png') }}"
                                        alt="coin_stack" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="7700"
                                        data-speed="10000">7.7</span> <span class="fs-4">Bn</span>
                                    <span class="green-caret">
                                        <img src="{{ asset('icons/Vector_7.png') }}" alt="caret-up"> 12.7%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="250" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">SALES VOLUME</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/fluent_coin-stack-24-regular.png') }}"
                                        alt="coin_stack" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2700"
                                        data-speed="10000">2.7</span> <span class="fs-4">M</span>
                                    <span class="green-caret">
                                        <img src="{{ asset('icons/Vector_7.png') }}" alt="caret-up"> 4.6%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="250" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">CAPITAL INVESTMENT</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/fluent_coin-stack-24-regular.png') }}"
                                        alt="coin_stack" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="5600"
                                        data-speed="10000">5.6</span> <span class="fs-4">Bn</span>
                                    <span class="green-caret">
                                        <img src="{{ asset('icons/Vector_7.png') }}" alt="caret-up"> 862.7%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="300" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">MARKET CAPITALISATION</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/heroicons_chart-pie.png') }}"
                                        alt="heroicons_chart-pie" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="10200"
                                        data-speed="10000">10.2 </span> <span class="fs-4">Bn</span>
                                    <span class="green-caret">
                                        <img src="{{ asset('icons/Vector_7.png') }}" alt="caret-up">10.2%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                {{-- <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="50" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Team Members</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/fluent_people-team-16-regular.png') }}" alt="team" />
                                </div>
                                <div class="">
                                    <span class="fs-3">+</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="1750"
                                        data-speed="10000">2000</span>
                                    <span class="green-caret">
                                        <img src="{{ asset('icons/Vector_7.png') }}" alt="caret-up"> 2.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="100" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue ({{ $year }})</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/clarity_container-volume-line.png') }}"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">2.44</span><span class="fs-3">M HL</span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6 col-sm-12" data-aos="fade-down" data-aos-duration="350" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue ({{ $year }})</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/clarity_container-volume-line.png') }}"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">2.44 </span>
                                    <span class="fs-4">M HL </span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="400" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue ({{ $year }})</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/clarity_container-volume-line.png') }}"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">244 </span><span class="fs-4">M HL </span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="500" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue ({{ $year }})</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/clarity_container-volume-line.png') }}"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">2.44 </span>
                                    <span class="fs-4">M HL </span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> --}}

            </div>
        </div>
    </div>


    <div class="ir-section-details py-6" id="remarks">
        <div class="container leadership-container">
            <div class="row leadership-section">
                <div class="col-lg-6 col-md-12 leadership-image-col" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                    <div class="overview-image bg-image pbg-shadow leadership-image"
                        style="background-image: url({{ asset('images/our-leadership/leader-1.png') }})"
                        class="rounded">
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 leadership-content-col" data-aos="fade-left" data-aos-duration="500" data-aos-easing="linear">
                    <div class="leadership-content">
                        <h3>Chairman's message</h3>
                        <h4>Vision in Action</h4>
                        <p class="smallest-text leadership-text">
                            The year marked a major milestone in
                            PhoenixBev’s regional expansion journey
                            with strategic transactions in Seychelles
                            and Réunion island further strengthening
                            the Group’s footprint across the Indian
                            Ocean region.
                            <br><br>These investments align
                            with the IBL Group’s ‘Beyond Borders’
                            strategy and accelerate PhoenixBev’s
                            ambition to build an integrated and
                            future-focused network that drives scale,
                            unlocks synergies and positions the
                            Group as a regional hub for innovation
                            and partnerships.
                        </p>
                        <p>
                            <span class="smallest-text"><b></b>Arnaud Lagesse</b></span>
                            <br>
                            <i class="smallest-text">Chairman
                                <br>
                                Phoenix Beverages Ltd
                            </i>
                        </p>
                    </div>
                </div>
            </div>

            <div class="row mt-6 leadership-section">
                <div class="col-lg-6 col-md-12 leadership-content-col order-lg-1 order-2" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                    <div class="leadership-content">
                        <h3>CEO'S review</h3>
                        <div>
                            <p class="smallest-text leadership-text">
                                PhoenixBev experienced record demand
                                for its products during the year, driven
                                by the recovery in tourism arrivals and
                                rising domestic spending as the statutory
                                increases in employee remuneration raised
                                disposable income.
                                <br><br>
                                Sales volumes grew by 8.2% in Mauritius
                                and 4.6% at Group level. Group turnover
                                rose by 10.1% while gross profit margin
                                remained stable at 30.5% in 2024 and 2025.

                            </p>
                            <span class="smallest-text"><b>Bernard Theys</b></span>
                            <br>
                            <i class="smallest-text">CEO
                                <br>
                                Phoenix Beverages Ltd
                            </i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 leadership-image-col order-lg-2 order-1" data-aos="fade-left" data-aos-duration="500" data-aos-easing="linear">
                    <div class="overview-image bg-image pbg-shadow leadership-image"
                        style="background-image: url({{ asset('images/our-leadership/leader-11.png') }})"
                        class="rounded">
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('scripts')
    <script>
        AOS.init({
            once: true,
            duration: 500
        });

        $(document).ready(function() {
            $('.pbgCountUp').each(function() {
                var $this = $(this);
            var target = parseFloat($this.data('to'));
            var unit = $this.next('.fs-3').text().trim();

            var countUp = new CountUp($this[0], 0, target, 0, 10, {
                separator: ',',
                decimal: '.'
            });

                var observer = new IntersectionObserver(function(entries, observer) {
                    entries.forEach(function(entry) {
                        if (entry.isIntersecting) {
                        countUp.start();
                        observer.unobserve(entry.target);
                        }
                    });
                }, {
                    threshold: 0.8
            });

                observer.observe($this[0]);

                countUp.callback = function() {
                    var finalValue = countUp.endVal;

                    if (finalValue % 1 !== 0) {
                    finalValue = finalValue.toFixed(2);
                    }

                $this.text(finalValue + ' ' + unit);
                };
            });
        });
    </script>
@endsection
