@extends('layouts.app')
<style>
    /* Honeypot field styling - completely hidden */
    .honeypot-field {
        position: absolute !important;
        left: -9999px !important;
        top: -9999px !important;
        width: 1px !important;
        height: 1px !important;
        opacity: 0 !important;
        pointer-events: none !important;
        z-index: -1 !important;
    }
</style>
@section('content')
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url({{ asset('images/careers/08_careers_pbl.png') }});">
        </div>
        <div class="page-title-container">
            <h4>CAREERS</h4>
            <span class="text-primary">Your Pathway to Success.</span>
        </div>
    </div>

    <div class="container landing-section">
        <div class="row pb-6">
            <div class="col-lg-6 col-md-12 py-3 px-4" data-aos="fade-right" data-aos-delay="1000">
                <h3>Careers at Phoenix Beverages Group</h3>
                <p class="text-wrap our-holding-location" style="text-align: justify">
                    We aim to recruit high calibre people who will take ownership of challenges and revel in finding solutions to problems.
                    We look for people who work well individually and, just as well, collectively to deliver exceptional results.
                    We nurture people who are generous in their sharing of ideas and passionate about delivering quality to our customers and our consumers.
                </p>

                <p class="text-wrap our-holding-location" style="text-align: justify">
                    Although each of Phoenix Beverages Group departments has its own culture, each member of the company is united around the Thirst for the Best, First for You motto.
                    If you are looking for a challenging role in our organization we invite you to browse through what our departments have to offer.
                </p>
            </div>

            <div class="col-lg-6 col-md-12 px-5" data-aos="fade-left" data-aos-delay="1000">

                <div class="overview-image bg-image pbg-shadow "
                    style="background-image: url({{ asset('images/careers/phoenixbev_operations.png') }})">

                </div>
            </div>
        </div>
    </div>
    </div>


    <div class="main-section py-6 px-3">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12 py-3 px-4" data-aos="fade-right" data-aos-delay="1000">
                    <h3>Why Work for us</h3>
                    <p class="text-wrap our-holding-location" style="text-align: justify">
                        At Phoenix Beverages Group, our employees are rewarded for their hard work and dedication and they enjoy competitive pay and excellent benefits, along with a positive work environment built on mutual respect and professionalism.
                        Taking care of our employees is a must as we understand that they are the driving force behind our success.
                    </p>
                    <p class="text-wrap our-holding-location" style="text-align: justify">
                        Our values – customer orientation, innovation, adaptability, honesty and trustworthiness - are detailed in a Code of Ethics that encourages living them with integrity and in compliance with the law.
                        This Code of Ethics, signed by employees, defines the Group's commitments towards both our stakeholders and the environment. It also states the fair and transparent behaviour that we promote amongst ourselves while fulfilling those commitments.
                    </p>
                </div>
            <div class="col-lg-6 col-md-12" data-aos="fade-left" data-aos-delay="1000">
                <form id="careers-form">
                    @csrf
                    <input type="hidden" name="form_start_time" value="{{ time() }}">
                    
                    <!-- Honeypot fields - hidden from users but visible to bots -->
                    <div class="honeypot-field">
                        <input type="text" name="website" tabindex="-1" autocomplete="off">
                        <input type="text" name="url" tabindex="-1" autocomplete="off">
                        <input type="text" name="company" tabindex="-1" autocomplete="off">
                        <input type="text" name="subject" tabindex="-1" autocomplete="off">
                    </div>
                    
                    <div class="custom-form-group">
                        <input type="text" class="form-control" placeholder="Full Name" name="full_name"
                            value="{{ old('full_name') }}" required minlength="3" maxlength="50">
                        @error('full_name')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror

                        <input type="email" class="form-control" placeholder="Email" name="email"
                            value="{{ old('email') }}" required>
                        @error('email')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="custom-form-group">
                        <input type="text" class="form-control" placeholder="Phone Number" name="phone_number"
                            value="{{ old('phone_number') }}" required minlength="10" maxlength="20">
                        @error('phone_number')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror

                        <input type="file" class="form-control" placeholder="Upload CV" name="cv"
                            value="{{ old('cv') }}" required accept=".pdf,.doc,.docx">
                        @error('cv')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div>
                        <textarea class="form-control" name="message" placeholder="Message" rows="7" required 
                            minlength="10" maxlength="1000">{{ old('message') }}</textarea>
                        @error('message')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="cta d-flex justify-content-between align-items-center">
                        <div class="h-captcha" data-sitekey="{{env('NOCAPTCHA_SITEKEY')}}"></div>
                        <div class="d-flex align-items-center">
                            <input type="button" class="button pbg-button pbg-shadow" id="submit-button" value="Submit" />
                            <div id="loading-spinner" style="display: none; margin-left: 10px;">
                                <div class="spinner"></div>
                            </div>
                        </div>
                    </div>
                    <div class="show-alert" style="display: none">
                        <span class="alert-icon">&#x2714;</span>
                        <span class="alert-text text-smaller">Your submission was successful!</span>
                    </div>
                </form>
            </div>
            </div>

        </div>
    </div>

    <div class="page-blue" style="height: 50px"></div>

@stop
<script src="{{ URL::asset('jquery/dist/jquery.js') }}"></script>
<script>
    var tpj = jQuery.noConflict();
    tpj(document).ready(function() {
        tpj("#careers-form").validate({
            rules: {
                full_name: {
                    required: true,
                    minlength: 3
                },
                email: {
                    required: true,
                    email: true
                },
                message: {
                    required: true,
                    minlength: 10
                },
                phone_number: {
                    required: true,
                    minlength: 10
                },

            },
            messages: {
                full_name: {
                    required: "Please enter your name",
                    minlength: "Your name must be at least 3 characters long"
                },
                email: {
                    required: "Please enter your email",
                    email: "Please enter a valid email address"
                },
                message: {
                    required: "Please enter your message",
                    minlength: "Your message must be at least 10 characters long"
                }
            }
        });

        tpj("#submit-button").on('click', function(event) {
            event.preventDefault();
            
            // Prevent rapid submissions
            if (tpj("#submit-button").prop('disabled')) {
                return;
            }
            
            if (tpj("#careers-form").valid()) {
                // Check if form was filled too quickly (less than 3 seconds)
                var formStartTime = tpj('input[name="form_start_time"]').val();
                var currentTime = Math.floor(Date.now() / 1000);
                var timeDiff = currentTime - formStartTime;
                
                if (timeDiff < 3) {
                    tpj(".show-alert")
                        .removeClass("success")
                        .addClass("error")
                        .find(".alert-icon")
                        .html("&#10060;")
                        .end()
                        .find(".alert-text")
                        .text("Please take your time to fill out the form properly.")
                        .end()
                        .show();
                    return;
                }
                
                var hcaptchaResponse = grecaptcha.getResponse();

                if (hcaptchaResponse === "") {
                    tpj(".show-alert")
                        .removeClass("success")
                        .addClass("error")
                        .find(".alert-icon")
                        .html("&#10060;")
                        .end()
                        .find(".alert-text")
                        .text("Please complete the reCAPTCHA.")
                        .end()
                        .show();
                    return;
                }

                $("#submit-button").prop("disabled", true);
                $("#loading-spinner").show();

                // Create FormData object
                var formData = new FormData(tpj("#careers-form")[0]);
                formData.append('h-recaptcha-response', hcaptchaResponse);

                $.ajax({
                    url: "{{ route('careers') }}",
                    method: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        $("#loading-spinner").hide();
                        if (response.status === 'success') {
                            const caseId = response.data;
                            tpj(".show-alert")
                                .removeClass("error")
                                .addClass("success")
                                .find(".alert-icon")
                                .html("&#x2714;")
                                .end()
                                .find(".alert-text")
                                .text(`Your submission was successful! case id : ${caseId} `)
                                .end()
                                .show();
                        } else {
                            $(".show-alert")
                                .removeClass("success")
                                .addClass("error")
                                .find(".alert-icon")
                                .html("&#10060;")
                                .end()
                                .find(".alert-text")
                                .text("Something went wrong, please try again later.")
                                .end()
                                .show();
                        }

                        tpj("#careers-form")[0].reset();
                        grecaptcha.reset();
                    },
                    error: function(xhr, status, error) {
                        tpj("#loading-spinner").hide();
                        tpj(".show-alert")
                            .removeClass("success")
                            .addClass("error")
                            .find(".alert-icon")
                            .html("&#10060;")
                            .end()
                            .find(".alert-text")
                            .text("Something went wrong, please try again later.")
                            .end()
                            .show();
                    },
                    complete: function() {
                        $("#submit-button").prop("disabled", false);
                    }
                });
            }
        });
    });


    tpj(document).on('click', '.alert .close', function() {
        tpj(this).parent().hide();
    });
</script>
