<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\PageSetting;
use Illuminate\Support\Facades\DB;

class PageSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pages = [
            // PBL Integrated Reports
            [
                'page_name' => 'PBL Integrated Report 2024',
                'page_url' => '/pbl-integrated-report/2024',
                'is_protected' => false,
                'password' => null,
            ],
            [
                'page_name' => 'PBL Integrated Report 2025',
                'page_url' => '/pbl-integrated-report/2025',
                'is_protected' => false,
                'password' => null,
            ],
            
            // PICL Integrated Reports
            [
                'page_name' => 'PICL Integrated Report 2025',
                'page_url' => '/picl-integrated-report/2025',
                'is_protected' => false,
                'password' => null,
            ],
            
            // CICL Integrated Reports
            [
                'page_name' => 'CICL Integrated Report 2025',
                'page_url' => '/cicl-integrated-report/2025',
                'is_protected' => false,
                'password' => null,
            ],
        ];

        foreach ($pages as $page) {
            PageSetting::updateOrCreate(
                ['page_url' => $page['page_url']], // Find by unique URL
                $page // Update or create with this data
            );
        }

        $this->command->info('Page settings seeded successfully! All pages set to public by default.');
    }
}
