<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('seo_data', function (Blueprint $table) {
            $table->id();
            $table->string('page_route')->unique(); // e.g., 'home', 'about-us', 'news-room'
            $table->string('page_name'); // Human readable name
            $table->string('title');
            $table->text('description');
            $table->text('keywords')->nullable();
            $table->string('image')->nullable();
            $table->string('url')->nullable();
            $table->string('type')->default('website'); // website, article, product, etc.
            $table->string('author')->nullable();
            $table->string('robots')->default('index, follow');
            $table->string('canonical')->nullable();
            $table->json('open_graph')->nullable(); // Additional OG data
            $table->json('twitter_card')->nullable(); // Additional Twitter data
            $table->json('structured_data')->nullable(); // JSON-LD structured data
            $table->json('hreflang')->nullable(); // International SEO
            $table->json('alternate_urls')->nullable(); // Alternate language URLs
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('seo_data');
    }
};