<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SeoData extends Model
{
    use HasFactory;

    protected $fillable = [
        'page_route',
        'page_name',
        'title',
        'description',
        'keywords',
        'image',
        'url',
        'type',
        'author',
        'robots',
        'canonical',
        'open_graph',
        'twitter_card',
        'structured_data',
        'hreflang',
        'alternate_urls',
        'is_active'
    ];

    protected $casts = [
        'open_graph' => 'array',
        'twitter_card' => 'array',
        'structured_data' => 'array',
        'hreflang' => 'array',
        'alternate_urls' => 'array',
        'is_active' => 'boolean'
    ];

    /**
     * Get SEO data by page route
     */
    public static function getByRoute($route)
    {
        return static::where('page_route', $route)
                    ->where('is_active', true)
                    ->first();
    }

    /**
     * Get all active SEO data
     */
    public static function getAllActive()
    {
        return static::where('is_active', true)
                    ->orderBy('page_name')
                    ->get();
    }

    /**
     * Get SEO data for sitemap
     */
    public static function getForSitemap()
    {
        return static::where('is_active', true)
                    ->whereNotNull('url')
                    ->get();
    }
}