<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\RateLimiter;
use Symfony\Component\HttpFoundation\Response;

class ThrottleFormSubmissions
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $key = 'form_submission_' . $request->ip();
        
        // Allow maximum 1 submission per hour per IP (stricter for spam prevention)
        if (RateLimiter::tooManyAttempts($key, 1)) {
            $seconds = RateLimiter::availableIn($key);
            
            return response()->json([
                'status' => 'error',
                'message' => "Too many form submissions. Please try again in {$seconds} seconds."
            ], 429);
        }
        
        RateLimiter::hit($key, 3600); // 1 hour window
        
        return $next($request);
    }
}
