<?php

namespace App\Http\Controllers;

use Exception;
use Carbon\Carbon;
use App\Models\News;
use App\Models\Stock;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Services\NewsService;
use App\Services\StockService;
use App\Models\CareerApplication;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Storage;
use App\Mail\CareerApplicationApplicant;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class HomeController extends Controller
{
    protected $newsService;

    public function __construct(NewsService $newsService)
    {
        $this->newsService = $newsService;
    }

    public function index()
    {
        $news = News::latest()->take(3)->get();
        return view('welcome', compact('news'));
    }

    public function aboutUs(Request $request)
    {
        $stats = [
            ['image' => 'glance-001.png', 'value' => '2', 'figure' => '', 'title' => 'Countries of operation'],
            ['image' => 'glance-002.png', 'value' => '50', 'figure' => '+', 'title' => 'Brands in our portfolio'],
            ['image' => 'glance-003.png', 'value' => '4', 'figure' => '', 'title' => 'Production units'],
            ['image' => 'glance-004.png', 'value' => '9', 'figure' => '', 'title' => 'Export countries'],
            ['image' => 'glance-005.png', 'value' => '12,171', 'figure' => 'M', 'title' => 'Turnovers'],
            ['image' => 'glance-006.png', 'value' => '581', 'figure' => 'M', 'title' => 'Capital Investment'],
            ['image' => 'glance-007.png', 'value' => '1,950', 'figure' => 'M', 'title' => 'EBITDA'],
            ['image' => 'glance-008.png', 'value' => '1,091', 'figure' => 'M', 'title' => 'Net Profit After Tax'],
            ['image' => 'glance-009.png', 'value' => '10,067', 'figure' => 'M', 'title' => 'Total Assets'],
            ['image' => 'glance-010.png', 'value' => '1,575', 'figure' => 'M', 'title' => 'Cash Flow'],
            ['image' => 'glance-011.png', 'value' => '22.40', 'figure' => 'M', 'title' => 'Dividend shares'],
            ['image' => 'glance-012.png', 'value' => '8,059', 'figure' => 'M', 'title' => 'Market Capitalization'],
        ];

        return view('about-us', [
            'stats' => $stats
        ]);
    }

    /**
     * Contact us page
     */
    public function contactUs()
    {
        $contacts = [
            [
                'country' => 'Mauritius',
                'name' => 'PhoenixBev',
                'address' => 'Pont Fer, Phoenix, Mauritius',
                'email' => 'contact@phoenixbev.mu',
                'tel' => '+230 601 2000',
                'fax' => '+230 686 6920'
            ],
            [
                'country' => 'Rodrigues',
                'name' => 'PhoenixBev',
                'address' => "Pointe L'Herbe, Rodrigues",
                'email' => 'contact@phoenixbev.mu',
                'tel' => '+230 831 1648',
                'fax' => '+230 831 2181'
            ],
            [
                'country' => 'Reunion Island',
                'name' => 'Edena Boissons',
                'address' => "10 rue Eugène Delouise, Rivière des Galets 97419, La Possession, La Réunion",
                'email' => 'service.conso@edenaboissons.re',
                'tel' => '+262 262 421 530',
                'fax' => '+262 262 420 502'
            ],
            [
                'country' => 'Seychelles',
                'name' => 'Seychelles Breweries Limited',
                'address' => "O'Brien House | PO Box 273 | Le Rocher | Mahé | Seychelles",
                'email' => 'contact@seybrew.com',
                'tel' => '+248 438 2600'
                //'fax' => '+248 438 2600'
            ]
        ];

        return view('contact-us', [
            'contacts' => $contacts
        ]);
    }

    public function ourBrand()
    {

        $beerProducts = [
            [
                "image" => asset("images/our-brands/Beers/manawa.png"),
                "name" => "Manawa",
                "rating" => "ABV: 4.5% |5.5% |6.5% alc",
                "description" => "Manawa is the name of a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
                range of Original Mauritian craft beers to the market at the highest levels of quality."
            ],
            [
                "image" => asset("images/our-brands/Beers/phoenix-beer-2.png"),
                "name" => "Phoenix Beer",
                "rating" => "ABV: 5.0% |5.5% |6.5% alc",
                "description" => "Since its launch in 1963, and as the first beer to be produced and to originate locally, Phoenix Beer has always
                had a special place in the hearts of Mauritians."

            ],
            [
                "image" => asset("images/our-brands/Beers/phoenix-panache-bottle-2.png"),
                "name" => "Phoenix Panache",
                "rating" => "ABV: 0.9% alc",
                'description' => "Phoenix Panaché offers a refreshing alternative to beer, with its easy-drinking appeal.
                It is a pleasantly light and mildly alcoholic drink, with a hint of sweetness and no bitter aftertaste."
            ],
            [
                "image" => asset("images/our-brands/Beers/speciale-phoenix.png"),
                "name" => "Spéciale Phoenix",
                "rating" => "ABV: 6.5% alc",
                'description' => "Spéciale Phoenix previously named Phoenix Special Brew, launched in 2005, is the beer for the connoisseurs."
            ],
            [
                "image" => asset("images/our-brands/Beers/blue-marlin-beer-can-2.png"),
                "name" => "Blue Marlin",
                "rating" => "ABV: 6.0% alc",
                'description' => "Blue Marlin has been conceived to give more power and success to its consumers. In 2007, Blue Marlin won the Grand
                Gold medal at the prestigious Monde Selection Awards."
            ],
            [
                "image" => asset("images/our-brands/Beers/stella-can-2.png"),
                "name" => "Stella Pils",
                "rating" => "ABV: 4.8% alc",
                'description' => "Stella PilsIts uniqueness lies in its crisp, aromatic and dry taste with maize inclusion. In 2009, Stella Pils reached
                for the stars by winning the Monde Selection Gold Award."
            ],
            [
                "image" => asset("images/our-brands/Beers/phoenix-fresh-can-2.png"),
                "name" => "Phoenix Fresh",
                "rating" => "ABV: 3.5% alc",
                'description' => "Phoenix Fresh is refreshing and well suited for summertime with its unique natural lemon flavoured taste.
                It is the most ideal partner to enjoy friendly moments with loved ones."
            ],
            [
                "image" => asset("images/our-brands/Beers/guinness-foreign-extra.png"),
                "name" => "Guinness Foreign Extra",
                "rating" => "ABV: 7.5% alc",
                'description' => "Guinness® Foreign Extra Stout is a beer born of a thirst for adventure. In the early 1800s, Arthur Guinness II braved
                the perils of sea travel to export this famous black beer across the globe."
            ],
            [
                "image" => asset("images/our-brands/Beers/gister-lager-beer-4.png"),
                "name" => "Gister",
                "rating" => "ABV: 4.8% alc",
                'description' => "Gister, specially crafted for trendsetters and connoisseurs, was launched in June 2016. This premium beer,
                carefully brewed with the finest of ingredients, stands out with its brightness, its foamy head and its fine bubbles."
            ],
            [
                "image" => asset("images/our-brands/Carbonated-soft-drinks/ko-gin-can-cider-2.png"),
                "name" => "KO gin",
                "rating" => "Available in: Different flavours",
                'description' => "Sega is a local flavoured soft drink that holds a very dear place in the hearts of the Reunionese since generations.
                Sega is a refreshing soft drink produced locally with spring water and sugar cane in Reunion Island."
            ],
        ];

        $carbonatedSoftDrinks = [
            [
                "image" => asset("images/our-brands/Carbonated-soft-drinks/cocacola-can-2.png"),
                "name" => "Coca-Cola",
                "rating" => "Also available in: Diet and Zero coke",
                "description" => "Coca-Cola has been present in the Mauritian culture and spreading happiness for over 65 years. We are proud to be the
                pioneering and sole bottling company for The Coca-Cola Company® in Mauritius."
            ],
            [
                "image" => asset("images/our-brands/Carbonated-soft-drinks/fanta.png"),
                "name" => "Fanta",
                "rating" => "Orange and passion flavour",
                "description" => "Fanta is a fruit flavoured soft drink from The Coca-Cola Company®. Its fun-filled character and diversity make it a much
                sought-after drink during the festive seasons."

            ],
            [
                "image" => asset("images/our-brands/Carbonated-soft-drinks/sprite-bottle-2.png"),
                "name" => "Sprite",
                "rating" => "Lemon Lime flavour",
                'description' => "Launched in 1965 in Mauritius and produced by The Coca-Cola Company®, Sprite is a refreshing soft drink, enjoyed by everyone."
            ],
            [
                "image" => asset("images/our-brands/Carbonated-soft-drinks/eski-2.png"),
                "name" => "Eski",
                "rating" => "Available in: Four different flavours",
                'description' => "Eski is the local flavoured soft drink that holds a very dear place in the hearts of Mauritians.
                Phoenix Beverages Group acquired and re-launched the brand in 2014."
            ],
            [
                "image" => asset("images/our-brands/Carbonated-soft-drinks/orange-2.png"),
                "name" => "Orangina",
                "rating" => "Original and Zero flavours",
                'description' => "Orangina is a premium soft drink enjoyed all over the world. It is recommended to gently shake the bottle to appreciate its exquisite taste.
                Orangina Zero is the newest member in the family."
            ],
            [
                "image" => asset("images/our-brands/Carbonated-soft-drinks/appletiser-grapetiser.png"),
                "name" => "Appletiser & Grapetiser",
                "rating" => "Apple and grape flavours",
                'description' => "Appletiser and Grapetiser are refreshing sparkling fruit juices enjoyed all over the world. They can be enjoyed on their own or as a mixer
                for a sophisticated cocktail."
            ],
            [
                "image" => asset("images/our-brands/Carbonated-soft-drinks/schweppes-plastic.png"),
                "name" => "Schweppes",
                "rating" => "Flavoured",
                'description' => "Available in Schweppes Tonic, Schweppes Ginger Ale and Schweppes Soda Water."
            ],
            [
                "image" => asset("images/our-brands/Carbonated-soft-drinks/cidona-sparkling-can.png"),
                "name" => "Pearona & Cidona",
                "rating" => "Pear and Apple flavour",
                'description' => "Manawa is a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
                range of Original Mauritian craft beers to the market st at the highest level of quality."
            ],
            [
                "image" => asset("images/our-brands/Carbonated-soft-drinks/sega-plastic.png"),
                "name" => "Sega",
                "rating" => "Available in: Different flavours",
                'description' => "Sega is a local flavoured soft drink that holds a very dear place in the hearts of the Reunionese since generations.
                Sega is a refreshing soft drink produced locally with spring water and sugar cane in Reunion Island."
            ],
        ];

        $waterAndStills = [
            [
                "image" => asset("images/our-brands/Water-&-Stills/crystal-table-water-2.png"),
                "name" => "Crystal",
                "rating" => "Stills",
                "description" => "Crystal water gives you a taste of freshness and purity to quench your thirst.It is filtered by reverse osmosis,
                the highest water purification technology available to remove impurities.",
                "link" => "<a href='https://shop.phoenixbev.mu/' target='_blank' rel='noopener'>Read More</a>"
            ],
            [
                "image" => asset("images/our-brands/Water-&-Stills/crystal-still-water.png"),
                "name" => "Crystal Sparkling",
                "rating" => "Stills",
                "description" => "Crystal Sparkling (formerly known as Dasani) is a bottled sparkling water from The Coca-Cola Company®.
                It is a refreshing way to soothe your thirst and hydrate yourself. It is unsweetened, lightly carbonated and has zero calories.",
                "link" => "<a href='https://shop.phoenixbev.mu/' target='_blank' rel='noopener'>Read More</a>"

            ],
            [
                "image" => asset("images/our-brands/Water-&-Stills/fuze-tea.png"),
                "name" => "Fuze Tea",
                "rating" => " Available in: Different flavours",
                'description' => "Fuze Tea is an interesting brand that synergistically fuses tea with other natural ingredients to create
                a uniquely rich, layered sensory experience all at once it is earthy, lively, refreshing, fruity, herbal, floral and more.",
                "link" => "<a href='https://shop.phoenixbev.mu/' target='_blank' rel='noopener'>Read More</a>"
            ],
            [
                "image" => asset("images/our-brands/Water-&-Stills/bagetelle-1.png"),
                "name" => "Bagatelle",
                "rating" => "Stills",
                'description' => "Bagatelle is one of the most economic brands of stills in Reunion Island. Its 'eco design' gives
                the brand a more ecological plastic design with reduced labels and smaller caps. The bottles are optimized for less plastic material.",
                "link" => "<a href='https://www.edena.re/' target='_blank' rel='noopener'>Read More</a>"
            ],
            [
                "image" => asset("images/our-brands/Water-&-Stills/edena-petillante.png"),
                "name" => "Edena Petillante",
                "rating" => "Stills",
                'description' => "Edena Sparkling Water is the new experience of consuming refreshing water with symbol of simplicity, purity accompanying every moment of life.",
                "link" => "<a href='https://www.edena.re/' target='_blank' rel='noopener'>Read More</a>"
            ],
            [
                "image" => asset("images/our-brands/Water-&-Stills/edena-water-2.png"),
                "name" => "Edena Premium Bottle",
                "rating" => "Stills",
                'description' => "Edena spring water comes in a premium variety with different bottling sizes like 33CL, 50CL, 1L and 1.5L.
                Its spring water has been customised to be used for different occasions.",
                "link" => "<a href='https://www.edena.re/' target='_blank' rel='noopener'>Read More</a>"
            ],
            [
                "image" => asset("images/our-brands/Water-&-Stills/volcanik-water-2.png"),
                "name" => "Volcanik",
                "rating" => "Stills",
                'description' => "Volcanik is sparkling water specially to be mixed with cocktails and long drinks for an intense taste of freshness filled with bubbles.",
                "link" => "<a href='https://www.edena.re/' target='_blank' rel='noopener'>Read More</a>"
            ],
            // [
            //     "image" => asset("images/our-brands/Water-&-Stills/citro.png"),
            //     "name" => "Citro",
            //     "rating" => "Stills",
            //     'description' => "Citro is a subtle blend of spring water from Reunion Island, cane sugar and natural lemon flavor.
            //     It is an ultra refreshing drink, to be consumed at any time of the day",
            //     "link" => "<a href='https://www.edena.re/' target='_blank' rel='noopener'>Read More</a>"
            // ],
        ];

        $energyDrinks = [
            [
                "image" => asset("images/our-brands/Energy-Drinks/malta-guinness-2.png"),
                "name" => "Malta Guinness",
                "rating" => "Malt / Energy",
                "description" => "Malta Guinness, a non-alcoholic malt beverage, was launched in Mauritius in 1988.
                Malta Guinness is rich in iron and vitamins of the B complex.",
                "link" => "<a href='https://shop.phoenixbev.mu/' target='_blank' rel='noopener'>Read More</a>"
            ],
            [
                "image" => asset("images/our-brands/Energy-Drinks/monster-enerygy-2.png"),
                "name" => "Monster Energy Drink",
                "rating" => "Available in: Five different variants",
                "description" => "Monster Energy is way more than an energy drink. Led by athletes, musicians,
                employees, distributors and fans, Monster is a lifestyle in a can!",
                "link" => "<a href='https://shop.phoenixbev.mu/' target='_blank' rel='noopener'>Read More</a>"

            ],
            // [
            //     "image" => asset("images/our-brands/image-3.png"),
            //     "name" => "Manawa",
            //     "rating" => "ABV: 4.5% |5.5% |6.5% alc",
            //     'description' => "Manawa is a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
            //     range of Original Mauritian craft beers to the market st at the highest level of quality."
            // ],
            // [
            //     "image" => asset("images/our-brands/image-4.png"),
            //     "name" => "Manawa",
            //     "rating" => "ABV: 4.5% |5.5% |6.5% alc",
            //     'description' => "Manawa is a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
            //     range of Original Mauritian craft beers to the market st at the highest level of quality."
            // ],
            // [
            //     "image" => asset("images/our-brands/image-5.png"),
            //     "name" => "Manawa",
            //     "rating" => "ABV: 4.5% |5.5% |6.5% alc",
            //     'description' => "Manawa is a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
            //     range of Original Mauritian craft beers to the market st at the highest level of quality."
            // ],
            // [
            //     "image" => asset("images/our-brands/image-6.png"),
            //     "name" => "Manawa",
            //     "rating" => "ABV: 4.5% |5.5% |6.5% alc",
            //     'description' => "Manawa is a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
            //     range of Original Mauritian craft beers to the market st at the highest level of quality."
            // ],
            // [
            //     "image" => asset("images/our-brands/image-7.png"),
            //     "name" => "Manawa",
            //     "rating" => "ABV: 4.5% |5.5% |6.5% alc",
            //     'description' => "Manawa is a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
            //     range of Original Mauritian craft beers to the market st at the highest level of quality."
            // ],
            // [
            //     "image" => asset("images/our-brands/image-8.png"),
            //     "name" => "Manawa",
            //     "rating" => "ABV: 4.5% |5.5% |6.5% alc",
            //     'description' => "Manawa is a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
            //     range of Original Mauritian craft beers to the market st at the highest level of quality."
            // ],
        ];

        $wineAndSpirits = [
            // [
            //     "image" => asset("images/our-brands/Wines-&-Spirits/58Gin.png"),
            //     "name" => "58Gin",
            //     "rating" => "ABV: 40% alc",
            //     "description" => "Kenyan Originals 58 Gin Classic, a naturally fruity gin with a spicy finish! With a 40% ABV,
            //     it is made with ingredients grown in Kenya, including; Lime, Groundnuts, Mint, Mabuyu and Ginger.",
            //     "link" => "<a href='https://shop.phoenixbev.mu/' target='_blank' rel='noopener'>Read More</a>"
            // ],
            [
                "image" => asset("images/our-brands/Wines-&-Spirits/ko-gin.png"),
                "name" => "KO Gin",
                "rating" => "ABV: 40% alc",
                "description" => "Kenyan Originals 58 Gin Classic, a naturally fruity gin with a spicy finish! With a 40% ABV,
                it is made with ingredients grown in Kenya, including; Lime, Groundnuts, Mint, Mabuyu and Ginger.",
                "link" => "<a href='https://shop.phoenixbev.mu/' target='_blank' rel='noopener'>Read More</a>"

            ],
            [
                "image" => asset("images/our-brands/Wines-&-Spirits/mara-edition-botanical-gin.png"),
                "name" => "Mara Edition Botanical Gin",
                "rating" => "ABV: 40% alc",
                'description' => "The Mara Edition Gin by African Originals — A super premium gin crafted with foraged botanicals from Northern Mara,
                offering an authentic taste of Kenya.",
                "link" => "<a href='https://shop.phoenixbev.mu/' target='_blank' rel='noopener'>Read More</a>"
            ],
            [
                "image" => asset("images/our-brands/Wines-&-Spirits/58Gin.png"),
                "name" => "58 Gin",
                "rating" => "ABV: 40% alc",
                'description' => "The 58 Gin by African Originals — A super premium gin crafted with foraged botanicals from Northern Mara,
                offering an authentic taste of Kenya.",
                "link" => "<a href='https://shop.phoenixbev.mu/' target='_blank' rel='noopener'>Read More</a>"
            ],
            // [
            //     "image" => asset("images/our-brands/image-4.png"),
            //     "name" => "Manawa",
            //     "rating" => "ABV: 4.5% |5.5% |6.5% alc",
            //     'description' => "Manawa is a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
            //     range of Original Mauritian craft beers to the market st at the highest level of quality."
            // ],
            // [
            //     "image" => asset("images/our-brands/image-5.png"),
            //     "name" => "Manawa",
            //     "rating" => "ABV: 4.5% |5.5% |6.5% alc",
            //     'description' => "Manawa is a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
            //     range of Original Mauritian craft beers to the market st at the highest level of quality."
            // ],
            // [
            //     "image" => asset("images/our-brands/image-6.png"),
            //     "name" => "Manawa",
            //     "rating" => "ABV: 4.5% |5.5% |6.5% alc",
            //     'description' => "Manawa is a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
            //     range of Original Mauritian craft beers to the market st at the highest level of quality."
            // ],
            // [
            //     "image" => asset("images/our-brands/image-7.png"),
            //     "name" => "Manawa",
            //     "rating" => "ABV: 4.5% |5.5% |6.5% alc",
            //     'description' => "Manawa is a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
            //     range of Original Mauritian craft beers to the market st at the highest level of quality."
            // ],
            // [
            //     "image" => asset("images/our-brands/image-8.png"),
            //     "name" => "Manawa",
            //     "rating" => "ABV: 4.5% |5.5% |6.5% alc",
            //     'description' => "Manawa is a powerful wave that lies off at Le Morne, Mauritius. Manawa strives to bring a diverse
            //     range of Original Mauritian craft beers to the market st at the highest level of quality."
            // ],
        ];

        $spiritCoolers = [
            [
                "image" => asset("images/our-brands/Spirits-Cooler/smirnoff-ice-guaran-bottle-2.png"),
                "name" => "Smirnoff Ice Guaran",
                "rating" => "ABV: 5.5% alc",
                "description" => "Smirnoff Ice Guarana is a refreshing blend of premium Smirnoff vodka and the sweet, fruity flavour of guarana.",
                "link" => "<a href='https://shop.phoenixbev.mu/' target='_blank' rel='noopener'>Read More</a>"
            ],
            [
                "image" => asset("images/our-brands/Spirits-Cooler/smirnoff-ice-original-can.png"),
                "name" => "Smirnoff Ice Original",
                "rating" => "ABV: 5.5% alc",
                "description" => "A ready to drink spirit cooler, Smirnoff Red Ice has become the favourite drink of many Mauritians. It is best served icy-cold.",
                "link" => "<a href='https://shop.phoenixbev.mu/' target='_blank' rel='noopener'>Read More</a>"

            ],
            // [
            //     "image" => asset("images/our-brands/Beers/phoenix-panache-bottle-2.png"),
            //     "name" => "Phoenix Panache",
            //     "rating" => "ABV: 0.9% alc",
            //     'description' => "Phoenix Panaché offers a refreshing alternative to beer, with its easy-drinking appeal.
            //     It is a pleasantly light and mildly alcoholic drink, with a hint of sweetness and no bitter aftertaste."
            // ],
            // [
            //     "image" => asset("images/our-brands/Beers/speciale-phoenix.png"),
            //     "name" => "Spéciale Phoenix",
            //     "rating" => "ABV: 6.5% alc",
            //     'description' => "Spéciale Phoenix previously named Phoenix Special Brew, launched in 2005, is the beer for the connoisseurs."
            // ],
            // [
            //     "image" => asset("images/our-brands/Beers/blue-marlin-beer-can-2.png"),
            //     "name" => "Blue Marlin",
            //     "rating" => "ABV: 6.0% alc",
            //     'description' => "Blue Marlin has been conceived to give more power and success to its consumers. In 2007, Blue Marlin won the Grand
            //     Gold medal at the prestigious Monde Selection Awards."
            // ],
            // [
            //     "image" => asset("images/our-brands/Beers/stella-can-2.png"),
            //     "name" => "Stella Pils",
            //     "rating" => "ABV: 4.8% alc",
            //     'description' => "Stella PilsIts uniqueness lies in its crisp, aromatic and dry taste with maize inclusion. In 2009, Stella Pils reached
            //     for the stars by winning the Monde Selection Gold Award."
            // ],
            // [
            //     "image" => asset("images/our-brands/Beers/phoenix-fresh-can-2.png"),
            //     "name" => "Phoenix Fresh",
            //     "rating" => "ABV: 3.5% alc",
            //     'description' => "Phoenix Fresh is refreshing and well suited for summertime with its unique natural lemon flavoured taste.
            //     It is the most ideal partner to enjoy friendly moments with loved ones."
            // ],
            // [
            //     "image" => asset("images/our-brands/Beers/guinness-foreign-extra.png"),
            //     "name" => "Guinness Foreign Extra",
            //     "rating" => "ABV: 7.5% alc",
            //     'description' => "Guinness® Foreign Extra Stout is a beer born of a thirst for adventure. In the early 1800s, Arthur Guinness II braved
            //     the perils of sea travel to export this famous black beer across the globe."
            // ],
            // [
            //     "image" => asset("images/our-brands/Beers/gister-lager-beer-4.png"),
            //     "name" => "Gister",
            //     "rating" => "ABV: 4.8% alc",
            //     'description' => "Gister, specially crafted for trendsetters and connoisseurs, was launched in June 2016. This premium beer,
            //     carefully brewed with the finest of ingredients, stands out with its brightness, its foamy head and its fine bubbles."
            // ],
        ];
        return view('our-brand', [
            "beerProducts" => $beerProducts,
            "carbonatedSoftDrinks" => $carbonatedSoftDrinks,
            "waterAndStills" => $waterAndStills,
            "energyDrinks" => $energyDrinks,
            "wineAndSpirits" => $wineAndSpirits,
            "spiritCoolers" => $spiritCoolers
        ]);
    }


    public function newsRoom(Request $request)
    {
        $searchQuery = $request->input('search', '');
        $categoryQuery = $request->input('category', 'all');
        $perPage = 9;

        // Build the base query
        $query = News::query();

        // Apply search filter
        if (!empty($searchQuery)) {
            $query->where(function ($q) use ($searchQuery) {
                $q->where('title', 'like', "%{$searchQuery}%")
                    ->orWhere('body', 'like', "%{$searchQuery}%")
                    ->orWhere('tags', 'like', "%{$searchQuery}%");
            });
        }

        // Apply category filter
        if ($categoryQuery !== 'all') {
            $query->where('category', $categoryQuery);
        }

        // Get paginated results
        $news = $query->orderBy('created_at', 'DESC')->paginate($perPage);

        // Get all news for display sections
        $displayNews = $this->newsService->getNews();

        // SEO data will be loaded automatically from database via head.blade.php
        // The system will use the 'news-room' route to load SEO data

        return view('news-room', [
            'news' => $news,
            'displayNews' => $displayNews,
            'searchQuery' => $searchQuery,
            'categoryQuery' => $categoryQuery
        ]);
    }


    public function newsDetail($id)
    {
        $news = $this->newsService->getNewsById($id);
        dd($news);
        return view('news-detail', compact('news'));
    }

    public function ourReach()
    {
        return view('our-reach', []);
    }

    public function csr()
    {
        return view('csr', []);
    }

    public function footPrints()
    {
        return view('foot-prints', []);
    }

    public function phoenixEarth()
    {
        $brandLogos = [
            asset("images/phoenix-earth/brand-image-1.png"),
            asset("images/phoenix-earth/brand-image-2.png"),
            asset("images/phoenix-earth/brand-image-3.png"),
            asset("images/phoenix-earth/brand-image-4-4.png"),
            asset("images/phoenix-earth/brand-image-5.png"),
            asset("images/phoenix-earth/brand-image-2.png"),
            asset("images/phoenix-earth/brand-image-3.png"),
            asset("images/phoenix-earth/brand-image-4-4.png"),
            asset("images/phoenix-earth/brand-image-5.png"),
        ];

        return view('phoenix-earth', [
            "brandLogos" => $brandLogos
        ]);
    }


    public function innovation()
    {
        return view('innovation', []);
    }

    public function ourCulture()
    {
        return view('our-culture', []);
    }

    public function ourLeadership()
    {
        $directors = [
            [
                "id" => 1,
                "image" => asset("images/our-leadership/leader-1.png"),
                "name" => "Arnaud LAGESSE",
                "position" => "NON-EXECUTIVE CHAIRMAN",
                "description" => "Appointed to the Board in 1998 and as Chairperson in 2017 Citizen and resident of Mauritius",
                "skills" => "Arnaud Lagesse is the Group CEO of IBL Ltd. He is one of the Mauritian private sector's
                            most prominent leaders and is known to drive IBL Group with innovative and challenging undertakings.
                            In 2016, he initiated the merger of GML Investissement Ltée and Ireland Blyth Limited and created the new entity IBL Ltd
                            which thus became the no 1 group in Mauritius and 2nd largest group in the region excluding South Africa.",
                "qualifications" => [
                    "Anti-Money Laundering/Combating the Financing of Terrorism Introduction Course – DTOS – April 2023",
                    "Breakthrough Executive Program – Egon Zehnder-Mobius, Portugal",
                    "Advanced Management Program (AMP180) – Harvard Business School, United States",
                    "Executive Education Program – INSEAD, France",
                    "Graduated from the Institut Supérieur de Gestion – Paris, France",
                    "Masters in Management – Université d'Aix-Marseille II, France",
                ],
                "core_competence" => [
                    "Business & Finance, Deal Structuring, Strategic Business Development"
                ],
                "external_appointments" => [
                    "Alteo Limited - (Non-Executive Director)",
                    "IBL Ltd - (Executive Director)",
                    "Miwa Sugar Limited - (Non-Executive Chairman)",
                    "Phoenix Investment Company Limited - (Non-Executive Chairman)",
                ]
            ],
            [
                "id" => 2,
                "image" => asset("images/our-leadership/leader-2.png"),
                "name" => "Jan BOULLÉ",
                "position" => "NON-EXECUTIVE DIRECTOR",
                "description" => "APPOINTED IN 2000. Citizen and resident of Mauritius",
                "skills" => "Jan Boullé worked for the Constance Group from 1984 to 2016 and occupied various executive positions and directorships, his last position being Group Head of Projects and Development. He was appointed as Chairman of IBL Ltd, the ultimate holding company of PhoenixBev, on 1 July 2016.
                            Jan Boullé is also a member of the Audit and Risk Committee as well as of the Corporate Governance Committee of the Company.",
                "qualifications" => [

                    "Qualified as an Ingénieur Statisticien Economiste, France.",
                    "Pursued postgraduate studies in Economics at Université de Laval, Canada.",
                    //"Strategic Development, Hospitality, Real Estate Development."
                ],
                "core_competence" => [
                    "Strategic Development, Hospitality, Real Estate Development."
                ],
                "external_appointments" => [
                    //"Alteo Limited",
                    "BlueLife Ltd - (Non-Executive Director)",
                    "IBL Ltd IBL Ltd - (Non-Executive Chairman)",
                    "Lux Island Resorts Ltd (Non-Executive Director)",
                    "Phoenix Investment Company Limited - (Non-Executive Director)",
                    //"The Bee Equity Partners Ltd",
                    "The United Basalt Products Ltd - (Non-Executive Director)"
                ]

            ],
            [
                "id" => 3,
                "image" => asset("images/our-leadership/leader-3.png"),
                "name" => "François DALAIS",
                "position" => "NON-EXECUTIVE DIRECTOR",
                "description" => "APPOINTED IN 1992. Citizen and resident of Mauritius",
                "skills" => "François Dalais is the co-founder and director of the Mauritius Freeport Development Ltd, Sugarex Ltd, Tropical Cubes Co. Ltd, Atlas Communications International Ltd and Caulea Ltd.
                             He also sits on the Board of a number of companies in Mauritius.",
                "qualifications" => [
                    "Diploma in Business Administration, London",
                    //"Trading, Strategic Development, Management.",
                ],
                "core_competence" => [
                    "Trading, Strategic Development, Management."
                ],
                "external_appointments" => [
                    "Phoenix Investment Company Limited - (Non-Executive Director)"
                ]
            ],
            [
                "id" => 4,
                "image" => asset("images/our-leadership/leader-4.png"),
                "name" => "Guillaume HUGNIN",
                "position" => "NON-EXECUTIVE DIRECTOR",
                "description" => "APPOINTED IN 2009.Citizen and resident of Mauritius",
                "skills" => "Guillaume Hugnin worked in South Africa and Australia for several years before joining the Eclosia Group of Companies in 1993. He was Head Group
                        Exports of the Eclosia Group. He has participated in the creation and/or the development of many of Eclosia's companies. He has vast experience in
                        international trade and logistics. He participated in many trade negotiating forums at SADC, and Comesa. Guillaume has directorships in the FMCG sector,
                        the hotel industry. He has served on the board of a number of private sector organisations: Mauritius Exporters Association (MEXA),
                        MIoD (Mauritius Institute of Directors), Business Mauritius, Guillaume Hugnin has been elected to the council of the Mauritius Chamber of Commerce
                        and Industry (MCCI) of which he was President for 2 consecutive mandates, from July 2019 to March 2022. He served as President of MCCI Business School.
                        He also served on the boards of some state-owned organisations: Mauritius Network Services Ltd (MNS) and Maurinet Investment Ltd.
                        Guillaume Hugnin is also a member of the Corporate Governance Committee of the Company.",
                "qualifications" => [
                    "Breakthrough Executive Program - Egon Zehnder-Mobius, Portugal",
                    "Advanced Management Program (AMP180)  Harvard Business School, United States",
                    "Executive Education Program - INSEAD, France",
                    "Graduated from the Institut Supérieur de Gestion - Paris, France",
                    "Masters in Management - Université d'Aix-Marseille II, France",
                ],
                "core_competence" => [
                    "Corporate Governance.",
                    "Strategic Business Development.",
                    "Local and Regional Market Knowledge.",
                    "International Trade."
                ],
                "external_appointments" => [
                    "Phoenix Investment Company Limited - (Non-Executive Director)"
                ]

            ],
            [
                "id" => 5,
                "image" => asset("images/our-leadership/leader-5.png"),
                "name" => "Hugues LAGESSE",
                "position" => "NON-EXECUTIVE DIRECTOR",
                "description" => "APPOINTED IN 2016. Citizen and resident of Mauritius",
                "skills" => "Hugues Lagesse is the Chief Executive Officer of BlueLife Limited, a real estate company developing property in Mauritius.
                             He has acquired considerable experience and competence in high-end residential market and mixed-use real estate.",
                "qualifications" => [
                    "Diploma in administration and finance from Ecole Supérieure de Gestion, Paris, France.",
                    "Management Program from INSEAD, France.",
                    "Real Estate Program from Harvard Business School, United States.",
                    "General Management Program for Mauritius and South East Africa from ESSEC."
                ],
                "core_competence" => [
                    "Real Estate, Property Development, Management."
                ],
                "external_appointments" => [
                    "BlueLife Limited - (Executive Director)",
                    "IBL Ltd - (Non-Executive Director)",
                    "Phoenix Investment Company Limited - (Non-Executive Director)"
                ]
            ],
            [
                "id" => 6,
                "image" => asset("images/our-leadership/leader-6.png"),
                "name" => "Thierry LAGESSE",
                "position" => "NON-EXECUTIVE DIRECTOR",
                "description" => "APPOINTED IN 1998. Citizen and resident of Mauritius.",
                "skills" => "Thierry Lagesse is the Founder of the Palmar Group, a textile and garment-oriented manufacturing company. A visionary entrepreneur,
                in 1999 he also launched a Direct To Home satellite television company in the Indian Ocean Islands. He serves as a director on the Boards of
                several listed companies on the Stock Exchange of Mauritius.",
                "qualifications" => [
                    "Maitrise des Sciences de gestion from Université de Paris Dauphine, France.",
                ],
                "core_competence" => [
                    "Entrepreneurship, Business Development and Finance, Strategic Development, Manufacturing, Textile, Media, Hospitality, Sugar."
                ],
                "external_appointments" => [
                    "Alteo Limited - (Non-Executive Director)",
                    "IBL Ltd - (Non-Executive Director)",
                    "Lux Island Resorts Ltd - (Non-Executive Director)",
                    "Phoenix Investment Company Limited - (Non-Executive Director)",
                    "The United Basalt Products Ltd - (Non-Executive Director)"
                ]

            ],
            [
                "id" => 7,
                "image" => asset("images/our-leadership/leader-7.png"),
                "name" => "Umulinga KARANGWA",
                "position" => "NON-EXECUTIVE DIRECTOR",
                "description" => "APPOINTED IN 2023. Non-Citizen and resident of Mauritius.",
                "skills" => "Umulinga Karangwa, born in 1981, is a fund manager with two decades of investment experience including 15 years focussed on African markets.
                            She is Rwandan and was born in Belgium where she started her career before moving to Africa to raise and manage funds investing in Africa with a focus
                            on sustainability and impact. She resides in Mauritius. She is also an angel investor passionate about African entrepreneurship and innovation.",
                "qualifications" => [
                    "Chartered Financial Analyst, Global",
                    "Financial Services Advisor, Financial",
                    "Planning Institute Southern Africa"
                ],
                "core_competence" => [
                    "Investment management",
                    "African listed and private investments",
                    "Investing for sustainability and impact"
                ],
                "external_appointments" => [
                    "none"

                ]
            ],
            [
                "id" => 8,
                "image" => asset("images/our-leadership/leader-8.png"),
                "name" => "Sylvia MAIGROT",
                "position" => "INDEPENDENT NON-EXECUTIVE DIRECTOR",
                "description" => "APPOINTED IN 2017. Citizen and resident of Mauritius",
                "skills" => "Sylvia Maigrot, born in 1970, is the partner in charge of corporate and business facilitation services at Box Office Ltd and counts more
                than 30 years' experience in company administration and secretarial practice, corporate governance, managing stakeholders' relationships and dealing
                with regulatory authorities. She provides transaction advisory support services in company restructuring, due diligence and business acquisitions
                and specialises in the hospitality industry. She is the Chairperson of the Corporate Governance Committee of the Company",
                "qualifications" => [
                    "Associate of the ICSA, the Governance Institute, United Kingdom.",
                ],
                "core_competence" => [
                    "Corporate Law",
                    "Governance",
                    "Administration",
                    "Management",
                    "Compliance."
                ],
                "external_appointments" => [
                    "none"
                ]

            ],
            [
                "id" => 9,
                "image" => asset("images/our-leadership/Christine_Marot_Director.png"),
                "name" => "Christine MAROT",
                "position" => "NON-EXECUTIVE DIRECTOR",
                "description" => "APPOINTED IN 2023. Citizen and resident of Mauritius.",
                "skills" => "Christine Marot started her career in an audit firm before joining the GML Group in 1990. She held various positions within the GML Group and,
                when she left in 2015, she was the Finance Executive – Corporate & Accounting. She was the CEO of BlueLife Limited from May 2015 to April 2020.
                She is the Group Head of Technology and Sustainability of IBL Ltd since July 2020.",
                "qualifications" => [
                    "Partly qualified ACCA",
                    "General Management Program for Mauritius and South East Africa from ESSEC"
                ],
                "core_competence" => [
                    "Finance",
                    "Information Technology",
                    "Sustainability",
                    "Property Development and Operations",
                    "Healthcare and Biotechnologies",
                    "Hospitality",
                    "Strategic Business Development"

                ],
                "external_appointments" => [
                    "Phoenix Investment Company Limited - (Non-Executive Director)",
                    "The United Basalt Products Ltd - (Non-Executive Director)"
                ]
            ],
            [
                "id" => 10,
                "image" => asset("images/our-leadership/leader-9.png"),
                "name" => "Catherine MCILRAITH",
                "position" => "INDEPENDENT NON-EXECUTIVE DIRECTOR",
                "description" => "APPOINTED IN 2022. Citizen and resident of Mauritius.",
                "skills" => "Catherine McIlraith, born in 1964, served her articles at Ernst & Young and held many senior positions in the Investment Banking industry
                in South Africa prior to returning to Mauritius in 2004 to join Investec Bank where she was Head of Specialized Finance and Banking until 2010. Since then,
                she has served as an Independent Non-Executive Director and as a member of various Committees of a number of public and private companies across various
                sectors internationally and in Mauritius. She is the Chairperson of the Audit and Risk Committee of the Company with effect from 1 July 2022.",
                "qualifications" => [
                    "Bachelor of Accountancy degree from the University of the Witwatersrand, Johannesburg, South Africa",
                    "Member of the South African Institute of Chartered Accountants since 1992",
                    "Fellow member of the Mauritius Institute of Directors",
                    "Member of the MIoD Directors forum",
                    //"General Management Program for Mauritius and South East Africa from ESSEC"
                ],
                "core_competence" => [
                    "Audit and Risk",
                    "Corporate Governance",
                    "Banking and Specialized Finance"
                ],
                "external_appointments" => [
                    "CIEL Limited - (Independent Non-Executive Director)",
                    "Grit Real Estate Income Group Limited - (Independent Non-Executive Director)",
                    "Astoria Limited - (Independent Non-Executive Director)",
                    "Les Gaz Industriels Limited",
                    //"MUA Ltd",
                    //"Paradise Hospitality Group Ltd"

                ]
            ],
            [
                "id" => 11,
                "image" => asset("images/our-leadership/leader-10.png"),
                "name" => "Patrick RIVALLAND",
                "position" => "EXECUTIVE DIRECTOR / CHIEF OPERATIONS OFFICER / CHIEF FINANCIAL OFFICER",
                "description" => "APPOINTED IN 2013. Citizen and resident of Mauritius.",
                "skills" => "Patrick Rivalland, born in 1972, worked for BDO and then The Sugar Industry Pension Fund Board before joining Phoenix Camp Minerals Limited
                in 1999 as Finance and Administrative Manager. He was appointed as Group Senior Manager Finance and Administration in 2001 and Chief  perations Officer in 2014. He is a past President of the Association of Mauritian Manufacturers.",
                "qualifications" => [
                    "Fellow member of the Chartered Association of Certified Accountants.",
                    "General Management Program for Mauritius and South East Africa ESSEC",
                    "Advance Management Program from IESE, Barcelona"
                ],
                "core_competence" => [
                    "Accounting and Finance",
                    "Strategy",
                    "Operations",
                    "Fast-Moving Consumer Goods (FMCG) Industry and Market Knowledge."
                ],
                "external_appointments" => [
                    "The Mauritius Chemical and Fertilizer Industry Limited - (Independent Non-Executive Director)"
                ]

            ],
            [
                "id" => 12,
                "image" => asset("images/our-leadership/leader-11.png"),
                "name" => "Bernard THEYS",
                "position" => "EXECUTIVE DIRECTOR / CHIEF EXECUTIVE OFFICER",
                "description" => "APPOINTED IN 2013.Non-citizen and resident of Mauritius.",
                "skills" => "Bernard Theys was born in 1965 in Brussels and has held various general management roles in the brewing industry where he has acquired substantial experience in the Fast-Moving Consumer Goods (FMCG) industry.",
                "qualifications" => [
                    "Diploma in Economic Science from Louvain University, Belgium.",
                    "BBA in Business Tourism Management from ICP .",
                    "Several programmes in Executive and Business Education at l'Association Internationale Américaine de Management (MCE) in 1995 and at INSEAD Fontainebleau in France in 2008.",
                    "Advance Management Program from IESE, Barcelona"
                ],
                "core_competence" => [
                    "Management",
                    "Strategic Business Development",
                    "specialised in Operations and FMCG Industry."
                ],
                "external_appointments" => [
                    "none"
                ]

            ],
        ];



        $managements = [
            [
                "id" => 1,
                "image" => asset("images/our-leadership/Management_Team/Frederic_Dubois-Senior_Manager_Sales_and_Distribution.png"),
                "name" => "Frederic Dubois",
                "position" => "Senior Manager Sales & Distribution",
                "description" => "Frederic Dubois, born in 1979, Master's degree from ISEG Business School in France and an Executive MBA from IAE Paris Sorbonne
                                Business School. He worked for more than twenty years in the FMCG sector for international companies such as Bacardi Martini Group, Pernod Ricard,
                                JTI, locally and internationally, before joining the Group as Senior Manager Sales and Distribution in 2015."
            ],
            [
                "id" => 2,
                "image" => asset("images/our-leadership/Management_Team/Eric_Eynaud-Senior_Manager_Business_Development.png"),
                "name" => "Eric Eynaud",
                "position" => "Senior Manager Business Development",
                "description" => "Eric Eynaud, born in 1966, holds a Master's degree in International Affairs from Toulouse Business School (TBS), and a two years
                                degree in Business Administration and Management from University Paris I – Panthéon Sorbonne. He promoted and worked for the French Defense
                                Industry in Argentina for 6 years before joining CIEL Textile (Aquarelle Clothing) as Sales and Marketing Director/General Manager ladieswear
                                for 22 years, including 2 years posted in New York. He joined the Phoenix Beverages Group as Senior Manager - Business Development in January 2023."

            ],
            [
                "id" => 3,
                "image" => asset("images/our-leadership/Management_Team/Gerard_Merle-Senior_Manager_Technical_Operations_and_Sustainability.png"),
                "name" => "Gerald Merle",
                "position" => "Senior Manager Civil Engineering & Non-Alcoholic Beverages",
                "description" => "Gérard Merle, born in 1968, has worked in the manufacturing sector for more than 21 years. Before joining PhoenixBev in January 2009
                                as Senior Manager – Limo Operations, he worked for Boxmore Plastics International. He was appointed Senior Manager – Civil Engineering and
                                Non-Alcoholic Beverages in 2014 and subsequently as Senior Manager – Technical Operations and Sustainability in 2022."
            ],
            [
                "id" => 4,
                "image" => asset("images/our-leadership/Management_Team/Daniel_Narayanen-Senior_Manager_Supply_Chain.png"),
                "name" => "Daniel Narayanen",
                "position" => "Senior Manager Supply Chain",
                "description" => "Daniel Narayanen, born in 1974, is a Fellow member of the Chartered Association of Certified Accountants(UK) and a Chartered Member of The
                                Chartered Institute of Logistics and Transport(UK). Before joining Phoenix Beverages Limited in 2004, he worked for De Chazal Du Mée BDO Ltd in the Audit
                                and Assurance division for seven years where he handled a wide portfolio of clients in different industries, together with special consultancy assignments.
                                He started with the Group as Internal Audit Manager with a reporting line to the Audit Committee and after four years took over the management of the procurement
                                department in 2008. He was appointed Senior Manager – Supply Chain in 2019 in charge of Planning, Logistics, Warehousing and Procurement."

            ],
            [
                "id" => 5,
                "image" => asset("images/our-leadership/Management_Team/Rama_Narayya-Senior_Manager_Human_Resources.png"),
                "name" => "Rama Narayya",
                "position" => "Senior Manager Human Resources",
                "description" => "Rama Narayya, born in 1967, holder of an Executive MBA with IAE Paris Sorbonne Business School has acquired wide experience in the Human
                                Resources functions whilst working for international companies and local conglomerates. He worked in diverse industries ranging
                                from hotels, beverages, textile, hypermarkets to airlines."
            ],
            [
                "id" => 6,
                "image" => asset("images/our-leadership/Management_Team/Jean-Bruno_Henriot-Senior_Manager_Brewery_Operations.png"),
                "name" => "Jean-Bruno Henriot",
                "position" => "Senior Manager Brewery Operations",
                "description" => "Jean-Bruno Henriot, born in 1976, joined the Brewery (ex-MBL) in 2001 as Trainee Brewer. He holds a Diploma in Applied Science and Technology
                                and a BSc(Hons) in Agriculture, as well as a Certificate in Brewing from the Siebel Institute. He moved to Madagascar in 2009, holding the position of Senior Technical
                                Manager for 5 years at the 'Nouvelle Brasserie de Madagascar', an operation co-owned at that time by Phoenix Beverages Ltd. He has taken his new role as Senior Manager
                                Brewery Operations since September 2021."

            ],
            [
                "id" => 7,
                "image" => asset("images/our-leadership/Management_Team/Patrice_Sheik_Bajeet-Senior_Manager_Marketing.png"),
                "name" => "Patrice Sheik Bajeet",
                "position" => "Senior Manager Marketing",
                "description" => "Patrice Sheik Bajeet, born in 1974, holds a BSc Management Degree from the University of Mauritius and MBA from IAE Paris Sorbonne.
                                After 12 years in the cellular operations industry and leading marketing at Emtel, he spent four years at The Coca-Cola Company regional office.
                                He is also the founder of the first digital and trade marketing agency on the island. He joined Phoenix Beverages Group in January 2015 as Senior Manager – Marketing."
            ],
            // [
            //     "id" => 8,
            //     "image" => asset("images/our-leadership/Management_Team/Antis-Treeboobhun.png"),
            //     "name" => "Antis Treebhoobun",
            //     "position" => "Senior Manager Business Systems",
            //     "description" => "Antis Treebhoobun, born in 1959, holds a BA in Computer Science from the University of Iowa. From 1987 to 1991 he worked in the USA as
            //                     a Software Engineer on contract for Boeing Avionics Corp. and from 1991 to 2001, he was the Senior IT Manager for Rogers Aviation and Tourism. He joined
            //                     the Group in 2001 as Senior Manager – Business Systems."

            // ],
            [
                "id" => 9,
                "image" => asset("images/our-leadership/Management_Team/Patrick_Rivalland-COO_CFO.png"),
                "name" => "Patrick RIVALLAND",
                "position" => "EXECUTIVE DIRECTOR / CHIEF OPERATIONS OFFICER / CHIEF FINANCIAL OFFICER",
                "description" => "APPOINTED IN 2013. Citizen and resident of Mauritius.",
                "skills" => "Patrick Rivalland, born in 1972, worked for BDO and then The Sugar Industry Pension Fund Board before joining Phoenix Camp Minerals Limited
                in 1999 as Finance and Administrative Manager. He was appointed as Group Senior Manager Finance and Administration in 2001 and Chief  perations Officer in 2014. He is a past President of the Association of Mauritian Manufacturers.",
                "qualifications" => [
                    "Fellow member of the Chartered Association of Certified Accountants.",
                    "General Management Program for Mauritius and South East Africa ESSEC",
                    "Advance Management Program from IESE, Barcelona"
                ],
                "core_competence" => [
                    "Accounting and Finance",
                    "Strategy",
                    "Operations",
                    "Fast-Moving Consumer Goods (FMCG) Industry and Market Knowledge."
                ],
                "external_appointments" => [
                    "The Mauritius Chemical and Fertilizer Industry Limited - (Independent Non-Executive Director)"
                ]

            ],
            [
                "id" => 10,
                "image" => asset("images/our-leadership/Management_Team/Bernard_Theys-CEO.png"),
                "name" => "Bernard THEYS",
                "position" => "EXECUTIVE DIRECTOR / CHIEF EXECUTIVE OFFICER",
                "description" => "APPOINTED IN 2013.Non-citizen and resident of Mauritius.",
                "skills" => "Bernard Theys was born in 1965 in Brussels and has held various general management roles in the brewing industry where he has acquired substantial experience in the Fast-Moving Consumer Goods (FMCG) industry.",
                "qualifications" => [
                    "Diploma in Economic Science from Louvain University, Belgium.",
                    "BBA in Business Tourism Management from ICP .",
                    "Several programmes in Executive and Business Education at l'Association Internationale Américaine de Management (MCE) in 1995 and at INSEAD Fontainebleau in France in 2008.",
                    "Advance Management Program from IESE, Barcelona"
                ],
                "core_competence" => [
                    "Management",
                    "Strategic Business Development",
                    "specialised in Operations and FMCG Industry."
                ],
                "external_appointments" => [
                    "none"
                ]

            ],

        ];
        // SEO data will be loaded automatically from database via head.blade.php
        // The system will use the 'our-leadership' route to load SEO data

        return view('our-leadership', [
            'directors' => collect($directors),
            'managements' => collect($managements)
        ]);
    }

    public function corporateGovernance()
    {
        // SEO data will be loaded automatically from database via head.blade.php
        // The system will use the 'corporate-governance' route to load SEO data

        return view('corporate-governance');
    }


    public function ourHeritage()
    {
        // SEO data will be loaded automatically from database via head.blade.php
        // The system will use the 'our-heritage' route to load SEO data

        $historyData = [
            [
                'year_range' => 'A Legacy of Refreshment and Innovation',
                'image' => asset('images/our-heritage/image-1.jpg'),
                'events' => [
                    'Tracing Our Roots: PhoenixBev Journey Through Time',
                    'Our story is one of innovation, dedication, and a commitment to bringing quality refreshment to every corner of the island. Join us as we take a nostalgic look back at the milestones that have shaped who we are today.',
                ],
            ],
            [
                'year_range' => 'Tracing Our Roots',
                'image' => asset('images/our-heritage/image-2.jpg'),
                'events' => [
                    'For decades, PhoenixBev has been an integral part of Mauritian life, evolving from a local beverage producer to a household name.',
                ],
            ],
            [
                'year_range' => '1920s - 1940s',
                'image' => asset('images/our-heritage/Limo-old-3.png'),
                'events' => [
                    'The Early Days - Laying the Foundation',
                    'Before the bustling factories and widespread distribution, PhoenixBevs journey began with a pioneering spirit. This image captures an early delivery truck, proudly bearing the PHOENIX CAMP MINERALS name. Its a testament to the humble beginnings and the tireless efforts of those who laid the groundwork for what would become a beloved Mauritian institution. This era was about establishing a presence and quenching the thirst of a growing nation.',
                ],
            ],
            [
                'year_range' => '1950s - Early 1960s',
                'image' => asset('images/our-heritage/Limo-old-2.png'),
                'events' => [
                    'These scenes highlight our commitment to not just producing beverages, but also bringing joy and refreshment directly to communities and consumers across the island.',
                ],
            ],
            [
                'year_range' => '1950s - Early 1960s',
                'image' => asset('images/our-heritage/Limo-old-4.png'),
                'events' => [
                    'The "Au Terminus" sign with Coca-Cola and Fanta branding indicates our growing presence in local eateries and gathering spots.',
                ],
            ],
            [
                'year_range' => '1960s - 1970s',
                'image' => asset('images/our-heritage/Photo-batiment-inauguration-Phoenix.png'),
                'events' => [
                    ' Stepping into the Future - A New Era of Production',
                    'The mid-1960s marked a significant leap forward for PhoenixBev. The modern architecture of our new facilities, as seen in this image from the inauguration on September 25, 1963, symbolized our ambition and vision for the future. '
                ],
            ],
            [
                'year_range' => '1960s - 1970s',
                'image' => asset('images/our-heritage/Photo-cuve-filtre-Phoenix.png'),
                'events' => [
                    'This was a period of modernization and increased production capacity. The close-up image of intricate factory equipment further illustrates the commitment to advanced processes and quality control that has always been a hallmark of PhoenixBev. This era solidified our position as a leading beverage producer, capable of meeting the evolving demands of the Mauritian market.'
                ],
            ],
        ];
        return view('our-heritage', compact('historyData'));
    }


    public function getTimeline()
    {
        $timelineData = [
            'events' => [
                [
                    'start_date' => ['year' => '1830', 'month' => '01', 'day' => '01'],
                    'end_date' => ['year' => '1938', 'month' => '12', 'day' => '31'],
                    'media' => [
                        'url' => asset("images/our-heritage/image-1.jpg"),
                        'caption' => 'Event in 1800'
                    ],
                    'text' => [
                        'headline' => 'Event in 1830',
                        'text' => 'Ireland Fraser and Blyth Brothers are first founded.'
                    ]
                ],
                [
                    'start_date' => ['year' => '1830', 'month' => '01', 'day' => '01'],
                    'end_date' => ['year' => '1938', 'month' => '12', 'day' => '31'],
                    'media' => [
                        'url' => asset("images/our-heritage/image-2.jpg"),
                        'caption' => 'Event in 1830'
                    ],
                    'text' => [
                        'headline' => 'Event in 1830',
                        'text' => 'Ireland Fraser and Blyth Brothers are first founded.'
                    ]
                ],
                [
                    'start_date' => ['year' => '1939', 'month' => '02', 'day' => '02'],
                    'end_date' => ['year' => '1940', 'month' => '12', 'day' => '31'],
                    'media' => [
                        'url' => asset("images/our-heritage/image-3.jpg"),
                        'caption' => 'Event in 1801'
                    ],
                    'text' => [
                        'headline' => 'Event in 1833',
                        'text' => 'Joseph Lagesse acquires the Mon Loisir H.E. Ltd sugar refinery in northen Mauritius'
                    ]
                ],
                [
                    'start_date' => ['year' => '1939', 'month' => '02', 'day' => '02'],
                    'end_date' => ['year' => '1940', 'month' => '12', 'day' => '31'],
                    'media' => [
                        'url' => asset("images/our-heritage/image-3.jpg"),
                        'caption' => 'Event in 1801'
                    ],
                    'text' => [
                        'headline' => 'Event in 1939',
                        'text' => 'Joseph Lagesse acquires the Mon Loisir H.E. Ltd sugar refinery in northen Mauritius'
                    ]
                ],

            ]
        ];
        return response()->json($timelineData);
    }

    public function operationsStructure()
    {
        // SEO data will be loaded automatically from database via head.blade.php
        // The system will use the 'operations-structure' route to load SEO data

        return view('operation-structure');
    }

    public function holdingCompanies()
    {
        return view('holding-companies', []);
    }

    public function holdingCompaniesPicl()
    {
        return view('holding-companies-picl', []);
    }


    public function holdingCompaniesCicl()
    {
        return view('holding-companies-cicl', []);
    }

    public function integratedReport()
    {
        return view('integrated-report', []);
    }

    public function investorRelations(StockService $stockService)
    {
        $reports = [
            [
                "image" =>  asset("images/investor-relations/reports/annual-report-2024.png"),
                "name" => "PBL_IAR_2024_V1.pdf",
                "document" => asset("Reports/PhoenixBev/pbl_annual_reports/2024/PBL_IAR_2024_V1.pdf"),
                "year" => "2024"
            ],
            [
                "image" =>  asset("images/investor-relations/reports/report-2023.png"),
                "name" => "PhoenixBev_IAR_20231127_annual_report_1.pdf",
                "document" => asset("Reports/PhoenixBev/pbl_annual_reports/2023/PhoenixBev_IAR_20231127_annual_report_1.pdf"),
                "year" => "2023"
            ],
            [
                "image" => asset("images/investor-relations/reports/report-2022.png"),
                "name" => "phoenix_beverages_annual_reports_2022.pdf",
                "document" => asset("Reports/PhoenixBev/pbl_annual_reports/2022/phoenix_beverages_annual_reports_2022.pdf"),
                "year" => "2022"
            ],
            [
                "image" =>  asset("images/investor-relations/reports/report-2021.png"),
                "name" => "phoenixBev-integrated-report-2021.pdf",
                "document" => asset("Reports/PhoenixBev/pbl_annual_reports/2021/phoenixBev-integrated-report-2021.pdf"),
                "year" => "2021"
            ],
            [
                "image" => asset("images/investor-relations/reports/report-2020.png"),
                "name" => "Integrated_Annual_Report_2020.pdf",
                "document" => asset("Reports/PhoenixBev/pbl_annual_reports/2021/Integrated_Annual_Report_2020.pdf"),
                "year" => "2020"
            ]

        ];

        $data = $stockService->getCurrentStockData();

        // SEO data will be loaded automatically from database via head.blade.php
        // The system will use the 'investor-relations' route to load SEO data

        return view('investor-relations', ['reports' => $reports, 'stockData' => $data]);
    }


    public function esg()
    {
        // SEO data will be loaded automatically from database via head.blade.php
        // The system will use the 'esg' route to load SEO data

        return view('esg');
    }

    public function phoenixBev()
    {
        return view('operation-structure/phoenix-bev', []);
    }

    public function edena()
    {
        return view('operation-structure/edena', []);
    }

    public function seybrew()
    {
        return view('operation-structure/seybrew', []);
    }


    public function newsDetails($id)
    {
        try {
            // Find the specific news article
            $specificNews = News::findOrFail($id);

            $pdfUrl = null;
            if (!empty($specificNews->attachments_url)) {
                foreach ($specificNews->attachments_url as $attachment) {
                    if (($attachment['type'] ?? '') === 'pdf') {
                        $pdfUrl = $attachment['url'];
                        break;
                    }
                }
            }

            // Add pdf URL to news object
            $specificNews->pdf = $pdfUrl;

            // Get 3 random news articles excluding the current one
            $randomNews = News::where('id', '!=', $id)
                ->inRandomOrder()
                ->take(3)
                ->get();

            $seo = [
                'title' => $specificNews->title . ' - Phoenix Beverages Group News',
                'description' => Str::limit(strip_tags($specificNews->body), 160),
                'keywords' => $specificNews->tags ?? 'Phoenix Beverages, PBG news, ' . $specificNews->category,
                'image' => $specificNews->featured_image ?? asset('images/news-room/news-default.png'),
                'url' => request()->url(),
                'type' => 'article',
                'canonical' => request()->url()
            ];

            return view('news.news-details', [
                'news' => $specificNews,
                'randomNews' => $randomNews,
                'seo' => $seo
            ]);
        } catch (ModelNotFoundException $e) {
            return view('news.news-details')->with('error', 'News article not found.');
        } catch (Exception $e) {
            Log::error('Error in newsDetails: ' . $e->getMessage());
            return view('news.news-details')->with('error', 'An error occurred while fetching the news.');
        }
    }

    /**
     * Display PDF viewer with encrypted parameters for security
     * 
     * This method uses Laravel's encryption to securely pass PDF URLs and metadata
     * to prevent URL manipulation and unauthorized access to PDF files.
     * 
     * @param Request $request
     * @return \Illuminate\View\View
     */
    public function pdfViewer(Request $request)
    {
        try {
            // Get encrypted data from query parameter
            $encryptedData = $request->query('data');
            
            if (!$encryptedData) {
                return view('pdf-viewer', [
                    'error' => 'No PDF data provided',
                    'title' => 'Error',
                    'backUrl' => '/'
                ]);
            }

            // Decrypt the data
            try {
                $decryptedData = decrypt($encryptedData);
                $data = json_decode($decryptedData, true);
                
                if (!$data || !isset($data['url'])) {
                    throw new Exception('Invalid encrypted data structure');
                }
                
                $pdfUrl = $data['url'];
                $title = $data['title'] ?? 'PDF Document';
                $backUrl = $data['back'] ?? '/';
                
            } catch (Exception $e) {
                Log::error('Failed to decrypt PDF viewer data: ' . $e->getMessage());
                return view('pdf-viewer', [
                    'error' => 'Invalid or corrupted PDF data',
                    'title' => 'Error',
                    'backUrl' => '/'
                ]);
            }

            // Log for debugging (without sensitive data)
            Log::info('PDF Viewer Request:', [
                'title' => $title,
                'back' => $backUrl,
                'url_length' => strlen($pdfUrl)
            ]);

            // Validate PDF URL
            if (empty($pdfUrl) || !str_contains(strtolower($pdfUrl), '.pdf')) {
                Log::error('Invalid PDF URL - empty or not a PDF');
                return view('pdf-viewer', [
                    'error' => 'Invalid PDF URL - must be a PDF file',
                    'title' => 'Error',
                    'backUrl' => $backUrl
                ]);
            }

            // Additional security: Validate that the URL is from our domain or allowed domains
            $allowedDomains = [
                parse_url(config('app.url'), PHP_URL_HOST),
                'localhost',
                '127.0.0.1'
            ];
            
            $urlHost = parse_url($pdfUrl, PHP_URL_HOST);
            if ($urlHost && !in_array($urlHost, $allowedDomains) && !str_starts_with($pdfUrl, '/')) {
                Log::error('Unauthorized PDF URL domain: ' . $urlHost);
                return view('pdf-viewer', [
                    'error' => 'Unauthorized PDF source',
                    'title' => 'Error',
                    'backUrl' => $backUrl
                ]);
            }

            $seo = [
                'title' => $title . ' - PDF Viewer - Phoenix Beverages Group',
                'description' => 'View ' . $title . ' in our interactive PDF reader',
                'keywords' => 'Phoenix Beverages, PDF viewer, interactive reader, ' . $title,
                'image' => asset('images/logo.png'),
                'url' => request()->url(),
                'type' => 'article',
                'canonical' => request()->url()
            ];

            return view('pdf-viewer', [
                'pdfUrl' => $pdfUrl,
                'title' => $title,
                'backUrl' => $backUrl,
                'seo' => $seo
            ]);
        } catch (Exception $e) {
            Log::error('Error in pdfViewer: ' . $e->getMessage());
            return view('pdf-viewer', [
                'error' => 'An error occurred while loading the PDF viewer.',
                'title' => 'Error',
                'backUrl' => '/'
            ]);
        }
    }

    /**
     * Generate encrypted URL for PDF viewer
     * 
     * @param string $pdfUrl The PDF file URL
     * @param string $title The PDF title
     * @param string $backUrl The back navigation URL
     * @return string The encrypted PDF viewer URL
     */
    public static function generatePdfViewerUrl($pdfUrl, $title = 'PDF Document', $backUrl = '/')
    {
        $data = [
            'url' => $pdfUrl,
            'title' => $title,
            'back' => $backUrl,
            'timestamp' => time() // Add timestamp for additional security
        ];
        
        $encryptedData = encrypt(json_encode($data));
        return route('pdf.viewer') . '?data=' . urlencode($encryptedData);
    }

    public function alcoholicDrink()
    {
        return view('alcoholic-drink');
    }


    public function nonAlcoholicDrink()
    {
        return view('non-alcoholic-drink');
    }

    public function annualReport()
    {
        return view('reports.annual-report');
    }

    public function integratedReportResult()
    {
        return view('reports.integrated-report', []);
    }


    public function  pblarchiveReport()
    {
        return view('reports.pbl-arch-report', []);
    }

    public function piclHoldingsReport()
    {
        return view('reports.picl-holdings-arch-report', []);
    }

    public function ciclHoldingsReport()
    {
        return view('reports.cicl-holdings-arch-report', []);
    }

    public function pbgIntegratedReport($year = null)
    {
        if ($year == null) {
            $year = Carbon::now()->subYear()->format('Y');
        }

        $viewName = 'pbl-integrated-report/report-' . $year;

        if (View::exists($viewName)) {
            return view($viewName, ['year' => $year]);
        } else {
            abort(404, 'Integrated Report for the year ' . $year . ' not found');
        }
    }

    public function piclAnnualReport($year = null)
    {
        if ($year == null) {
            $year = Carbon::now()->subYear()->format('Y');
        }

        $viewName = 'shareholders-integrated-report/picl-annual-report-' . $year;

        if (View::exists($viewName)) {
            return view($viewName, ['year' => $year]);
        } else {
            abort(404, 'Annual Report for the year ' . $year . ' not found');
        }
    }


    public function ciclAnnualReport($year = null)
    {
        if ($year == null) {
            $year = Carbon::now()->subYear()->format('Y');
        }

        $viewName = 'shareholders-integrated-report/cicl-annual-report-' . $year;

        if (View::exists($viewName)) {
            return view($viewName, ['year' => $year]);
        } else {
            abort(404, 'Annual Report for the year ' . $year . ' not found');
        }
    }

    /**
     * Show password entry page
     */
    public function showPasswordEntry()
    {
        $pageId = session()->get('protected_page_id');
        
        if (!$pageId) {
            abort(404, 'No protected page found');
        }
        
        $pageSetting = \App\Models\PageSetting::findOrFail($pageId);
        
        return view('page-password-entry', [
            'pageSetting' => $pageSetting
        ]);
    }

    /**
     * Verify password and grant access
     */
    public function verifyPassword(Request $request)
    {
        $request->validate([
            'password' => 'required|string',
        ]);

        $pageId = session()->get('protected_page_id');
        
        if (!$pageId) {
            return redirect('/')->withErrors(['password' => 'Session expired. Please try again.']);
        }
        
        $pageSetting = \App\Models\PageSetting::findOrFail($pageId);
        
        if ($pageSetting->checkPassword($request->password)) {
            // Store verification in session (valid for 24 hours)
            session()->put('page_verified_' . $pageSetting->id, true);
            session()->put('page_verified_time_' . $pageSetting->id, now());
            
            // Clear the protected page ID from session
            session()->forget('protected_page_id');
            
            return redirect($pageSetting->page_url);
        }

        return back()->withErrors(['password' => 'Invalid password. Please try again.'])->withInput();
    }

    public function shareholders(StockService $stockService)
    {
        $pageData = $stockService->getShareholdersPageData();

        return view('shareholders', [
            'stockInfo' => $pageData['stock_info'],
            'financialMetrics' => $pageData['financial_metrics'],
            'sharePriceTrend' => $pageData['share_price_trend']
        ]);
    }


    private function convertDateToTimestamp($dateStr)
    {
        $dateStr = str_replace(',', '', $dateStr);
        return strtotime($dateStr);
    }


    public function privacy()
    {
        return view('privacy');
    }

    public function cookie()
    {
        return view('cookies');
    }


    public function terms_conditions()
    {
        return view('terms_conditions');
    }


    public function careers()
    {
        return view('careers');
    }

    public function submitCareers(Request $request)
    {
        try {
            // Spam detection
            $spamDetection = new \App\Services\SpamDetectionService();

            if ($spamDetection->isSpam($request, 'career')) {
                $spamDetection->flagSpamIp($request->ip());
                return response()->json([
                    'status' => 'error',
                    'message' => 'Your submission has been flagged as spam. Please try again later.'
                ], 400);
            }

            // Validate the request
            $validated = $request->validate([
                'full_name' => 'required|min:3|max:50',
                'email' => 'required|email',
                'phone_number' => 'required|min:10|max:20',
                'message' => 'nullable|string|min:10|max:1000',
                'cv' => 'required|file|mimes:pdf,doc,docx|max:5120', // max 5MB
                'h-recaptcha-response' => 'required',
                'form_start_time' => 'required|integer'
            ]);

            // Verify hCaptcha
            $hcaptchaResponse = $request->input('h-recaptcha-response');
            $hcaptchaSecret = env('NOCAPTCHA_SECRET');
            $verifyUrl = 'https://hcaptcha.com/siteverify';

            $data = [
                'secret' => $hcaptchaSecret,
                'response' => $hcaptchaResponse
            ];

            $options = [
                'http' => [
                    'header' => "Content-type: application/x-www-form-urlencoded\r\n",
                    'method' => 'POST',
                    'content' => http_build_query($data)
                ]
            ];

            $context = stream_context_create($options);
            $verifyResponse = file_get_contents($verifyUrl, false, $context);
            $captchaSuccess = json_decode($verifyResponse);

            if (!$captchaSuccess->success) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Invalid captcha'
                ], 422);
            }

            // Handle file upload
            if ($request->hasFile('cv')) {
                $file = $request->file('cv');
                $fileName = time() . '_' . Str::slug($request->full_name) . '.' . $file->getClientOriginalExtension();
                $filePath = $file->storeAs('careers/cv', $fileName, 'public');
            }

            // Generate case ID
            $caseId = 'CAREER-' . strtoupper(Str::random(8));

            // Store in database
            $application = CareerApplication::create([
                'case_id' => $caseId,
                'full_name' => $request->full_name,
                'email' => $request->email,
                'phone_number' => $request->phone_number,
                'message' => $request->message,
                'cv_path' => $filePath,
                'status' => 'pending'
            ]);

            // Prepare data for emails
            $emailData = [
                'full_name' => $request->full_name,
                'email' => $request->email,
                'phone_number' => $request->phone_number,
                'message' => $request->message,
                'case_id' => $caseId,
                'cv_path' => $filePath
            ];

            // Send email to admin
            Mail::to('hr@phoenixbeverages.mu')->send(new \App\Mail\CareerApplication($emailData));

            // Send email to applicant
            Mail::to($request->email)->send(new CareerApplicationApplicant($emailData));

            return response()->json([
                'status' => 'success',
                'data' => $caseId
            ]);
        } catch (\Exception $e) {
            Log::error('Career submission error: ' . $e->getMessage());
            return response()->json([
                'status' => 'error',
                'message' => 'Something went wrong. Please try again later.'
            ], 500);
        }
    }

    public function generalCampaign()
    {
        return view('general-campaign');
    }

    public function acquisition()
    {
        return view('acquisition');
    }

    public function virtualtours()
    {
        return view('virtualtours', []);
    }

    public function engVirtualtours()
    {
        return view('virtualtours/eng-virtualtours', []);
    }

    public function frnVirtualtours()
    {
        return view('virtualtours/frn-virtualtours', []);
    }







}
