<?php

namespace App\Console\Commands;

use App\Jobs\FetchStockData;
use Illuminate\Console\Command;

class StockDataCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:run-stock-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fetch stock data from the API';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        dispatch(new FetchStockData());
        $this->info('Job dispatched!');
    }
}
